/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.MissingSvnClientPanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MissingSvnClient
implements ActionListener {
    private final MissingSvnClientPanel panel = new MissingSvnClientPanel();

    public MissingSvnClient() {
        this.panel.browseButton.addActionListener(this);
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
    }

    void show() {
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        JButton jButton2 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)this.panel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), 2, 0, new Object[]{jButton, jButton2}, (Object)jButton);
        if (DialogDisplayer.getDefault().notify(notifyDescriptor) == jButton) {
            SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
        }
    }

    private void onBrowseClick() {
        File file = this.getExecutableFile();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.panel.executablePathTextField.setText(file2.getAbsolutePath());
        }
    }

    private File getExecutableFile() {
        String string = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(string));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        }
    }
}

