/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CreateCopyAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Copy";
    }

    protected int getFileEnabledStatus() {
        return -4;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1 && this.getContext(nodeArray).getRoots().size() > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        SVNUrl sVNUrl2;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        File file = context.getRootFiles()[0];
        File[] fileArray = Subversion.getInstance().getStatusCache().listFiles(context, 6612);
        boolean bl = fileArray.length > 0;
        try {
            sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
            sVNUrl = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl2, sVNUrl, SVNRevision.HEAD);
        final CreateCopy createCopy = new CreateCopy(repositoryFile, file, bl);
        if (createCopy.showDialog()) {
            ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

                public void perform() {
                    CreateCopyAction.this.performCopy(createCopy, this);
                }
            };
            progressSupport.start(this.createRequestProcessor(nodeArray));
        }
    }

    private void performCopy(CreateCopy createCopy, SvnProgressSupport svnProgressSupport) {
        RepositoryFile repositoryFile = createCopy.getToRepositoryFile();
        try {
            Object object;
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            if (!repositoryFile.isRepositoryRoot()) {
                ISVNInfo iSVNInfo;
                block16: {
                    object = repositoryFile.removeLastSegment().getFileUrl();
                    iSVNInfo = null;
                    try {
                        iSVNInfo = svnClient.getInfo((SVNUrl)object);
                    }
                    catch (SVNClientException sVNClientException) {
                        if (SvnClientExceptionHandler.isWrongUrl(sVNClientException.getMessage())) break block16;
                        throw sVNClientException;
                    }
                }
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                if (iSVNInfo == null) {
                    svnClient.mkdir((SVNUrl)object, true, "[Netbeans SVN client generated message: create a new folder for the copy]: '\n" + createCopy.getMessage() + "\n'");
                } else if (createCopy.getLocalFile().isFile()) {
                    throw new SVNClientException("File allready exists");
                }
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            if (createCopy.isLocal()) {
                svnClient.copy(createCopy.getLocalFile(), repositoryFile.getFileUrl(), createCopy.getMessage());
            } else {
                object = createCopy.getFromRepositoryFile();
                svnClient.copy(((RepositoryFile)object).getFileUrl(), repositoryFile.getFileUrl(), createCopy.getMessage(), ((RepositoryFile)object).getRevision());
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            if (createCopy.switchTo()) {
                SwitchToAction.performSwitch(repositoryFile, createCopy.getLocalFile(), svnProgressSupport);
            }
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }
}

