/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.Merge;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Merge";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1 && this.getContext(nodeArray).getRoots().size() > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        SVNUrl sVNUrl2;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        final File file = context.getRootFiles()[0];
        try {
            sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        final RepositoryFile repositoryFile = new RepositoryFile(sVNUrl2, sVNUrl, SVNRevision.HEAD);
        final Merge merge = new Merge(repositoryFile, file);
        if (merge.showDialog()) {
            ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

                public void perform() {
                    MergeAction.this.performMerge(merge, repositoryFile, file, this);
                }
            };
            progressSupport.start(this.createRequestProcessor(nodeArray));
        }
    }

    private void performMerge(Merge merge, RepositoryFile repositoryFile, File file, SvnProgressSupport svnProgressSupport) {
        File[][] fileArray = Utils.splitFlatOthers((File[])new File[]{file});
        boolean bl = fileArray[0].length <= 0;
        try {
            SVNRevision sVNRevision;
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            SVNUrl sVNUrl = merge.getMergeEndUrl();
            SVNRevision sVNRevision2 = merge.getMergeEndRevision();
            SVNUrl sVNUrl2 = merge.getMergeStartUrl();
            if (sVNUrl2 != null) {
                sVNRevision = merge.getMergeStartRevision();
            } else {
                sVNUrl2 = sVNUrl;
                ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(sVNUrl2, (SVNRevision)new SVNRevision.Number(0L), (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, false, 0L);
                sVNRevision = iSVNLogMessageArray[0].getRevision();
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            svnClient.merge(sVNUrl2, sVNRevision, sVNUrl, sVNRevision2, file, false, bl);
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }
}

