/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private Map<SVNUrl, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private boolean filterUsername;
    private boolean filterMessage;
    private int completedSearches;
    private boolean searchCanceled;
    private List<RepositoryRevision> results = new ArrayList<RepositoryRevision>();

    public SearchExecutor(SearchHistoryPanel searchHistoryPanel) {
        this.master = searchHistoryPanel;
        this.criteria = searchHistoryPanel.getCriteria();
        this.filterUsername = this.criteria.getUsername() != null;
        this.filterMessage = this.criteria.getCommitMessage() != null;
        this.pathToRoot = new HashMap<String, File>();
        try {
            if (this.searchingUrl()) {
                String string = SvnUtils.getRepositoryPath(searchHistoryPanel.getRoots()[0]);
                this.pathToRoot.put(string, searchHistoryPanel.getRoots()[0]);
            } else {
                this.workFiles = new HashMap<SVNUrl, Set<File>>();
                for (File file : searchHistoryPanel.getRoots()) {
                    this.populatePathToRoot(file);
                    SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
                    Set<File> set = this.workFiles.get(sVNUrl);
                    if (set == null) {
                        set = new HashSet<File>(2);
                        this.workFiles.put(sVNUrl, set);
                    }
                    set.add(file);
                }
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
    }

    private void populatePathToRoot(File file) throws SVNClientException {
        String string = SvnUtils.getRepositoryPath(file);
        String string2 = file.getAbsolutePath().replace(File.separatorChar, '/');
        int n = this.getCommonPostfixLength(string, string2);
        this.pathToRoot.put(string.substring(0, string.length() - n), new File(string2.substring(0, string2.length() - n)));
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (File file2 : fileArray) {
            if (Subversion.getInstance().isAdministrative(file2)) continue;
            int n2 = fileStatusCache.getStatus(file2).getStatus();
            if ((!file2.isDirectory() || (n2 & 0xFFFFFFF8) == 0) && (n2 & 0xFFFFFFF8) == 0) continue;
            this.populatePathToRoot(file2);
        }
    }

    private int getCommonPostfixLength(String string, String string2) {
        int n = string.length() - 1;
        int n2 = -1;
        for (int i = string2.length() - 1; n >= 0 && i >= 0; --n, --i) {
            char c = string.charAt(n);
            char c2 = string2.charAt(i);
            if (c == '/') {
                n2 = n;
            }
            if (c == c2) continue;
            if (n2 <= -1) break;
            return string.length() - n2;
        }
        return string.length() - n - 1;
    }

    @Override
    public void run() {
        final SVNRevision sVNRevision = this.criteria.getFrom();
        final SVNRevision sVNRevision2 = this.criteria.getTo();
        this.completedSearches = 0;
        if (this.searchingUrl()) {
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(this.master.getRepositoryUrl());
            SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                public void perform() {
                    SearchExecutor.this.search(SearchExecutor.this.master.getRepositoryUrl(), null, sVNRevision, sVNRevision2, this);
                }
            };
            svnProgressSupport.start(requestProcessor, this.master.getRepositoryUrl(), NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
        } else {
            for (final SVNUrl sVNUrl : this.workFiles.keySet()) {
                final Set<File> set = this.workFiles.get(sVNUrl);
                RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
                SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                    public void perform() {
                        SearchExecutor.this.search(sVNUrl, set, sVNRevision, sVNRevision2, this);
                    }
                };
                svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
            }
        }
    }

    private void search(SVNUrl sVNUrl, Set<File> set, SVNRevision sVNRevision, SVNRevision sVNRevision2, SvnProgressSupport svnProgressSupport) {
        block14: {
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(sVNUrl, svnProgressSupport);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            if (svnProgressSupport.isCanceled()) {
                this.searchCanceled = true;
                return;
            }
            if (this.searchingUrl()) {
                try {
                    ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(sVNUrl, null, sVNRevision, sVNRevision2, false, true, 0L);
                    this.appendResults(sVNUrl, iSVNLogMessageArray);
                }
                catch (SVNClientException sVNClientException) {
                    if (!SvnClientExceptionHandler.handleLogException(sVNUrl, sVNRevision2, sVNClientException)) {
                        svnProgressSupport.annotate(sVNClientException);
                    }
                    break block14;
                }
            }
            String[] stringArray = new String[set.size()];
            int n = 0;
            try {
                for (File file : set) {
                    stringArray[n++] = SvnUtils.getRelativePath(sVNUrl, file);
                }
                ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(sVNUrl, stringArray, sVNRevision, sVNRevision2, false, true);
                this.appendResults(sVNUrl, iSVNLogMessageArray);
            }
            catch (SVNClientException sVNClientException) {
                block15: {
                    try {
                        if (SvnClientExceptionHandler.isHTTP403(sVNClientException.getMessage())) {
                            for (String string : stringArray) {
                                ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(sVNUrl.appendPath(string), null, sVNRevision, sVNRevision2, false, true, 0L);
                                this.appendResults(sVNUrl, iSVNLogMessageArray);
                            }
                            return;
                        }
                    }
                    catch (SVNClientException sVNClientException2) {
                        if (SvnClientExceptionHandler.handleLogException(sVNUrl, sVNRevision2, sVNClientException)) break block15;
                        svnProgressSupport.annotate(sVNClientException2);
                    }
                }
                if (SvnClientExceptionHandler.handleLogException(sVNUrl, sVNRevision2, sVNClientException)) break block14;
                svnProgressSupport.annotate(sVNClientException);
            }
        }
    }

    private synchronized void appendResults(SVNUrl sVNUrl, ISVNLogMessage[] iSVNLogMessageArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = iSVNLogMessageArray.length - 1; i >= 0; --i) {
            ISVNLogMessage iSVNLogMessage = iSVNLogMessageArray[i];
            if (this.filterUsername && !this.criteria.getUsername().equals(iSVNLogMessage.getAuthor()) || this.filterMessage && iSVNLogMessage.getMessage().indexOf(this.criteria.getCommitMessage()) == -1) continue;
            RepositoryRevision repositoryRevision = new RepositoryRevision(iSVNLogMessage, sVNUrl);
            for (RepositoryRevision.Event event : repositoryRevision.getEvents()) {
                String string;
                if (event.getChangedPath().getAction() == 'A' && event.getChangedPath().getCopySrcPath() != null) {
                    string = (String)hashMap.get(event.getChangedPath().getPath());
                    if (string == null) {
                        string = event.getChangedPath().getPath();
                    }
                    hashMap.put(event.getChangedPath().getCopySrcPath(), string);
                }
                string = event.getChangedPath().getPath();
                for (String string2 : hashMap.keySet()) {
                    if (!string.startsWith(string2) || string.length() != string2.length() && string.charAt(string2.length()) != '/') continue;
                    string = (String)hashMap.get(string2) + string.substring(string2.length());
                    break;
                }
                File file = this.computeFile(string);
                event.setFile(file);
            }
            this.results.add(repositoryRevision);
        }
        this.checkFinished();
    }

    private boolean searchingUrl() {
        return this.master.getRepositoryUrl() != null;
    }

    private File computeFile(String string) {
        for (String string2 : this.pathToRoot.keySet()) {
            if (!string.startsWith(string2)) continue;
            return new File(this.pathToRoot.get(string2), string.substring(string2.length()));
        }
        return null;
    }

    private void checkFinished() {
        ++this.completedSearches;
        if (this.searchingUrl() && this.completedSearches >= 1 || this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchExecutor.this.master.setResults(SearchExecutor.this.results);
                }
            });
        }
    }
}

