/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.commit.ConflictResolvedAction;
import org.netbeans.modules.subversion.ui.commit.DeleteLocalAction;
import org.netbeans.modules.subversion.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.status.OpenInEditorAction;
import org.netbeans.modules.subversion.ui.status.SyncFileNode;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class SyncTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private SyncFileNode[] nodes = new SyncFileNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Node.Property property = (Node.Property)object;
            Node.Property property2 = (Node.Property)object2;
            String string = (String)property.getValue("sortkey");
            if (string != null) {
                String string2 = (String)property2.getValue("sortkey");
                return string.compareToIgnoreCase(string2);
            }
            try {
                String string3 = (String)property.getValue();
                String string4 = (String)property2.getValue();
                return string3.compareToIgnoreCase(string4);
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.SEVERE, null, exception);
                return 0;
            }
        }
    };

    public SyncTable() {
        Object object = NbBundle.getBundle(SyncTable.class);
        columnLabels.put("branch", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_Branch_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_Branch_Desc")});
        columnLabels.put("name", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_File_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_File_Desc")});
        columnLabels.put("status", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_Status_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_Status_Desc")});
        columnLabels.put("path", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_Path_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        object = UIManager.getColor("scrollpane_border");
        if (object == null) {
            object = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)object));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SyncTable.class, (String)"ACSN_VersioningTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SyncTable.class, (String)"ACSD_VersioningTable"));
        this.setColumns(new String[]{"name", "status", "path"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyncTable.this.showPopup(Utils.getPositionForPopup((JTable)SyncTable.this.table));
            }
        });
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block5: {
                    int n;
                    block4: {
                        n = SyncTable.this.table.getWidth();
                        if (SyncTable.this.tableColumns.length != 3) break block4;
                        for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                            if ("path".equals(SyncTable.this.tableColumns[i])) {
                                SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 60 / 100);
                                continue;
                            }
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 20 / 100);
                        }
                        break block5;
                    }
                    if (SyncTable.this.tableColumns.length != 4) break block5;
                    for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                        if ("path".equals(SyncTable.this.tableColumns[i])) {
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 55 / 100);
                            continue;
                        }
                        SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 15 / 100);
                    }
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public SyncFileNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        SyncFileNode[] syncFileNodeArray = new SyncFileNode[n];
        for (int i = 0; i < n; ++i) {
            syncFileNodeArray[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return syncFileNodeArray;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.tableColumns)) {
            return;
        }
        this.setModelProperties(stringArray);
        this.tableColumns = stringArray;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(String[] stringArray) {
        Node.Property[] propertyArray = new Node.Property[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = columnLabels.get(string);
            propertyArray[i] = new ColumnDescriptor(string, String.class, stringArray2[0], stringArray2[1]);
        }
        this.tableModel.setProperties(propertyArray);
    }

    void setTableModel(SyncFileNode[] syncFileNodeArray) {
        this.nodes = syncFileNodeArray;
        this.tableModel.setNodes((Node[])syncFileNodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    private void showPopup(final MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            boolean bl = true;
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPopupMenu jPopupMenu = SyncTable.this.getPopup();
                jPopupMenu.show(SyncTable.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    private void showPopup(Point point) {
        JPopupMenu jPopupMenu = this.getPopup();
        jPopupMenu.show(this.table, point.x, point.y);
    }

    private JPopupMenu getPopup() {
        SystemActionBridge systemActionBridge;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(new OpenInEditorAction());
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)SystemAction.get(DiffAction.class), this.actionString("CTL_PopupMenuItem_Diff")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)SystemAction.get(UpdateAction.class), this.actionString("CTL_PopupMenuItem_Update")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)SystemAction.get(CommitAction.class), this.actionString("CTL_PopupMenuItem_Commit")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)SystemAction.get(ConflictResolvedAction.class), NbBundle.getMessage(SyncTable.class, (String)"CTL_PopupMenuItem_ConflictResolved")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)SystemAction.get(BlameAction.class), ((BlameAction)SystemAction.get(BlameAction.class)).visible(null) ? this.actionString("CTL_PopupMenuItem_HideBlame") : this.actionString("CTL_PopupMenuItem_Blame")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)SystemAction.get(SearchHistoryAction.class), this.actionString("CTL_PopupMenuItem_SearchHistory")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.addSeparator();
        ExcludeFromCommitAction excludeFromCommitAction = (ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class);
        String string = excludeFromCommitAction.getActionStatus(null) == 2 ? NbBundle.getMessage(SyncTable.class, (String)"CTL_PopupMenuItem_IncludeInCommit") : NbBundle.getMessage(SyncTable.class, (String)"CTL_PopupMenuItem_ExcludeFromCommit");
        jMenuItem = jPopupMenu.add((Action)new SystemActionBridge((Action)((Object)excludeFromCommitAction), string));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        boolean bl = true;
        boolean bl2 = true;
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = SvnUtils.getCurrentContext(null).getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if ((fileInformation.getStatus() & 0x1004) == 0) {
                bl = false;
            }
            if (fileInformation.getStatus() == 2048 || fileInformation.getStatus() == 256) continue;
            bl2 = false;
        }
        if (bl) {
            SystemAction systemAction = SystemAction.get(DeleteLocalAction.class);
            systemActionBridge = new SystemActionBridge((Action)systemAction, this.actionString("CTL_PopupMenuItem_Delete"));
        } else {
            systemActionBridge = bl2 ? new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_RevertDelete")) : new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_GetClean"));
        }
        jMenuItem = jPopupMenu.add((Action)systemActionBridge);
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        SystemActionBridge systemActionBridge2 = new SystemActionBridge((Action)SystemAction.get(IgnoreAction.class), ((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(fileArray) == 2 ? this.actionString("CTL_PopupMenuItem_Unignore") : this.actionString("CTL_PopupMenuItem_Ignore"));
        jMenuItem = jPopupMenu.add((Action)systemActionBridge2);
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        return jPopupMenu;
    }

    private String actionString(String string) {
        ResourceBundle resourceBundle = NbBundle.getBundle(Annotator.class);
        return resourceBundle.getString(string);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            Action action = this.nodes[n = this.sorter.modelIndex(n)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ArrayList<SyncFileNode> arrayList = new ArrayList<SyncFileNode>();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        final TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (topComponent == null) {
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        if (n != -1) {
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                int n3 = this.sorter.modelIndex(i);
                arrayList.add(this.nodes[n3]);
            }
        }
        final Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        if (SwingUtilities.isEventDispatchThread()) {
            topComponent.setActivatedNodes(nodeArray);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    topComponent.setActivatedNodes(nodeArray);
                }
            });
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            Object object2;
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                object2 = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(n)];
                if (!bl) {
                    object = "<html>" + ((SyncFileNode)((Object)object2)).getHtmlDisplayName();
                }
                if (SvnModuleConfig.getDefault().isExcludedFromCommit(((SyncFileNode)((Object)object2)).getFile().getAbsolutePath())) {
                    String string = object2.getDisplayName();
                    object = bl ? "<html><s>" + string + "</s></html>" : "<html><s>" + Subversion.getInstance().getAnnotator().annotateNameHtml(string, ((SyncFileNode)((Object)object2)).getFileInformation(), null) + "</s>";
                }
            }
            if ((component = n3 == 2 ? this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JComponent) {
                object2 = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(n)].getFile().getAbsolutePath();
                ((JComponent)component).setToolTipText((String)object2);
            }
            return component;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

