/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportPreviewStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep;
import org.netbeans.modules.subversion.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class ImportWizard
implements ChangeListener {
    private WizardDescriptor.Panel[] panels;
    private RepositoryStep repositoryStep;
    private ImportStep importStep;
    private ImportPreviewStep importPreviewStep;
    private String errorMessage;
    private WizardDescriptor wizardDescriptor;
    private PanelsIterator wizardIterator;
    private final Context context;

    public ImportWizard(Context context) {
        this.context = context;
    }

    public boolean show() {
        boolean bl;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(ImportWizard.class, (String)"CTL_Import"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportWizard.class, (String)"CTL_Import"));
        dialog.setVisible(true);
        dialog.toFront();
        Object object = this.wizardDescriptor.getValue();
        boolean bl2 = bl = object == WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            if (object == WizardDescriptor.CLOSED_OPTION || object == WizardDescriptor.CANCEL_OPTION) {
                this.repositoryStep.stop();
                this.importStep.stop();
            }
        } else if (object == WizardDescriptor.FINISH_OPTION) {
            if (this.wizardIterator.current() == this.importStep) {
                this.setupImportPreviewStep();
            } else if (this.wizardIterator.current() == this.importPreviewStep) {
                this.importPreviewStep.storeTableSorter();
            }
        }
        return bl;
    }

    private void setupImportPreviewStep() {
        String string = this.repositoryStep.getRepositoryFile().getRepositoryUrl().toString();
        String string2 = this.importStep.getRepositoryFolderUrl().toString();
        String string3 = this.context.getRootFiles()[0].getAbsolutePath();
        this.importPreviewStep.setup(string2.substring(string.length()), string3);
    }

    private void setErrorMessage(String string) {
        this.errorMessage = string;
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wizardIterator == null) {
            return;
        }
        AbstractStep abstractStep = (AbstractStep)this.wizardIterator.current();
        if (abstractStep == null) {
            return;
        }
        this.setErrorMessage(abstractStep.getErrorMessage());
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryStep.getRepositoryFile().getRepositoryUrl();
    }

    public String getMessage() {
        return this.importStep.getImportMessage();
    }

    public SVNUrl getRepositoryFolderUrl() {
        return this.importStep.getRepositoryFolderUrl();
    }

    public Map getCommitFiles() {
        return this.importPreviewStep.getCommitFiles();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[3];
            ImportWizard.this.repositoryStep = new RepositoryStep("org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.import");
            ImportWizard.this.repositoryStep.addChangeListener(ImportWizard.this);
            File file = ImportWizard.this.context.getRootFiles()[0];
            ImportWizard.this.importStep = new ImportStep(new BrowserAction[]{new CreateFolderAction(file.getName())}, file);
            ImportWizard.this.importStep.addChangeListener(ImportWizard.this);
            ImportWizard.this.importPreviewStep = new ImportPreviewStep(ImportWizard.this.context);
            panelArray = new WizardDescriptor.Panel[]{ImportWizard.this.repositoryStep, ImportWizard.this.importStep, ImportWizard.this.importPreviewStep};
            String[] stringArray = new String[panelArray.length];
            for (int i = 0; i < panelArray.length; ++i) {
                Component component = panelArray[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panelArray;
        }

        public void previousPanel() {
            if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.importStep.invalid(null);
            }
            super.previousPanel();
        }

        public void nextPanel() {
            if (this.current() == ImportWizard.this.repositoryStep) {
                File file = ImportWizard.this.context.getRootFiles()[0];
                ImportWizard.this.importStep.setup(ImportWizard.this.repositoryStep.getRepositoryFile().appendPath(file.getName()));
            } else if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.setupImportPreviewStep();
            }
            super.nextPanel();
            if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.importStep.validateUserInput();
            }
        }
    }
}

