/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.urlpatternstep;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.urlpatternstep.URLPatternPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class URLPatternStep
extends AbstractStep
implements DocumentListener,
ActionListener,
FocusListener,
ItemListener {
    private URLPatternPanel urlPatternPanel;
    private RepositoryPaths repositoryPaths;

    public HelpCtx getHelp() {
        return new HelpCtx(URLPatternStep.class);
    }

    protected JComponent createComponent() {
        if (this.urlPatternPanel == null) {
            this.urlPatternPanel = new URLPatternPanel();
            this.urlPatternPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
            this.urlPatternPanel.depthComboBox.addItemListener(this);
            this.urlPatternPanel.depthComboBox.addFocusListener(this);
            this.urlPatternPanel.anyURLCheckBox.addActionListener(this);
            this.urlPatternPanel.useFolderRadioButton.addActionListener(this);
            this.urlPatternPanel.useSubfolderRadioButton.addActionListener(this);
        }
        return this.urlPatternPanel;
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.repositoryPaths == null) {
            this.repositoryPaths = new RepositoryPaths(repositoryFile, this.urlPatternPanel.repositoryPathTextField, this.urlPatternPanel.browseRepositoryButton, null, null);
            String string = NbBundle.getMessage(URLPatternStep.class, (String)"LBL_BrowserMessage");
            int n = 9;
            this.repositoryPaths.setupBehavior(string, n, "org.netbeans.modules.subversion.ui.browser.urlpattern", null);
        } else {
            this.repositoryPaths.setRepositoryFile(repositoryFile);
        }
        this.urlPatternPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.validateUserInput();
    }

    protected void validateBeforeNext() {
    }

    private void validateUserInput() {
        if (this.urlPatternPanel.repositoryPathTextField.getText().trim().equals("")) {
            this.setInvalid(NbBundle.getMessage(URLPatternStep.class, (String)"MSG_MissingFolder"));
            return;
        }
        this.refreshPreview();
        this.valid();
    }

    private void setInvalid(String string) {
        this.invalid(string);
        this.urlPatternPanel.previewLabel.setText(" ");
    }

    private void refreshPreview() {
        this.urlPatternPanel.previewLabel.setText(this.getPattern(true));
    }

    private String getGroupiefiedPath(int n, boolean bl) {
        int n2;
        String[] stringArray = this.urlPatternPanel.repositoryPathTextField.getText().split("/");
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (n2 == n) {
                stringBuffer.append("/(");
                if (bl) {
                    stringBuffer.append("<b>");
                }
                stringBuffer.append(stringArray[n2]);
                if (bl) {
                    stringBuffer.append("</b>");
                }
                stringBuffer.append(")");
                continue;
            }
            stringBuffer.append("/");
            stringBuffer.append(stringArray[n2]);
        }
        if (n >= stringArray.length) {
            for (n2 = stringArray.length; n2 <= n; ++n2) {
                if (n2 == n) {
                    stringBuffer.append("/");
                    if (bl) {
                        stringBuffer.append("<b>");
                    }
                    stringBuffer.append("(.+?)");
                    if (!bl) continue;
                    stringBuffer.append("</b>");
                    continue;
                }
                stringBuffer.append("/.*");
            }
        }
        stringBuffer.append("/.*");
        return stringBuffer.toString();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.validateUserInput();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.urlPatternPanel.depthComboBox && !this.urlPatternPanel.useSubfolderRadioButton.isSelected()) {
            this.urlPatternPanel.useSubfolderRadioButton.setSelected(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.validateUserInput();
    }

    public String getPattern() {
        return this.getPattern(false);
    }

    private String getPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("<html>");
        }
        if (this.urlPatternPanel.anyURLCheckBox.isSelected()) {
            stringBuffer.append(".*");
        } else {
            stringBuffer.append(this.repositoryPaths.getRepositoryUrl().toString());
        }
        if (this.urlPatternPanel.useFolderRadioButton.isSelected()) {
            stringBuffer.append("/");
            if (bl) {
                stringBuffer.append("<b>");
            }
            stringBuffer.append(this.urlPatternPanel.repositoryPathTextField.getText());
            if (bl) {
                stringBuffer.append("</b>");
            }
            stringBuffer.append("/.*");
        } else {
            String string = (String)this.urlPatternPanel.depthComboBox.getSelectedItem();
            if (string.equals("")) {
                stringBuffer.append(this.getGroupiefiedPath(0, bl));
            } else {
                stringBuffer.append(this.getGroupiefiedPath(Integer.parseInt(string), bl));
            }
        }
        if (bl) {
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    public String getRepositoryFolder() {
        return this.urlPatternPanel.repositoryPathTextField.getText();
    }

    public boolean useName() {
        return this.urlPatternPanel.useFolderRadioButton.isSelected();
    }
}

