/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.AbstractMapperEventHandler;
import org.netbeans.modules.soa.mappercore.AutoSelectionCanvas;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasSearchResult;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MoveTool;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class CanvasEventHandler
extends AbstractMapperEventHandler {
    private MouseEvent initialEvent = null;

    public CanvasEventHandler(Canvas canvas) {
        super(canvas.getMapper(), canvas);
        new AutoSelectionCanvas(canvas);
    }

    private void reset() {
        this.initialEvent = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        CanvasSearchResult canvasSearchResult = this.getCanvas().find(mouseEvent.getX(), mouseEvent.getY());
        if (canvasSearchResult != null) {
            SelectionModel selectionModel = this.getSelectionModel();
            if (mouseEvent.isControlDown()) {
                selectionModel.switchSelected(canvasSearchResult.getTreePath(), canvasSearchResult.getGraphItem());
            } else if (selectionModel.isSelected(canvasSearchResult.getTreePath(), canvasSearchResult.getGraphItem())) {
                selectionModel.setSelected(canvasSearchResult.getTreePath(), canvasSearchResult.getGraphItem());
            }
        }
        this.reset();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.reset();
        Canvas canvas = this.getCanvas();
        if (!canvas.hasFocus()) {
            canvas.requestFocusInWindow();
        }
        SelectionModel selectionModel = this.getSelectionModel();
        int n = mouseEvent.getY();
        int n2 = mouseEvent.getX();
        CanvasSearchResult canvasSearchResult = this.getCanvas().find(n2, n);
        if (canvasSearchResult != null) {
            TreePath treePath = canvasSearchResult.getTreePath();
            GraphItem graphItem = canvasSearchResult.getGraphItem();
            if (graphItem != null) {
                if (!mouseEvent.isControlDown() && !selectionModel.isSelected(treePath, graphItem)) {
                    selectionModel.setSelected(treePath, graphItem);
                }
            } else if (!mouseEvent.isControlDown()) {
                selectionModel.setSelected(treePath);
            }
        }
        this.initialEvent = mouseEvent;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.initialEvent != null && this.initialEvent.getPoint().distance(mouseEvent.getPoint()) >= 5.0) {
            LinkTool linkTool = this.getMapper().getLinkTool();
            MoveTool moveTool = this.getMapper().getMoveTool();
            Transferable transferable = null;
            CanvasSearchResult canvasSearchResult = this.getCanvas().find(this.initialEvent.getX(), this.initialEvent.getY());
            if (canvasSearchResult == null) {
                this.reset();
                return;
            }
            if (canvasSearchResult.getPinItem() instanceof Vertex) {
                Vertex vertex = (Vertex)canvasSearchResult.getPinItem();
                Link link = vertex.getOutgoingLink();
                if (link == null) {
                    transferable = linkTool.activateOutgoing(canvasSearchResult.getTreePath(), vertex);
                } else {
                    TargetPin targetPin = link.getTarget();
                    if (targetPin instanceof VertexItem) {
                        transferable = linkTool.activateIngoing(canvasSearchResult.getTreePath(), (VertexItem)targetPin);
                    } else if (targetPin instanceof Graph) {
                        transferable = linkTool.activateIngoing(canvasSearchResult.getTreePath(), (Graph)targetPin, link);
                    }
                }
            } else if (canvasSearchResult.getPinItem() instanceof VertexItem) {
                VertexItem vertexItem = (VertexItem)canvasSearchResult.getPinItem();
                Link link = vertexItem.getIngoingLink();
                if (link == null) {
                    transferable = linkTool.activateIngoing(canvasSearchResult.getTreePath(), (VertexItem)canvasSearchResult.getPinItem());
                } else {
                    SourcePin sourcePin = link.getSource();
                    if (sourcePin instanceof Vertex) {
                        transferable = linkTool.activateOutgoing(canvasSearchResult.getTreePath(), (Vertex)sourcePin);
                    } else if (sourcePin instanceof TreeSourcePin) {
                        transferable = linkTool.activateOutgoing((TreeSourcePin)sourcePin, link, canvasSearchResult.getTreePath());
                    }
                }
            } else if (canvasSearchResult.getGraphItem() instanceof Vertex) {
                transferable = moveTool.getMoveTransferable(this.getSelectionModel().getSelectedSubset(), this.initialEvent.getPoint());
            }
            if (transferable != null) {
                this.startDrag(this.initialEvent, transferable, 2);
            }
            this.reset();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Mapper mapper;
            MapperNode mapperNode;
            GraphItem graphItem;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            CanvasSearchResult canvasSearchResult = this.getCanvas().find(n, n2);
            GraphItem graphItem2 = graphItem = canvasSearchResult == null ? null : canvasSearchResult.getGraphItem();
            if (graphItem instanceof VertexItem) {
                this.getCanvas().startEdit(canvasSearchResult.getTreePath(), (VertexItem)graphItem);
            }
            if ((mapperNode = (mapper = this.getMapper()).getNodeAt(n2)) != null && mapperNode.getGraph() != null && !mapperNode.getGraph().isEmptyOrOneLink()) {
                if (graphItem == null) {
                    mapper.setExpandedGraphState(mapperNode.getTreePath(), mapperNode.isGraphCollapsed());
                }
                this.getLinkTool().done();
            }
        }
    }
}

