/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class DefaultCanvasRendererContext
implements CanvasRendererContext {
    private Mapper mapper;
    private Canvas canvas;
    private LeftTree leftTree;
    private RightTree rightTree;
    private int step;
    private int canvasVisibleMinX;
    private int canvasVisibleMaxX;
    private int graphX;

    public DefaultCanvasRendererContext(Mapper mapper) {
        this.mapper = mapper;
        this.canvas = mapper.getCanvas();
        this.leftTree = mapper.getLeftTree();
        this.rightTree = mapper.getRightTree();
        this.step = this.canvas.getStep();
        this.graphX = this.canvas.toCanvas(0);
        Rectangle rectangle = this.canvas.getScrollPane().getViewport().getViewRect();
        this.canvasVisibleMinX = rectangle.x;
        this.canvasVisibleMaxX = rectangle.x + rectangle.width;
    }

    public int getStep() {
        return this.step;
    }

    public JLabel getTextRenderer() {
        return this.canvas.getTextRenderer();
    }

    public boolean isSelected(TreePath treePath) {
        return this.mapper.getSelectionModel().isSelected(treePath);
    }

    public boolean isSelected(TreePath treePath, GraphItem graphItem) {
        return this.mapper.getSelectionModel().isSelected(treePath, graphItem);
    }

    public boolean paintVertex(TreePath treePath, Vertex vertex) {
        return true;
    }

    public boolean paintLink(TreePath treePath, Link link) {
        return true;
    }

    public boolean paintVertexItemPin(TreePath treePath, VertexItem vertexItem) {
        return vertexItem.getIngoingLink() == null;
    }

    public boolean paintVertexPin(TreePath treePath, Vertex vertex) {
        return vertex.getOutgoingLink() == null;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public LeftTree getLeftTree() {
        return this.leftTree;
    }

    public RightTree getRightTree() {
        return this.rightTree;
    }

    public int getCanvasVisibleMinX() {
        return this.canvasVisibleMinX;
    }

    public int getCanvasVisibleMaxX() {
        return this.canvasVisibleMaxX;
    }

    public int getGraphX() {
        return this.graphX;
    }

    public int getCanvasVisibleCenterX() {
        return (this.canvasVisibleMinX + this.canvasVisibleMaxX) / 2;
    }
}

