/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperPropertyAccess;
import org.netbeans.modules.soa.mappercore.VertexItemEditor;
import org.netbeans.modules.soa.mappercore.model.Operation;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.vertexitemeditor.NumberVertexItemEditor;
import org.netbeans.modules.soa.mappercore.vertexitemeditor.StringVertexItemEditor;

public class InplaceEditor
extends MapperPropertyAccess
implements CellEditorListener {
    private Canvas canvas;
    private Map<Class, VertexItemEditor> editors = new HashMap<Class, VertexItemEditor>();
    private VertexItemEditor currentEditor = null;
    private TreePath currentTreePath = null;
    private Component currentEditorComponent = null;
    private VertexItem currentVertexItem = null;

    public InplaceEditor(Canvas canvas) {
        super(canvas.getMapper());
        this.canvas = canvas;
        this.editors.put(String.class, new StringVertexItemEditor());
        this.editors.put(Number.class, new NumberVertexItemEditor());
    }

    public void setVertexItemEditor(Class clazz, VertexItemEditor vertexItemEditor) {
        this.cancelEdit();
        if (vertexItemEditor == null) {
            this.editors.remove(clazz);
        } else {
            this.editors.put(clazz, vertexItemEditor);
        }
    }

    public VertexItemEditor getVertexItemEditor(Class clazz) {
        return this.editors.get(clazz);
    }

    public void startEdit(TreePath treePath, VertexItem vertexItem) {
        this.cancelEdit();
        if (vertexItem.isHairline()) {
            return;
        }
        if (vertexItem.getVertex() instanceof Operation) {
            return;
        }
        if (!this.canvas.getMapperModel().canEditInplace(vertexItem)) {
            return;
        }
        Class clazz = vertexItem.getValueType();
        if (clazz == null) {
            return;
        }
        this.currentEditor = this.editors.get(clazz);
        this.currentEditorComponent = this.currentEditor.getVertexItemEditorComponent(this.getMapper(), treePath, vertexItem);
        this.currentTreePath = treePath;
        this.currentVertexItem = vertexItem;
        this.canvas.add(this.currentEditorComponent);
        this.currentEditor.addEditorListener(this);
        this.currentEditorComponent.requestFocusInWindow();
        this.layoutEditor();
    }

    public void stopEdit() {
        if (this.currentEditor != null) {
            TreePath treePath = this.currentTreePath;
            VertexItem vertexItem = this.currentVertexItem;
            Object object = this.currentEditor.getVertexItemEditorValue();
            this.cancelEdit();
            this.getMapperModel().valueChanged(treePath, vertexItem, object);
        }
    }

    public void cancelEdit() {
        if (this.currentEditor != null) {
            this.currentEditor.removeEditorListener(this);
            boolean bl = this.currentEditorComponent.isFocusOwner();
            this.canvas.remove(this.currentEditorComponent);
            this.canvas.repaint();
            this.currentEditor = null;
            this.currentEditorComponent = null;
            this.currentTreePath = null;
            this.currentVertexItem = null;
            if (bl) {
                this.canvas.requestFocusInWindow();
            }
        }
    }

    public void layoutEditor() {
        if (this.currentEditorComponent != null) {
            Mapper mapper = this.getMapper();
            int n = mapper.getStepSize();
            int n2 = (n - 1) / 2 + 1 + this.currentVertexItem.getGlobalY() * n;
            int n3 = this.canvas.toCanvas(0) + this.currentVertexItem.getGlobalX() * n;
            for (MapperNode mapperNode = mapper.getNode(this.currentTreePath, true); mapperNode != null; mapperNode = mapperNode.getParent()) {
                n2 += mapperNode.getY();
            }
            int n4 = this.currentVertexItem.getWidth() * n + 1;
            int n5 = this.currentVertexItem.getHeight() * n + 1;
            this.currentEditorComponent.setBounds(n3, n2, n4, n5);
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        this.stopEdit();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.cancelEdit();
    }
}

