/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.LinkConnectDone;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionEvent;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionListener;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public class LinkConnectAction
extends MapperKeyboardAction
implements MapperSelectionListener,
TreeExpansionListener,
FocusListener,
TreeSelectionListener {
    private TreePath treePath;
    private Canvas canvas;

    public LinkConnectAction(Canvas canvas) {
        this.canvas = canvas;
        this.treePath = null;
        LinkConnectDone linkConnectDone = new LinkConnectDone(canvas);
        canvas.getMapper().addRightTreeExpansionListener(this);
        canvas.getSelectionModel().addSelectionListener(this);
        canvas.registerAction(linkConnectDone);
        canvas.getRightTree().addFocusListener(this);
        canvas.getRightTree().registrAction(this);
        canvas.getRightTree().registrAction(linkConnectDone);
        canvas.getLeftTree().addFocusListener(this);
        canvas.getLeftTree().addTreeSelectionListener(this);
        canvas.getLeftTree().registrAction(this);
        canvas.getLeftTree().registrAction(linkConnectDone);
    }

    public String getActionKey() {
        return "press-link-connect";
    }

    public KeyStroke[] getShortcuts() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(76, 128), KeyStroke.getKeyStroke(48, 128), KeyStroke.getKeyStroke(10, 0)};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        if (linkTool == null) {
            return;
        }
        SelectionModel selectionModel = this.canvas.getSelectionModel();
        this.treePath = selectionModel.getSelectedPath();
        if (this.treePath == null) {
            return;
        }
        SourcePin sourcePin = linkTool.getSourcePin();
        TargetPin targetPin = linkTool.getTargetPin();
        if (!linkTool.isActive()) {
            Object object;
            Object object2;
            if (actionEvent.getSource() == this.canvas) {
                object2 = selectionModel.getSelectedVerteces();
                if (object2 != null && object2.size() != 0) {
                    if (sourcePin != null) {
                        linkTool.activateIngoing(this.treePath, object2.get(0).getItem(0));
                        this.setSource(sourcePin, this.canvas);
                    } else {
                        linkTool.activateOutgoing(this.treePath, object2.get(0));
                        this.setTarget(null, this.canvas);
                    }
                }
                if ((object = selectionModel.getSelectedVertexItem()) != null) {
                    linkTool.activateIngoing(this.treePath, (VertexItem)object);
                    this.setSource(sourcePin, this.canvas);
                }
                this.canvas.repaint();
            }
            if (actionEvent.getSource() == this.canvas.getRightTree()) {
                object2 = this.canvas.getMapper().getNode(this.treePath, true).getGraph();
                linkTool.activateIngoing(this.treePath, (Graph)object2, null);
                this.setSource(null, this.canvas);
                this.canvas.getRightTree().repaint();
            }
            if (actionEvent.getSource() == this.canvas.getLeftTree()) {
                object2 = this.canvas.getLeftTree().getSelectionPath();
                if (object2 == null) {
                    return;
                }
                object = new TreeSourcePin((TreePath)object2);
                linkTool.activateOutgoing((TreeSourcePin)object, null, null);
                this.canvas.getLeftTree().repaint();
            }
        }
        if (actionEvent.getModifiers() != 0) {
            return;
        }
        if (targetPin != null && sourcePin != null && linkTool.getMapperModel().canConnect(this.treePath, sourcePin, targetPin, null, null)) {
            linkTool.getMapperModel().connect(this.treePath, sourcePin, targetPin, null, null);
        }
        linkTool.done();
    }

    public void mapperSelectionChanged(MapperSelectionEvent mapperSelectionEvent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        if (linkTool == null || !linkTool.isActive()) {
            return;
        }
        SelectionModel selectionModel = linkTool.getSelectionModel();
        if (this.treePath == null) {
            this.treePath = selectionModel.getSelectedPath();
        }
        if (this.treePath == null) {
            return;
        }
        if (selectionModel.getSelectedPath() != this.treePath) {
            if (!(linkTool.getSourcePin() instanceof TreeSourcePin) || this.canvas.hasFocus()) {
                linkTool.done();
                return;
            }
            this.treePath = selectionModel.getSelectedPath();
            if (this.canvas.getRightTree().hasFocus()) {
                MapperNode mapperNode = this.canvas.getMapper().getNode(this.treePath, true);
                Graph graph = mapperNode.getGraph();
                this.setTarget(graph, this.canvas.getRightTree());
                this.canvas.getMapper().repaint();
                return;
            }
        }
        Vertex vertex = null;
        List<Vertex> list = selectionModel.getSelectedVerteces();
        if (list != null && !list.isEmpty()) {
            vertex = list.get(0);
        }
        if (linkTool.isOutgoing()) {
            VertexItem vertexItem = selectionModel.getSelectedVertexItem();
            if (vertexItem != null) {
                this.setTarget(vertexItem, this.canvas);
                return;
            }
            if (vertex == null || vertex.getItemCount() < 1) {
                return;
            }
            vertexItem = vertex.getItem(0);
            this.setTarget(vertexItem, this.canvas);
            return;
        }
        if (linkTool.isIngoing()) {
            if (vertex == null) {
                return;
            }
            this.setSource(vertex, this.canvas);
        }
        this.canvas.repaint();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        if (linkTool == null || !linkTool.isActive()) {
            return;
        }
        if (this.treePath == null) {
            linkTool.done();
            return;
        }
        MapperNode mapperNode = linkTool.getMapper().getNode(this.treePath, true);
        if (mapperNode == null) {
            return;
        }
        if (!mapperNode.isVisibleGraph()) {
            this.treePath = null;
            linkTool.done();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object;
        Object object2;
        LinkTool linkTool = this.canvas.getLinkTool();
        if (linkTool == null || !linkTool.isActive()) {
            return;
        }
        Component component = focusEvent.getComponent();
        if (component == linkTool.getRightTree()) {
            if (linkTool.isOutgoing()) {
                object2 = linkTool.getSelectionModel();
                object = ((SelectionModel)object2).getSelectedPath();
                if (object == null) {
                    return;
                }
                Graph graph = linkTool.getMapper().getNode((TreePath)object, true).getGraph();
                this.setTarget(graph, linkTool.getRightTree());
            }
            if (linkTool.isIngoing()) {
                this.setSource(null, null);
            }
        }
        if (component == linkTool.getLeftTree()) {
            if (linkTool.isIngoing()) {
                object2 = this.canvas.getLeftTree().getSelectionPath();
                if (object2 == null) {
                    return;
                }
                object = new TreeSourcePin((TreePath)object2);
                this.setSource((SourcePin)object, this.canvas.getLeftTree());
            }
            if (linkTool.isOutgoing()) {
                this.setTarget(null, null);
            }
        }
        this.canvas.getMapper().repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        if (linkTool == null || !linkTool.isActive()) {
            return;
        }
        List<Vertex> list = linkTool.getSelectionModel().getSelectedVerteces();
        if (list == null || list.isEmpty()) {
            return;
        }
        Vertex vertex = list.get(0);
        JComponent jComponent = (JComponent)focusEvent.getComponent();
        if (jComponent == this.canvas.getRightTree()) {
            if (linkTool.isIngoing()) {
                this.setSource(vertex, this.canvas);
                return;
            }
            if (linkTool.isOutgoing()) {
                if (vertex.getItemCount() < 1) {
                    return;
                }
                VertexItem vertexItem = vertex.getItem(0);
                this.setTarget(vertexItem, this.canvas);
                return;
            }
        }
        if (jComponent == linkTool.getLeftTree()) {
            // empty if block
        }
        this.canvas.getMapper().repaint();
    }

    private void setSource(SourcePin sourcePin, JComponent jComponent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        TargetPin targetPin = linkTool.getTargetPin();
        MapperModel mapperModel = this.canvas.getMapperModel();
        if (sourcePin != null && mapperModel.canConnect(this.treePath, sourcePin, targetPin, null, null)) {
            linkTool.setSource(sourcePin, jComponent, new Point());
        } else if (targetPin instanceof Graph || sourcePin instanceof TreeSourcePin) {
            linkTool.setSource(null, null, new Point());
        } else {
            Point point = linkTool.getTargetPoint();
            point = Utils.toScrollPane(this.canvas, point, null);
            linkTool.setSource(null, this.canvas, point);
        }
    }

    private void setTarget(TargetPin targetPin, JComponent jComponent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        SourcePin sourcePin = linkTool.getSourcePin();
        MapperModel mapperModel = this.canvas.getMapperModel();
        TreePath treePath = this.canvas.getSelectionModel().getSelectedPath();
        if (targetPin != null && mapperModel.canConnect(treePath, sourcePin, targetPin, null, null)) {
            linkTool.setTarget(treePath, targetPin, jComponent, new Point());
        } else if (sourcePin instanceof TreeSourcePin) {
            linkTool.setTarget(treePath, null, null, new Point());
        } else {
            Point point = linkTool.getSourcePoint();
            point = Utils.toScrollPane(this.canvas, point, null);
            linkTool.setTarget(treePath, null, this.canvas, point);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        LinkTool linkTool = this.canvas.getLinkTool();
        if (linkTool == null || !linkTool.isActive()) {
            return;
        }
        if (linkTool.isIngoing()) {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            TreeSourcePin treeSourcePin = new TreeSourcePin(treePath);
            this.setSource(treeSourcePin, this.canvas.getLeftTree());
            this.canvas.getLeftTree().repaint();
            this.canvas.repaint();
        }
        if (linkTool.isOutgoing() && linkTool.getSourcePin() instanceof TreeSourcePin) {
            linkTool.done();
            this.canvas.getMapper().repaint();
        }
    }
}

