/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.LinkToolCanvasRendererContext;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperPropertyAccess;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.MapperCollection;
import org.netbeans.modules.soa.mappercore.utils.MapperTreePath;
import org.netbeans.modules.soa.mappercore.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkTool
extends MapperPropertyAccess {
    private JComponent sourceComponent;
    private JComponent targetComponent;
    private SourcePin sourcePin;
    private TargetPin targetPin;
    private TreePath targetPath;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private boolean outgoing;
    private long uid = -1L;
    private MapperCollection activePins;
    private TreePath oldTreePath = null;
    private Link oldLink = null;
    private static final DataFlavor LINK_DATA_FLAVOR = new DataFlavor(LinkTransferable.class, "MapperLinkToolUID");
    private static long UID = 0L;

    public LinkTool(Mapper mapper) {
        super(mapper);
    }

    CanvasRendererContext getCanvasRendererContext() {
        return new LinkToolCanvasRendererContext(this);
    }

    public SourcePin getSourcePin() {
        return this.sourcePin;
    }

    public TargetPin getTargetPin() {
        return this.targetPin;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public boolean isIngoing() {
        return !this.outgoing;
    }

    public boolean isActive() {
        return this.uid >= 0L;
    }

    public Link getOldLink() {
        return this.oldLink;
    }

    public TreePath getOldTreePath() {
        return this.oldTreePath;
    }

    public TreePath getTargetPath() {
        return this.targetPath;
    }

    public JComponent getSourceComponent() {
        return this.sourceComponent;
    }

    MapperCollection getActivePins() {
        return this.activePins;
    }

    private void initOld(Link link, TreePath treePath) {
        if (link != null) {
            this.oldLink = link;
            this.oldTreePath = treePath;
        } else {
            this.oldLink = null;
            this.oldTreePath = null;
        }
    }

    public Point getSourcePoint() {
        if (this.sourcePin == null) {
            if (this.sourceComponent == null) {
                return null;
            }
            return Utils.fromScrollPane(this.sourceComponent, new Point(this.x1, this.y1), null);
        }
        if (this.sourcePin instanceof TreeSourcePin) {
            JTree jTree = (JTree)this.sourceComponent;
            Rectangle rectangle = null;
            for (TreePath treePath = ((TreeSourcePin)this.sourcePin).getTreePath(); rectangle == null && treePath != null; treePath = treePath.getParentPath()) {
                rectangle = jTree.getRowBounds(jTree.getRowForPath(treePath));
            }
            return rectangle == null ? new Point(0, 0) : new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        }
        Mapper mapper = this.getMapper();
        Canvas canvas = this.getCanvas();
        int n = mapper.getStepSize();
        Vertex vertex = (Vertex)this.sourcePin;
        MapperNode mapperNode = mapper.getNode(this.targetPath, true);
        Rectangle rectangle = vertex.getBounds(n);
        int n2 = vertex.getPinGlobalX() * n;
        int n3 = vertex.getPinGlobalY() * n;
        n2 = canvas.toCanvas(n2);
        n3 = mapperNode.yToView(n3 + (n - 1) / 2) + 1;
        return new Point(n2, n3);
    }

    public JComponent getTargetComponent() {
        return this.targetComponent;
    }

    public Point getTargetPoint() {
        if (this.targetPin == null) {
            if (this.targetComponent == null) {
                return null;
            }
            return Utils.fromScrollPane(this.targetComponent, new Point(this.x2, this.y2), null);
        }
        Mapper mapper = this.getMapper();
        MapperNode mapperNode = mapper.getNode(this.targetPath, true);
        if (this.targetPin instanceof Graph) {
            int n = mapperNode.yToView(mapperNode.getContentCenterY());
            int n2 = mapper.getRightTree().getWidth() - mapperNode.getLabelWidth() - mapperNode.getIndent();
            return new Point(n2, n);
        }
        Canvas canvas = mapper.getCanvas();
        int n = mapper.getStepSize();
        VertexItem vertexItem = (VertexItem)this.targetPin;
        int n3 = vertexItem.getGlobalX() * n;
        int n4 = (vertexItem.getGlobalY() + vertexItem.getHeight() / 2) * n;
        n3 = canvas.toCanvas(n3);
        n4 = mapperNode.yToView(n4 + (n - 1) / 2) + 1;
        return new Point(n3, n4);
    }

    public Transferable activateIngoing(TreePath treePath, Graph graph, Link link) {
        this.outgoing = false;
        this.uid = LinkTool.createUID();
        this.sourcePin = null;
        this.sourceComponent = null;
        this.targetPath = treePath;
        this.targetPin = graph;
        this.targetComponent = this.getRightTree();
        this.sourcePin = null;
        this.sourceComponent = null;
        this.initOld(link, treePath);
        this.activePins = this.findActivePins();
        return new LinkTransferable(this.uid);
    }

    public Transferable activateIngoing(TreePath treePath, VertexItem vertexItem) {
        this.outgoing = false;
        this.uid = LinkTool.createUID();
        this.sourcePin = null;
        this.sourceComponent = null;
        this.targetPath = treePath;
        this.targetPin = vertexItem;
        this.targetComponent = this.getCanvas();
        this.sourcePin = null;
        this.sourceComponent = null;
        this.initOld(vertexItem.getIngoingLink(), treePath);
        this.activePins = this.findActivePins();
        return new LinkTransferable(this.uid);
    }

    public Transferable activateOutgoing(TreeSourcePin treeSourcePin, Link link, TreePath treePath) {
        this.outgoing = true;
        this.uid = LinkTool.createUID();
        this.sourcePin = treeSourcePin;
        this.sourceComponent = this.getLeftTree();
        this.initOld(link, treePath);
        this.targetPath = null;
        this.targetComponent = null;
        this.targetPin = null;
        this.activePins = this.findActivePins();
        return new LinkTransferable(this.uid);
    }

    public Transferable activateOutgoing(TreePath treePath, Vertex vertex) {
        this.outgoing = true;
        this.uid = LinkTool.createUID();
        this.sourcePin = vertex;
        this.sourceComponent = this.getCanvas();
        this.initOld(vertex.getOutgoingLink(), treePath);
        this.targetPath = treePath;
        this.targetPin = null;
        this.targetComponent = null;
        this.activePins = this.findActivePins();
        return new LinkTransferable(this.uid);
    }

    private void reset() {
        this.uid = -1L;
        this.oldLink = null;
        this.oldTreePath = null;
        this.sourcePin = null;
        this.sourceComponent = null;
        this.targetPath = null;
        this.targetPin = null;
        this.targetComponent = null;
        this.activePins = null;
    }

    private boolean isValidTransferable(Transferable transferable) {
        try {
            long l = (Long)transferable.getTransferData(LINK_DATA_FLAVOR);
            return l == this.uid;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean drag(JComponent jComponent, DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.isValidTransferable(dropTargetDragEvent.getTransferable())) {
            return false;
        }
        Canvas canvas = this.getCanvas();
        LeftTree leftTree = this.getLeftTree();
        RightTree rightTree = this.getRightTree();
        canvas.repaint();
        leftTree.repaint();
        rightTree.repaint();
        if (this.isIngoing()) {
            if (jComponent == leftTree) {
                return this.dragIngoing(leftTree, dropTargetDragEvent);
            }
            if (jComponent == canvas) {
                return this.dragIngoing(canvas, dropTargetDragEvent);
            }
            if (jComponent == rightTree) {
                return this.dragIngoing(rightTree, dropTargetDragEvent);
            }
        } else {
            if (jComponent == leftTree) {
                return this.dragOutgoing(leftTree, dropTargetDragEvent);
            }
            if (jComponent == canvas) {
                return this.dragOutgoing(canvas, dropTargetDragEvent);
            }
            if (jComponent == rightTree) {
                return this.dragOutgoing(rightTree, dropTargetDragEvent);
            }
        }
        throw new IllegalArgumentException("Unknown component: " + jComponent);
    }

    public boolean dragIngoing(LeftTree leftTree, DropTargetDragEvent dropTargetDragEvent) {
        MapperModel mapperModel;
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = Utils.toScrollPane(leftTree, point, null);
        this.sourceComponent = leftTree;
        this.x1 = point2.x;
        this.y1 = point2.y;
        TreeSourcePin treeSourcePin = null;
        TreePath treePath = leftTree.getPathForLocation(point.x, point.y);
        if (treePath != null && (treeSourcePin = (mapperModel = this.getMapperModel()).getTreeSourcePin(treePath)) != null && !this.canConnect(mapperModel, this.targetPath, treeSourcePin, this.targetPin)) {
            treeSourcePin = null;
        }
        this.sourcePin = treeSourcePin;
        this.acceptReject(dropTargetDragEvent, treeSourcePin == null);
        return true;
    }

    public boolean dragIngoing(Canvas canvas, DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = Utils.toScrollPane(canvas, point, null);
        this.sourceComponent = canvas;
        MapperNode mapperNode = this.getNodeAt(point.y);
        int n = this.getMapper().getStepSize();
        Vertex vertex = null;
        boolean bl = false;
        if (mapperNode != null) {
            TreePath treePath = mapperNode.getTreePath();
            int n2 = canvas.toGraph(point.x);
            int n3 = mapperNode.yToNode(point.y);
            Graph graph = mapperNode.getGraph();
            if (!treePath.equals(this.targetPath)) {
                bl = true;
            } else if (graph != null && mapperNode.isGraphExpanded()) {
                vertex = this.findVertex(treePath, graph, n2, n3 -= (n - 1) / 2, n);
            }
        } else {
            bl = true;
        }
        this.x1 = point2.x;
        this.y1 = point2.y;
        this.sourceComponent = canvas;
        this.sourcePin = vertex;
        this.acceptReject(dropTargetDragEvent, bl);
        if (this.targetPin instanceof Graph) {
            this.getRightTree().repaint();
        }
        this.getCanvas().repaint();
        return true;
    }

    public boolean dragIngoing(RightTree rightTree, DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = Utils.toScrollPane(rightTree, point, null);
        this.x1 = point2.x;
        this.y1 = point2.y;
        this.sourceComponent = rightTree;
        this.sourcePin = null;
        dropTargetDragEvent.rejectDrag();
        return true;
    }

    public boolean dragOutgoing(LeftTree leftTree, DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = Utils.toScrollPane(leftTree, point, null);
        this.x2 = point2.x;
        this.y2 = point2.y;
        this.targetComponent = leftTree;
        this.targetPin = null;
        dropTargetDragEvent.rejectDrag();
        this.getCanvas().repaint();
        return true;
    }

    public boolean dragOutgoing(Canvas canvas, DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = Utils.toScrollPane(canvas, point, null);
        MapperNode mapperNode = this.getNodeAt(point.y);
        int n = this.getMapper().getStepSize();
        VertexItem vertexItem = null;
        boolean bl = false;
        if (mapperNode != null) {
            TreePath treePath = mapperNode.getTreePath();
            int n2 = canvas.toGraph(point.x);
            int n3 = mapperNode.yToNode(point.y);
            Graph graph = mapperNode.getGraph();
            if (graph != null && mapperNode.isGraphExpanded()) {
                vertexItem = this.findVertexItem(treePath, graph, n2, n3 -= (n - 1) / 2, n);
            }
            if (this.sourcePin instanceof TreeSourcePin) {
                this.targetPath = treePath;
            } else if (!treePath.equals(this.targetPath)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        this.x2 = point2.x;
        this.y2 = point2.y;
        this.targetComponent = canvas;
        this.targetPin = vertexItem;
        if (this.sourcePin instanceof TreeSourcePin) {
            this.getLeftTree().repaint();
        }
        this.getCanvas().repaint();
        this.acceptReject(dropTargetDragEvent, bl);
        return true;
    }

    public boolean dragOutgoing(RightTree rightTree, DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = Utils.toScrollPane(rightTree, point, null);
        MapperNode mapperNode = this.getNodeAt(point.y);
        Graph graph = null;
        TreePath treePath = this.targetPath;
        MapperModel mapperModel = this.getMapperModel();
        boolean bl = false;
        if (mapperNode != null) {
            Graph graph2 = mapperNode.getGraph();
            TreePath treePath2 = mapperNode.getTreePath();
            if (graph2 != null && treePath2 != null) {
                if (this.sourcePin instanceof Vertex) {
                    if (Utils.equal(treePath, treePath2) && this.canConnect(mapperModel, treePath2, this.sourcePin, graph2)) {
                        graph = graph2;
                        treePath = treePath2;
                    }
                } else if (this.canConnect(mapperModel, treePath2, this.sourcePin, graph2)) {
                    graph = graph2;
                    treePath = treePath2;
                }
            } else {
                graph2 = null;
            }
        }
        this.x2 = point2.x;
        this.y2 = point2.y;
        this.targetComponent = rightTree;
        if (graph != null) {
            this.targetPin = graph;
            this.targetPath = treePath;
            this.acceptReject(dropTargetDragEvent, false);
        } else {
            this.targetPin = null;
            this.acceptReject(dropTargetDragEvent, true);
        }
        this.getCanvas().repaint();
        return true;
    }

    private void acceptReject(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        if (bl) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(0x40000003);
        }
    }

    private Vertex findVertex(TreePath treePath, Graph graph, int n, int n2, int n3) {
        for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
            Vertex vertex = graph.getVertex(i);
            if (vertex.dontContains(n, n2, n3)) continue;
            if (vertex.contains(n, n2, n3)) {
                if (this.activePins.contains(treePath, vertex)) {
                    return vertex;
                }
                return null;
            }
            if (!this.activePins.contains(treePath, vertex) || !vertex.sourcePinContains(n, n2, n3)) continue;
            return vertex;
        }
        return null;
    }

    private VertexItem findVertexItem(TreePath treePath, Graph graph, int n, int n2, int n3) {
        for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
            VertexItem vertexItem;
            int n4;
            Vertex vertex = graph.getVertex(i);
            if (vertex.dontContains(n, n2, n3)) continue;
            if (vertex.contains(n, n2, n3)) {
                for (n4 = vertex.getItemCount() - 1; n4 >= 0; --n4) {
                    vertexItem = vertex.getItem(n4);
                    if (!vertexItem.contains(n, n2, n3)) continue;
                    if (this.activePins.contains(treePath, vertexItem)) {
                        return vertexItem;
                    }
                    return null;
                }
                return null;
            }
            if (vertex instanceof Constant) continue;
            for (n4 = vertex.getItemCount() - 1; n4 >= 0; --n4) {
                vertexItem = vertex.getItem(n4);
                if (!this.activePins.contains(treePath, vertexItem) || !vertexItem.targetPinContains(n, n2, n3)) continue;
                return vertexItem;
            }
        }
        return null;
    }

    public boolean drop(JComponent jComponent, DropTargetDropEvent dropTargetDropEvent) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.isValidTransferable(dropTargetDropEvent.getTransferable())) {
            return false;
        }
        MapperModel mapperModel = this.getMapperModel();
        if (this.sourcePin != null && this.targetPin != null && this.targetPath != null) {
            mapperModel.connect(this.targetPath, this.sourcePin, this.targetPin, this.oldTreePath, this.oldLink);
        }
        this.getMapper().repaint();
        return true;
    }

    public void done() {
        if (!this.isActive()) {
            return;
        }
        this.reset();
        this.getMapper().repaint();
    }

    public void setSource(SourcePin sourcePin, JComponent jComponent, Point point) {
        this.sourcePin = sourcePin;
        this.sourceComponent = jComponent;
        this.x1 = point.x;
        this.y1 = point.y;
    }

    public void setTarget(TreePath treePath, TargetPin targetPin, JComponent jComponent, Point point) {
        this.targetPath = treePath;
        this.targetPin = targetPin;
        this.targetComponent = jComponent;
        this.x2 = point.x;
        this.y2 = point.y;
    }

    public void paintLeftTree(LeftTree leftTree, Graphics graphics) {
        if (!this.isActive()) {
            return;
        }
        if (this.sourcePin instanceof TreeSourcePin && this.targetComponent != leftTree) {
            Point point = this.getSourcePoint();
            graphics.setColor(MapperStyle.LINK_COLOR_SELECTED_NODE);
            graphics.drawLine(point.x, point.y, leftTree.getWidth() - 1, point.y);
        }
    }

    public void paintCanvas(Canvas canvas, Graphics graphics) {
        if (!this.isActive()) {
            return;
        }
        if (this.sourceComponent != this.targetComponent || this.sourceComponent == canvas && this.targetComponent == canvas) {
            LeftTree leftTree = this.getLeftTree();
            RightTree rightTree = this.getRightTree();
            Point point = this.getSourcePoint();
            Point point2 = this.getTargetPoint();
            if (point == null || point2 == null) {
                return;
            }
            Rectangle rectangle = canvas.getViewport().getViewRect();
            boolean bl = true;
            boolean bl2 = true;
            if (this.sourceComponent == leftTree) {
                bl = false;
                point.y = canvas.yFromMapper(leftTree.yToMapper(point.y));
                point.x = Integer.MIN_VALUE;
            } else if (this.sourceComponent == rightTree) {
                point.y = canvas.yFromMapper(rightTree.yToMapper(point.y));
                point.x = rectangle.x + rectangle.width;
            }
            if (this.targetComponent == rightTree) {
                bl2 = false;
                point2.y = canvas.yFromMapper(rightTree.yToMapper(point2.y));
                point2.x = Integer.MAX_VALUE;
            } else if (this.targetComponent == leftTree) {
                point2.y = canvas.yFromMapper(leftTree.yToMapper(point2.y));
                point2.x = rectangle.x;
            }
            int n = this.getMapper().getStepSize();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!Utils.equal(point, point2)) {
                Link.paintLine(graphics2D, MapperStyle.LINK_COLOR_SELECTED_NODE, null, point, point2, n, rectangle.x, rectangle.x + rectangle.width);
            } else {
                if (this.targetPin == null) {
                    bl2 = false;
                }
                if (this.sourcePin == null) {
                    bl = false;
                }
            }
            if (bl) {
                Link.paintSourceDecoration(graphics2D, point, null, n);
            }
            if (bl2) {
                Link.paintTargetDecoration(graphics2D, point2, null, n);
            }
            graphics2D.dispose();
        }
    }

    public void paintRightTree(RightTree rightTree, Graphics graphics) {
        if (!this.isActive()) {
            return;
        }
        if (this.targetPin instanceof Graph && this.sourceComponent != rightTree) {
            Point point = this.getTargetPoint();
            graphics.setColor(MapperStyle.LINK_COLOR_SELECTED_NODE);
            int n = this.getMapper().getStepSize();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawLine(0, point.y, point.x - n / 2, point.y);
            Link.paintTargetDecoration(graphics2D, point, null, n);
            graphics2D.dispose();
        }
    }

    private MapperCollection findActivePins() {
        return this.isOutgoing() ? this.findActiveTargetPins() : this.findActiveSourcePins();
    }

    private MapperCollection findActiveSourcePins() {
        MapperModel mapperModel = this.getMapperModel();
        if (mapperModel != null && mapperModel.getRoot() != null && this.targetPath != null && this.targetPin != null) {
            HashSet<Vertex> hashSet = new HashSet<Vertex>();
            this.findSourceVerteces(this.targetPin, mapperModel, this.targetPath, hashSet);
            return MapperCollection.createVerteces(this.targetPath, hashSet);
        }
        return MapperCollection.create();
    }

    private MapperCollection findActiveTargetPins() {
        Object object;
        MapperModel mapperModel = this.getMapperModel();
        if (mapperModel != null && (object = mapperModel.getRoot()) != null) {
            if (this.sourcePin instanceof TreeSourcePin) {
                HashMap<TreePath, Set<VertexItem>> hashMap = new HashMap<TreePath, Set<VertexItem>>();
                this.findTargetVertexItems((TreeSourcePin)this.sourcePin, mapperModel, new TreePath(object), hashMap);
                return MapperCollection.create(hashMap);
            }
            if (this.sourcePin instanceof Vertex && this.targetPath != null) {
                HashSet<VertexItem> hashSet = new HashSet<VertexItem>();
                this.findTargetVertexItems((Vertex)this.sourcePin, mapperModel, this.targetPath, hashSet);
                return MapperCollection.createVertexItems(this.targetPath, hashSet);
            }
        }
        return MapperCollection.create();
    }

    private void findSourceVerteces(TargetPin targetPin, MapperModel mapperModel, TreePath treePath, Set<Vertex> set) {
        Graph graph = mapperModel.getGraph(treePath);
        if (graph != null) {
            for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
                Vertex vertex = graph.getVertex(i);
                if (!this.canConnect(mapperModel, treePath, vertex, targetPin)) continue;
                set.add(vertex);
            }
        }
    }

    private void findTargetVertexItems(TreeSourcePin treeSourcePin, MapperModel mapperModel, TreePath treePath, Map<TreePath, Set<VertexItem>> map) {
        Object object = treePath.getLastPathComponent();
        Graph graph = mapperModel.getGraph(treePath);
        if (graph != null) {
            HashSet<VertexItem> hashSet = new HashSet<VertexItem>();
            for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
                Vertex vertex = graph.getVertex(i);
                if (vertex instanceof Constant) continue;
                for (int j = vertex.getItemCount() - 1; j >= 0; --j) {
                    VertexItem vertexItem = vertex.getItem(j);
                    if (!this.canConnect(mapperModel, treePath, treeSourcePin, vertexItem)) continue;
                    hashSet.add(vertexItem);
                }
            }
            if (!hashSet.isEmpty()) {
                map.put(treePath, hashSet);
            }
            hashSet = null;
        }
        if (!mapperModel.isLeaf(object) && mapperModel.searchGraphsInside(treePath)) {
            for (int i = mapperModel.getChildCount(object) - 1; i >= 0; --i) {
                Object object2 = mapperModel.getChild(object, i);
                this.findTargetVertexItems(treeSourcePin, mapperModel, (TreePath)new MapperTreePath(treePath, object2), map);
            }
        }
    }

    private void findTargetVertexItems(Vertex vertex, MapperModel mapperModel, TreePath treePath, Set<VertexItem> set) {
        Graph graph = mapperModel.getGraph(treePath);
        if (graph != null) {
            for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
                Vertex vertex2 = graph.getVertex(i);
                if (vertex2 instanceof Constant) continue;
                for (int j = vertex2.getItemCount() - 1; j >= 0; --j) {
                    VertexItem vertexItem = vertex2.getItem(j);
                    if (!this.canConnect(mapperModel, treePath, vertex, vertexItem)) continue;
                    set.add(vertexItem);
                }
            }
        }
    }

    private boolean canConnect(MapperModel mapperModel, TreePath treePath, SourcePin sourcePin, TargetPin targetPin) {
        boolean bl;
        boolean bl2 = bl = this.isOutgoing() ? this.canConnectOutgoing(treePath, targetPin) : this.canConnectIngoing(treePath, sourcePin);
        if (bl && this.checkCyrcle(sourcePin, targetPin)) {
            bl = false;
        }
        return bl ? mapperModel.canConnect(treePath, sourcePin, targetPin, this.oldTreePath, this.oldLink) : false;
    }

    private boolean canConnectOutgoing(TreePath treePath, TargetPin targetPin) {
        if (targetPin instanceof VertexItem) {
            VertexItem vertexItem = (VertexItem)targetPin;
            Link link = vertexItem.getIngoingLink();
            if (link == null) {
                return true;
            }
            return link == this.oldLink && Utils.equal(treePath, this.oldTreePath);
        }
        Graph graph = (Graph)targetPin;
        if (this.oldLink != null) {
            if (this.oldLink.getTarget() == graph) {
                return Utils.equal(this.oldTreePath, treePath) || this.oldLink.getSource() instanceof TreeSourcePin;
            }
            return !graph.hasOutgoingLinks() && (Utils.equal(this.oldTreePath, treePath) || this.oldLink.getSource() instanceof TreeSourcePin);
        }
        return !graph.hasOutgoingLinks();
    }

    private boolean canConnectIngoing(TreePath treePath, SourcePin sourcePin) {
        if (sourcePin instanceof Vertex) {
            Vertex vertex = (Vertex)sourcePin;
            Link link = vertex.getOutgoingLink();
            if (link == null) {
                return true;
            }
            return link == this.oldLink && Utils.equal(treePath, this.oldTreePath);
        }
        return true;
    }

    private boolean checkCyrcle(SourcePin sourcePin, TargetPin targetPin) {
        if (sourcePin instanceof Vertex && targetPin instanceof VertexItem) {
            HashSet<Vertex> hashSet = new HashSet<Vertex>();
            hashSet.add(((VertexItem)targetPin).getVertex());
            return this.checkCyrcle((Vertex)sourcePin, hashSet);
        }
        return false;
    }

    private boolean checkCyrcle(Vertex vertex, Set<Vertex> set) {
        if (set.contains(vertex)) {
            return true;
        }
        set.add(vertex);
        for (int i = vertex.getItemCount() - 1; i >= 0; --i) {
            SourcePin sourcePin;
            VertexItem vertexItem = vertex.getItem(i);
            Link link = vertexItem.getIngoingLink();
            if (link == null || link == this.oldLink || !((sourcePin = link.getSource()) instanceof Vertex) || !this.checkCyrcle((Vertex)sourcePin, set)) continue;
            return true;
        }
        set.remove(vertex);
        return false;
    }

    private static synchronized long createUID() {
        return UID++;
    }

    private static class LinkTransferable
    implements Transferable {
        private Long uid;

        public LinkTransferable(long l) {
            this.uid = new Long(l);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{LINK_DATA_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == LINK_DATA_FLAVOR;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == LINK_DATA_FLAVOR) {
                return this.uid;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

