/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.DefaultMapperContext;
import org.netbeans.modules.soa.mappercore.FilteredMapperModel;
import org.netbeans.modules.soa.mappercore.FiltersToolBar;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.MapperContext;
import org.netbeans.modules.soa.mappercore.MapperDivider;
import org.netbeans.modules.soa.mappercore.MapperDividersController;
import org.netbeans.modules.soa.mappercore.MapperLayout;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MoveTool;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.RightTreeCellRenderer;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionEvent;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionListener;
import org.netbeans.modules.soa.mappercore.graphics.VerticalGradient;
import org.netbeans.modules.soa.mappercore.graphics.XRange;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper
extends JPanel {
    private MapperModel model;
    private MapperModel filteredModel;
    private MapperNode root;
    private TreeModelListener treeModelListener = new TreeModelListenerImpl();
    private MapperSelectionListener selectionListener;
    private int leftDividerPosition = -1;
    private int rightDividerPosition = -1;
    private JPanel leftDivider;
    private JPanel rightDivider;
    private LeftTree leftTree;
    private RightTree rightTree;
    private Canvas canvas;
    private int leftChildIndent;
    private int rightChildIndent;
    private Icon openIcon;
    private Icon closedIcon;
    private Icon leafIcon;
    private Icon expandedIcon;
    private Icon collapsedIcon;
    private Color treeLineColor;
    private Dimension preferredTreeSize = null;
    private XRange graphXRange = null;
    private boolean validNodes = false;
    private boolean repaintSceduled = false;
    private MapperContext context = new DefaultMapperContext();
    private LinkTool linkTool;
    private MoveTool moveTool;
    private EventListenerList listenersList = new EventListenerList();
    private SelectionModel selectionModel;
    private TreePath pathDndselect = null;
    private FiltersToolBar filtersToolBar;
    private boolean filterLeft = false;
    private boolean filterRight = false;
    public static final String MODEL_PROPERTY = "mapper-model-property";
    public static final Stroke DASHED_ROW_SEPARATOR_STROKE = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{4.0f, 2.0f}, 0.0f);
    public static final Stroke DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{4.0f, 4.0f}, 0.0f);
    public static final Color CANVAS_BACKGROUND_COLOR = new Color(16579317);
    public static final Color CANVAS_GRID_COLOR = new Color(0xC0C0C0);
    public static final Color ROW_SEPARATOR_COLOR = new Color(12309481);
    public static final Color SELECTED_BACKGROUND_COLOR_TOP = new Color(0xF0F9FF);
    public static final Color SELECTED_BACKGROUND_COLOR_BOTTOM = new Color(13689072);
    public static final Color RIGHT_TREE_HEADER_COLOR = new Color(0x999999);
    public static final VerticalGradient SELECTED_BACKGROUND_IN_FOCUS = new VerticalGradient(SELECTED_BACKGROUND_COLOR_TOP, SELECTED_BACKGROUND_COLOR_BOTTOM);
    public static final VerticalGradient SELECTED_BACKGROUND_NOT_IN_FOCUS = new VerticalGradient(Utils.gray(SELECTED_BACKGROUND_COLOR_TOP, 75), Utils.gray(SELECTED_BACKGROUND_COLOR_BOTTOM, 75));
    private static final Comparator<Graph> GRAPH_COMPARATOR = new Comparator<Graph>(){

        @Override
        public int compare(Graph graph, Graph graph2) {
            return 0;
        }
    };

    public Mapper(MapperModel mapperModel) {
        this.setLayout(new MapperLayout());
        this.selectionModel = new SelectionModel(this);
        this.leftTree = new LeftTree(this);
        this.rightTree = new RightTree(this);
        this.canvas = new Canvas(this);
        this.leftDivider = new MapperDivider();
        this.leftDivider.setCursor(Cursor.getPredefinedCursor(10));
        this.rightDivider = new MapperDivider();
        this.rightDivider.setCursor(Cursor.getPredefinedCursor(11));
        this.filtersToolBar = new FiltersToolBar(this);
        new MapperDividersController(this, this.leftDivider, this.rightDivider);
        this.add((Component)this.leftTree.getView(), "LEFT_SCROLL");
        this.add((Component)this.leftDivider, "LEFT_DIVIDER");
        this.add((Component)this.canvas.getView(), "CENTER_SCROLL");
        this.add((Component)this.rightDivider, "RIGHT_DIVIDER");
        this.add((Component)this.rightTree.getView(), "RIGHT_SCROLL");
        this.add((Component)this.filtersToolBar, "TOOL_BAR");
        new ScrollPaneYSyncronizer(this.canvas.getScrollPane(), this.rightTree.getScrollPane());
        this.linkTool = new LinkTool(this);
        this.moveTool = new MoveTool(this);
        this.setModel(mapperModel);
        this.selectionModel.addSelectionListener(new MapperSelectionListener(){

            public void mapperSelectionChanged(MapperSelectionEvent mapperSelectionEvent) {
                Mapper.this.repaint();
            }
        });
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "mapper-select-all-action");
        actionMap.put("mapper-select-all-action", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionModel selectionModel = Mapper.this.getSelectionModel();
                TreePath treePath = selectionModel.getSelectedPath();
                if (treePath != null) {
                    selectionModel.selectAll(treePath);
                }
            }
        });
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Mapper.class, (String)"ACSN_Mapper"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Mapper.class, (String)"ACSD_Mapper"));
    }

    public boolean isFilterLeft() {
        return this.filterLeft;
    }

    public boolean isFilterRight() {
        return this.filterRight;
    }

    public void setFilter(boolean bl, boolean bl2) {
        TreePath treePath4;
        int n;
        TreeModel treeModel;
        if (this.filterLeft == bl && this.filterRight == bl2) {
            return;
        }
        this.filterLeft = bl;
        this.filterRight = bl2;
        this.filtersToolBar.updateButtonsState();
        if (this.model == null) {
            return;
        }
        TreePath treePath2 = this.leftTree.getSelectionPath();
        TreePath treePath3 = this.rightTree.getSelectionModel().getSelectedPath();
        GraphSubset graphSubset = this.getSelectionModel().getSelectedSubset();
        VertexItem vertexItem = this.getSelectionModel().getSelectedVertexItem();
        Enumeration<TreePath> enumeration = this.leftTree.getExpandedDescendants(new TreePath(this.leftTree.getModel().getRoot()));
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        List<TreePath> list = this.getExpandedPathes();
        List<TreePath> list2 = this.getExpandedGraphsPathes();
        MapperModel mapperModel = this.filteredModel;
        MapperModel mapperModel2 = bl || bl2 ? new FilteredMapperModel(this.model, bl, bl2) : this.model;
        TreeModel treeModel2 = this.leftTree.getModel();
        TreeModel treeModel3 = treeModel = this.model != null ? mapperModel2.getLeftTreeModel() : null;
        if (treeModel2 != treeModel) {
            this.leftTree.setModel(treeModel);
        }
        mapperModel.removeTreeModelListener(this.treeModelListener);
        mapperModel2.addTreeModelListener(this.treeModelListener);
        this.filteredModel = mapperModel2;
        if (mapperModel instanceof FilteredMapperModel) {
            ((FilteredMapperModel)mapperModel).dispose();
        }
        this.root = new MapperNode(this, null, this.filteredModel.getRoot());
        this.invalidateNodes();
        for (n = list.size() - 1; n >= 0; --n) {
            treePath4 = list.get(n);
            if (Utils.isTreePathExpandable(mapperModel2, treePath4)) continue;
            list.remove(n);
        }
        for (n = list2.size() - 1; n >= 0; --n) {
            treePath4 = list2.get(n);
            if (Utils.isTreePathInModel(mapperModel2, treePath4)) continue;
            list2.remove(n);
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            treePath4 = (TreePath)arrayList.get(n);
            if (Utils.isTreePathExpandable(treeModel, treePath4)) continue;
            arrayList.remove(n);
        }
        this.applyExpandedPathes(list);
        this.applyExpandedGraphsPathes(list2);
        for (TreePath treePath4 : arrayList) {
            this.leftTree.expandPath(treePath4);
        }
        if (treePath2 != null && Utils.isTreePathInModel(treeModel, treePath2)) {
            this.leftTree.setSelectionPath(treePath2);
        }
        this.firePropertyChange(MODEL_PROPERTY, mapperModel, this.filteredModel);
        if (treePath3 != null && Utils.isTreePathInModel(mapperModel2, treePath3)) {
            SelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelected(treePath3);
            if (vertexItem != null) {
                selectionModel.setSelected(treePath3, vertexItem);
            } else if (graphSubset != null) {
                int n2;
                for (n2 = graphSubset.getLinkCount() - 1; n2 >= 0; --n2) {
                    selectionModel.switchSelected(treePath3, graphSubset.getLink(n2));
                }
                for (n2 = graphSubset.getVertexCount() - 1; n2 >= 0; --n2) {
                    selectionModel.switchSelected(treePath3, graphSubset.getVertex(n2));
                }
            }
        }
        this.repaintNodes();
        this.revalidate();
        this.repaint();
    }

    public void addRightTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenersList.add(TreeExpansionListener.class, treeExpansionListener);
    }

    public void removeRightTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenersList.remove(TreeExpansionListener.class, treeExpansionListener);
    }

    public void addSelectionListener(MapperSelectionListener mapperSelectionListener) {
        this.getSelectionModel().addSelectionListener(mapperSelectionListener);
    }

    public void removeSelectionListener(MapperSelectionListener mapperSelectionListener) {
        this.getSelectionModel().removeSelectionListener(mapperSelectionListener);
    }

    public TreePath getSelectedDndPath() {
        return this.pathDndselect;
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    LinkTool getLinkTool() {
        return this.linkTool;
    }

    MoveTool getMoveTool() {
        return this.moveTool;
    }

    public MapperContext getContext() {
        return this.context;
    }

    public void setSelectedDndPath(TreePath treePath) {
        this.pathDndselect = treePath;
    }

    public void setContext(MapperContext mapperContext) {
        if (mapperContext == null) {
            mapperContext = new DefaultMapperContext();
        }
        if (this.context != mapperContext) {
            this.context = mapperContext;
            TreeCellRenderer treeCellRenderer = this.leftTree.getCellRenderer();
            this.leftTree.setCellRenderer(new DefaultTreeCellRenderer());
            this.leftTree.setCellRenderer(treeCellRenderer);
            this.leftTree.revalidate();
            this.leftTree.repaint();
            MapperNode mapperNode = this.getRoot();
            if (mapperNode != null) {
                mapperNode.invalidateTree();
                mapperNode.repaint();
            }
        }
    }

    public TreePath getSelected() {
        return this.getSelectionModel().getSelectedPath();
    }

    public TreePath getSelectedPath() {
        return this.getSelectionModel().getSelectedPath();
    }

    public void setSelected(TreePath treePath) {
        this.getSelectionModel().setSelected(treePath);
    }

    void resetRepaintSceduled() {
        this.repaintSceduled = false;
    }

    void setSelectedNode(MapperNode mapperNode) {
        this.setSelected(mapperNode.getTreePath());
    }

    public void setExpandedState(TreePath treePath, boolean bl) {
        if (bl) {
            TreePath treePath2 = null;
            for (MapperNode mapperNode = this.getNode(treePath, true); mapperNode != null; mapperNode = mapperNode.getParent()) {
                if (mapperNode.isLeaf() || !mapperNode.isCollapsed()) continue;
                mapperNode.setExpanded(true);
                if (treePath2 != null) continue;
                treePath2 = mapperNode.getTreePath();
            }
            if (treePath2 != null) {
                this.fireNodeExpanded(treePath2);
            }
        } else {
            MapperNode mapperNode = this.getNode(treePath, false);
            if (mapperNode != null && !mapperNode.isLeaf() && mapperNode.isExpanded()) {
                mapperNode.setCollapsed(true);
                this.fireNodeCollapsed(treePath);
            }
        }
    }

    public void setExpandedGraphState(TreePath treePath, boolean bl) {
        if (this.model == null) {
            return;
        }
        Graph graph = this.model.getGraph(treePath);
        if (graph == null || graph.isEmpty()) {
            return;
        }
        if (bl) {
            MapperNode mapperNode = this.getNode(treePath, true);
            mapperNode.setGraphExpanded(true);
        } else {
            MapperNode mapperNode = this.getNode(treePath, false);
            if (mapperNode != null) {
                mapperNode.setGraphExpanded(false);
            }
        }
    }

    private void fireNodeCollapsed(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        TreeExpansionListener[] treeExpansionListenerArray = (TreeExpansionListener[])this.listenersList.getListeners(TreeExpansionListener.class);
        if (treeExpansionListenerArray != null && treeExpansionListenerArray.length > 0) {
            TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            for (TreeExpansionListener treeExpansionListener : treeExpansionListenerArray) {
                treeExpansionListener.treeCollapsed(treeExpansionEvent);
            }
        }
    }

    private void fireNodeExpanded(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        TreeExpansionListener[] treeExpansionListenerArray = (TreeExpansionListener[])this.listenersList.getListeners(TreeExpansionListener.class);
        if (treeExpansionListenerArray != null && treeExpansionListenerArray.length > 0) {
            TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            for (TreeExpansionListener treeExpansionListener : treeExpansionListenerArray) {
                treeExpansionListener.treeExpanded(treeExpansionEvent);
            }
        }
    }

    void collapseNode(MapperNode mapperNode) {
        this.setExpandedState(mapperNode.getTreePath(), false);
    }

    void expandNode(MapperNode mapperNode) {
        this.setExpandedState(mapperNode.getTreePath(), true);
    }

    void switchCollapsedExpandedState(MapperNode mapperNode) {
        if (mapperNode.isLeaf()) {
            return;
        }
        if (mapperNode.isExpanded()) {
            this.collapseNode(mapperNode);
        } else {
            this.expandNode(mapperNode);
        }
    }

    public int getLeftDividerPosition() {
        return this.leftDividerPosition;
    }

    public int getRightDividerPosition() {
        return this.rightDividerPosition;
    }

    void setDividerPositions(int n, int n2) {
        this.leftDividerPosition = n;
        this.rightDividerPosition = n2;
    }

    public void setModel(MapperModel mapperModel) {
        MapperModel mapperModel2 = this.model;
        MapperModel mapperModel3 = this.filteredModel;
        if (mapperModel2 != mapperModel) {
            TreeModel treeModel;
            this.model = mapperModel;
            this.filteredModel = (this.filterLeft || this.filterRight) && mapperModel != null ? new FilteredMapperModel(mapperModel, this.filterLeft, this.filterRight) : mapperModel;
            TreeModel treeModel2 = mapperModel2 != null ? this.leftTree.getModel() : null;
            TreeModel treeModel3 = treeModel = mapperModel != null ? this.filteredModel.getLeftTreeModel() : null;
            if (treeModel2 != treeModel) {
                this.leftTree.setModel(treeModel);
            }
            if (mapperModel3 != null) {
                mapperModel3.removeTreeModelListener(this.treeModelListener);
            }
            if (this.filteredModel != null) {
                this.filteredModel.addTreeModelListener(this.treeModelListener);
                this.root = new MapperNode(this, null, this.filteredModel.getRoot());
            } else {
                this.root = null;
            }
            this.invalidateNodes();
            this.repaintNodes();
            this.revalidate();
            this.repaint();
            this.firePropertyChange(MODEL_PROPERTY, mapperModel3, this.filteredModel);
            if (mapperModel3 instanceof FilteredMapperModel) {
                ((FilteredMapperModel)mapperModel3).dispose();
            }
        }
    }

    public MapperModel getModel() {
        return this.model;
    }

    public MapperModel getFilteredModel() {
        return this.filteredModel;
    }

    MapperNode getRoot() {
        return this.root;
    }

    public LeftTree getLeftTree() {
        return this.leftTree;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public RightTree getRightTree() {
        return this.rightTree;
    }

    public void expandNonEmptyGraphs() {
        this.expandGraphs(Utils.getNonEmptyGraphs(this.getFilteredModel()));
    }

    public void expandGraphs(List<TreePath> list) {
        if (list == null) {
            return;
        }
        HashSet<TreePath> hashSet = new HashSet<TreePath>();
        for (TreePath treePath : list) {
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 == null) continue;
            hashSet.add(treePath2);
        }
        for (TreePath treePath : hashSet) {
            this.setExpandedState(treePath, true);
        }
        for (TreePath treePath : list) {
            this.setExpandedGraphState(treePath, true);
        }
    }

    public List<TreePath> getExpandedPathes() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        MapperNode mapperNode = this.getRoot();
        if (this.root != null) {
            this.collectExpandedPathes(mapperNode, arrayList);
        }
        return arrayList;
    }

    private void collectExpandedPathes(MapperNode mapperNode, List<TreePath> list) {
        if (mapperNode.isLeaf()) {
            return;
        }
        if (mapperNode.isExpanded()) {
            list.add(mapperNode.getTreePath());
        }
        if (mapperNode.isLoaded()) {
            for (int i = mapperNode.getChildCount() - 1; i >= 0; --i) {
                this.collectExpandedPathes(mapperNode.getChild(i), list);
            }
        }
    }

    public List<TreePath> getExpandedGraphsPathes() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        MapperModel mapperModel = this.getFilteredModel();
        MapperNode mapperNode = this.getRoot();
        if (mapperModel != null && this.root != null) {
            this.collectExpandedGraphsPathes(mapperModel, mapperNode, arrayList);
        }
        return arrayList;
    }

    private void collectExpandedGraphsPathes(MapperModel mapperModel, MapperNode mapperNode, List<TreePath> list) {
        Graph graph = mapperNode.getGraph();
        if (graph != null && !graph.isEmpty() && mapperNode.isGraphExpanded()) {
            list.add(mapperNode.getTreePath());
        }
        if (mapperNode.isLeaf()) {
            return;
        }
        if (!mapperModel.searchGraphsInside(mapperNode.getTreePath())) {
            return;
        }
        if (mapperNode.isLoaded()) {
            for (int i = mapperNode.getChildCount() - 1; i >= 0; --i) {
                this.collectExpandedGraphsPathes(mapperModel, mapperNode.getChild(i), list);
            }
        }
    }

    public void applyExpandedPathes(List<TreePath> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        MapperModel mapperModel = this.getFilteredModel();
        if (mapperModel == null) {
            return;
        }
        for (TreePath treePath : list) {
            MapperNode mapperNode;
            if (!Utils.isTreePathExpandable(mapperModel, treePath) || (mapperNode = this.getNode(treePath, true)) == null || mapperNode.isLeaf() || !mapperNode.isCollapsed()) continue;
            mapperNode.setExpanded(true);
            this.fireNodeExpanded(treePath);
        }
    }

    public void applyExpandedGraphsPathes(List<TreePath> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        MapperModel mapperModel = this.getFilteredModel();
        if (mapperModel == null) {
            return;
        }
        for (TreePath treePath : list) {
            MapperNode mapperNode;
            Graph graph;
            if (!Utils.isTreePathInModel(mapperModel, treePath) || (graph = mapperModel.getGraph(treePath)) == null || graph.isEmpty() || (mapperNode = this.getNode(treePath, true)) == null || !mapperNode.isGraphCollapsed()) continue;
            mapperNode.setGraphExpanded(true);
        }
    }

    public void hideOtherPathes(int n) {
        if (this.model == null) {
            return;
        }
        if (this.root == null) {
            return;
        }
        TreePath treePath = this.getSelectedPath();
        if (treePath == null) {
            return;
        }
        this.collapseAll(this.root, 0, n, treePath);
    }

    public void collapseAll(int n) {
        if (this.root == null) {
            return;
        }
        this.collapseAll(this.root, 0, n, null);
    }

    private void collapseAll(MapperNode mapperNode, int n, int n2, TreePath treePath) {
        Graph graph;
        TreePath treePath2 = mapperNode.getTreePath();
        boolean bl = false;
        boolean bl2 = false;
        if (treePath != null) {
            bl2 = treePath2.equals(treePath);
            boolean bl3 = bl = treePath2.isDescendant(treePath) && !bl2;
        }
        if (!mapperNode.isLeaf()) {
            if (n >= n2 && mapperNode.isExpanded() && !bl) {
                this.setExpandedState(treePath2, false);
            }
            if (mapperNode.isLoaded()) {
                for (int i = mapperNode.getChildCount() - 1; i >= 0; --i) {
                    this.collapseAll(mapperNode.getChild(i), n + 1, n2, treePath);
                }
            }
        }
        if ((graph = mapperNode.getGraph()) != null && !bl2 && mapperNode.isGraphExpanded()) {
            this.setExpandedGraphState(treePath2, false);
        }
    }

    public RightTreeCellRenderer getRightTreeCellRenderer() {
        return this.rightTree.getTreeCellRenderer();
    }

    public TreePath getRightTreePathForLink(Link link) {
        return this.getRightTreePathForLink(link, this.getRoot().getTreePath());
    }

    private TreePath getRightTreePathForLink(Link link, TreePath treePath) {
        if (link == null || treePath == null) {
            return null;
        }
        MapperNode mapperNode = this.getNode(treePath, true);
        if (link.getGraph() == mapperNode.getGraph()) {
            return treePath;
        }
        for (int i = 0; i < mapperNode.getChildCount(); ++i) {
            MapperNode mapperNode2 = mapperNode.getChild(i);
            if (mapperNode2.isLeaf()) {
                if (link.getGraph() != mapperNode2.getGraph()) continue;
                return mapperNode2.getTreePath();
            }
            if (this.getRightTreePathForLink(link, mapperNode2.getTreePath()) == null) continue;
            return this.getRightTreePathForLink(link, mapperNode2.getTreePath());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Link getPrevIngoingLink(Link link) {
        void var10_24;
        Set<Graph> set = this.canvas.getMapper().getRoot().getChildGraphs();
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Graph graph : set) {
            arrayList.addAll(graph.getIngoingLinks());
        }
        if (!arrayList.contains(link)) {
            return null;
        }
        Object object2 = ((TreeSourcePin)link.getSource()).getTreePath();
        int n = this.getLeftTree().getParentsRowForPath((TreePath)object2);
        Graph graph = null;
        if (link.getTarget() instanceof Graph) {
            graph = (Graph)link.getTarget();
        }
        if (link.getTarget() instanceof VertexItem) {
            graph = ((VertexItem)link.getTarget()).getVertex().getGraph();
        }
        ArrayList<Link> arrayList2 = new ArrayList<Link>();
        ArrayList<Link> arrayList3 = new ArrayList<Link>();
        for (Link object3 : arrayList) {
            object2 = ((TreeSourcePin)object3.getSource()).getTreePath();
            int n2 = this.getLeftTree().getParentsRowForPath((TreePath)object2);
            if (n2 != n) continue;
            arrayList2.add(object3);
        }
        if (arrayList2.size() > 1) {
            arrayList3.clear();
            Iterator object4 = null;
            Object var10_13 = null;
            for (Object object : arrayList2) {
                void var10_14;
                if (((Link)object).getTarget() instanceof Graph) {
                    Graph graph2 = (Graph)((Link)object).getTarget();
                }
                if (((Link)object).getTarget() instanceof VertexItem) {
                    Graph graph3 = ((VertexItem)((Link)object).getTarget()).getVertex().getGraph();
                }
                if (this.compare(graph, (Graph)var10_14, this.getRoot().getTreePath()) < 0) continue;
                if (object4 == null) {
                    object4 = var10_14;
                    arrayList3.add((Link)object);
                    continue;
                }
                if (this.compare((Graph)((Object)object4), (Graph)var10_14, this.getRoot().getTreePath()) < 0) {
                    arrayList3.clear();
                    object4 = var10_14;
                    arrayList3.add((Link)object);
                }
                if (this.compare((Graph)((Object)object4), (Graph)var10_14, this.getRoot().getTreePath()) != 0) continue;
                arrayList3.add((Link)object);
            }
            if (arrayList3.size() == 1) {
                return (Link)arrayList3.get(0);
            }
            if (arrayList3.size() > 1) {
                Object object;
                if (arrayList3.contains(link)) {
                    object = ((Graph)((Object)object4)).getPrevLink(link, arrayList3);
                    if (object != null) {
                        return object;
                    }
                    if (((Graph)((Object)object4)).getPrevLink(link) == null) {
                        arrayList3.clear();
                        object4 = null;
                        Object var10_17 = null;
                        for (Link link2 : arrayList2) {
                            void var10_18;
                            if (link2.getTarget() instanceof Graph) {
                                Graph graph4 = (Graph)link2.getTarget();
                            }
                            if (link2.getTarget() instanceof VertexItem) {
                                Graph graph5 = ((VertexItem)link2.getTarget()).getVertex().getGraph();
                            }
                            if (this.compare(graph, (Graph)var10_18, this.getRoot().getTreePath()) <= 0) continue;
                            if (object4 == null) {
                                object4 = var10_18;
                                arrayList3.add(link2);
                                continue;
                            }
                            if (this.compare((Graph)((Object)object4), (Graph)var10_18, this.getRoot().getTreePath()) < 0) {
                                arrayList3.clear();
                                object4 = var10_18;
                                arrayList3.add(link2);
                            }
                            if (this.compare((Graph)((Object)object4), (Graph)var10_18, this.getRoot().getTreePath()) != 0) continue;
                            arrayList3.add(link2);
                        }
                        if (object4 == null) {
                            return null;
                        }
                        object = ((Graph)((Object)object4)).getPrevLink(null, arrayList3);
                        return object;
                    }
                } else {
                    object = ((Graph)((Object)object4)).getPrevLink(null, arrayList3);
                    if (object != null) {
                        return object;
                    }
                }
            }
        }
        arrayList2.clear();
        int n3 = 0;
        for (Link link3 : arrayList) {
            object2 = ((TreeSourcePin)link3.getSource()).getTreePath();
            int n4 = this.getLeftTree().getParentsRowForPath((TreePath)object2);
            if (n4 < n && n4 > n3) {
                arrayList2.clear();
                n3 = n4;
                arrayList2.add(link3);
            }
            if (n4 >= n || n4 != n3) continue;
            arrayList2.add(link3);
        }
        if (n3 == 0) {
            return null;
        }
        if (arrayList2.size() == 1) {
            return (Link)arrayList2.get(0);
        }
        arrayList3.clear();
        Object var10_23 = null;
        Graph graph6 = null;
        for (Link link4 : arrayList2) {
            if (link4.getTarget() instanceof Graph) {
                graph6 = (Graph)link4.getTarget();
            }
            if (link4.getTarget() instanceof VertexItem) {
                graph6 = ((VertexItem)link4.getTarget()).getVertex().getGraph();
            }
            if (this.compare(graph, graph6, this.getRoot().getTreePath()) < 0) continue;
            if (var10_24 == null) {
                Graph graph7 = graph6;
                arrayList3.add(link4);
                continue;
            }
            if (this.compare((Graph)var10_24, graph6, this.getRoot().getTreePath()) < 0) {
                arrayList3.clear();
                Graph graph8 = graph6;
                arrayList3.add(link4);
            }
            if (this.compare((Graph)var10_24, graph6, this.getRoot().getTreePath()) != 0) continue;
            arrayList3.add(link4);
        }
        if (arrayList3.size() == 1) {
            return (Link)arrayList3.get(0);
        }
        if (arrayList3.size() > 1) {
            if (arrayList3.contains(link)) {
                Object object = var10_24.getPrevLink(link, arrayList3);
                if (object != null) {
                    return object;
                }
                object = var10_24.getPrevLink(link);
                return object;
            }
            return var10_24.getPrevLink(null, arrayList3);
        }
        return null;
    }

    public Link getNextOutgoingLink(Link link) {
        return null;
    }

    int getTextHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    int getTextWidth(String string) {
        return this.getFontMetrics(this.getFont()).stringWidth(string);
    }

    int getStepSize() {
        return Math.max((this.getTextHeight() + 2) / 2 + 1, 9);
    }

    MapperNode getNode(TreePath treePath, boolean bl) {
        return this.getNode(treePath.getPath(), bl);
    }

    MapperNode getNode(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return null;
        }
        if (this.root == null) {
            return null;
        }
        if (this.root.getValue() != objectArray[0]) {
            throw new IllegalStateException();
        }
        MapperNode mapperNode = this.root;
        for (int i = 1; i < objectArray.length; ++i) {
            if (!bl && !mapperNode.isLoaded()) {
                return null;
            }
            if (this.filteredModel.getIndexOfChild(mapperNode.getValue(), objectArray[i]) == -1) {
                // empty if block
            }
            mapperNode = mapperNode.getChild(this.filteredModel.getIndexOfChild(mapperNode.getValue(), objectArray[i]));
        }
        return mapperNode;
    }

    MapperNode getClosestLoadedNode(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return null;
        }
        if (this.root == null) {
            return null;
        }
        if (this.root.getValue() != objectArray[0]) {
            throw new IllegalStateException();
        }
        MapperNode mapperNode = this.root;
        for (int i = 1; i < objectArray.length && mapperNode.isLoaded(); ++i) {
            mapperNode = mapperNode.getChild(this.filteredModel.getIndexOfChild(mapperNode.getValue(), objectArray[i]));
        }
        return mapperNode;
    }

    MapperNode getNodeAt(int n) {
        return this.root == null ? null : this.root.getNode(n);
    }

    void invalidateNodes() {
        if (this.validNodes) {
            this.rightTree.revalidate();
            this.canvas.revalidate();
            JComponent jComponent = (JComponent)this.rightTree.getScrollPane().getRowHeader().getView();
            jComponent.revalidate();
            this.preferredTreeSize = null;
            this.graphXRange = null;
            this.validNodes = false;
        }
    }

    void repaintNodes() {
        if (!this.repaintSceduled) {
            this.rightTree.repaint();
            this.canvas.repaint();
            JComponent jComponent = (JComponent)this.rightTree.getScrollPane().getRowHeader().getView();
            jComponent.repaint();
            this.repaintSceduled = true;
        }
    }

    void validateNodes() {
        if (!this.validNodes && this.root != null) {
            this.preferredTreeSize = this.root.getPreferredSize();
            this.graphXRange = this.root.getGraphXRange();
            this.root.setBounds(0, this.preferredTreeSize.height, 0);
            this.root.validate();
            this.validNodes = true;
        }
    }

    @Override
    public void doLayout() {
        this.validateNodes();
        super.doLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        this.validateNodes();
        return super.getPreferredSize();
    }

    Dimension getPreferredTreeSize() {
        this.validateNodes();
        return this.preferredTreeSize == null ? null : new Dimension(this.preferredTreeSize.width, this.preferredTreeSize.height - 1);
    }

    XRange getGraphXRange() {
        this.validateNodes();
        return this.graphXRange == null ? null : new XRange(this.graphXRange);
    }

    int getLeftIndent() {
        return this.leftChildIndent;
    }

    int getRightIndent() {
        return this.rightChildIndent;
    }

    int getTotalIndent() {
        return this.leftChildIndent + this.rightChildIndent;
    }

    Icon getOpenIcon() {
        return this.openIcon;
    }

    Icon getClosedIcon() {
        return this.closedIcon;
    }

    Icon getLeafIcon() {
        return this.leafIcon;
    }

    Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    Color getTreeLineColor() {
        return this.treeLineColor;
    }

    void updateChildGraphs(TreePath treePath) {
        for (MapperNode mapperNode = this.getClosestLoadedNode(treePath.getPath()); mapperNode != null; mapperNode = mapperNode.getParent()) {
            mapperNode.updateChildGraphs();
            mapperNode.invalidate();
            mapperNode.repaint();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.treeLineColor = UIManager.getColor("Tree.hash");
        this.leftChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.rightChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.openIcon = UIManager.getIcon("Tree.openIcon");
        this.closedIcon = UIManager.getIcon("Tree.closedIcon");
        this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        this.expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        this.collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
    }

    private int compare(Graph graph, Graph graph2, TreePath treePath) {
        if (graph == graph2) {
            return 0;
        }
        MapperNode mapperNode = this.getNode(treePath, true);
        if (mapperNode.getGraph() == graph) {
            return -1;
        }
        if (mapperNode.getGraph() == graph2) {
            return 1;
        }
        for (int i = 0; i < mapperNode.getChildCount(); ++i) {
            MapperNode mapperNode2 = mapperNode.getChild(i);
            if (mapperNode2.isLeaf()) {
                if (mapperNode2.getGraph() == graph) {
                    return -1;
                }
                if (mapperNode2.getGraph() != graph2) continue;
                return 1;
            }
            int n = this.compare(graph, graph2, mapperNode2.getTreePath());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private class ScrollPaneYSyncronizer
    implements ChangeListener {
        private JViewport viewport1;
        private JViewport viewport2;

        public ScrollPaneYSyncronizer(JScrollPane jScrollPane, JScrollPane jScrollPane2) {
            this.viewport1 = jScrollPane.getViewport();
            this.viewport2 = jScrollPane2.getViewport();
            this.viewport1.addChangeListener(this);
            this.viewport2.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.viewport1) {
                Point point = this.viewport2.getViewPosition();
                point.y = this.viewport1.getViewPosition().y;
                this.viewport2.setViewPosition(point);
            } else {
                Point point = this.viewport1.getViewPosition();
                point.y = this.viewport2.getViewPosition().y;
                this.viewport1.setViewPosition(point);
            }
        }
    }

    private class TreeModelListenerImpl
    implements TreeModelListener {
        private TreeModelListenerImpl() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            int[] nArray = treeModelEvent.getChildIndices();
            if (nArray == null || treePath == null) {
                Mapper.this.root.updateChildGraphs();
                Mapper.this.root.updateNode();
                Mapper.this.root.invalidate();
                Mapper.this.root.repaint();
            } else {
                Mapper.this.updateChildGraphs(treePath);
                MapperNode mapperNode = Mapper.this.getNode(treePath, false);
                if (mapperNode != null) {
                    for (int n : nArray) {
                        MapperNode mapperNode2 = mapperNode.getChild(n);
                        mapperNode2.updateNode();
                        mapperNode2.invalidate();
                        mapperNode2.repaint();
                    }
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            Mapper.this.updateChildGraphs(treeModelEvent.getTreePath());
            MapperNode mapperNode = Mapper.this.getNode(treeModelEvent.getPath(), false);
            if (mapperNode != null) {
                mapperNode.updateNode();
                mapperNode.updateChildren();
                mapperNode.invalidate();
                mapperNode.repaint();
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            Mapper.this.updateChildGraphs(treeModelEvent.getTreePath());
            MapperNode mapperNode = Mapper.this.getNode(treeModelEvent.getPath(), false);
            if (mapperNode != null) {
                mapperNode.updateNode();
                mapperNode.updateChildren();
                mapperNode.invalidate();
                mapperNode.repaint();
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            MapperModel mapperModel = Mapper.this.model;
            Mapper.this.setModel(null);
            Mapper.this.setModel(mapperModel);
        }
    }
}

