/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.AbstractMapperDnDTool;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.MapperModel;

public class MoveTool
extends AbstractMapperDnDTool {
    private GraphSubset graphSubSet;
    private static final DataFlavor MOVE_GRAPHSUBSET_FLAVOR = new DataFlavor(MoveTransferable.class, "MapperDataFlavor");
    private static final DataFlavor MOVE_DELTA_FLAVOR = new DataFlavor(Point.class, "MapperDeltaFlavor");
    private static long UID = 0L;

    public MoveTool(Mapper mapper) {
        super(mapper);
    }

    Transferable getMoveTransferable(GraphSubset graphSubset, Point point) {
        Point point2;
        this.graphSubSet = graphSubset;
        if (graphSubset.getGraph() != null && graphSubset.getVertexCount() > 0) {
            int n = graphSubset.getVertex(0).getX();
            int n2 = graphSubset.getVertex(0).getY();
            n = this.getCanvas().toCanvas(n * this.getCanvas().getStep());
            MapperNode mapperNode = this.getCanvas().getNodeAt(point.y);
            n2 = mapperNode.yToView(n2 * this.getCanvas().getStep());
            point2 = new Point(point.x - n, point.y - n2);
        } else {
            point2 = new Point();
        }
        return new MoveTransferable(graphSubset, point2);
    }

    private void reset() {
        this.graphSubSet = null;
    }

    public boolean drag(JComponent jComponent, DropTargetDragEvent dropTargetDragEvent) {
        Graph graph;
        if (jComponent != this.getCanvas()) {
            return false;
        }
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable == null) {
            this.reset();
            return false;
        }
        this.graphSubSet = this.getGraphSubset(transferable);
        if (this.graphSubSet == null) {
            return false;
        }
        int n = dropTargetDragEvent.getLocation().getLocation().y;
        MapperNode mapperNode = this.getNodeAt(n);
        MapperModel mapperModel = this.getMapperModel();
        Graph graph2 = graph = mapperNode == null ? null : mapperNode.getGraph();
        if (graph != null && mapperModel != null) {
            if (dropTargetDragEvent.getDropAction() == 1 && mapperModel.canCopy(mapperNode.getTreePath(), this.graphSubSet)) {
                dropTargetDragEvent.acceptDrag(1);
            } else if (dropTargetDragEvent.getDropAction() == 2 && mapperModel.canCopy(mapperNode.getTreePath(), this.graphSubSet)) {
                dropTargetDragEvent.acceptDrag(2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        return true;
    }

    public void drawDnDImage() {
    }

    private GraphSubset getGraphSubset(Transferable transferable) {
        if (transferable.isDataFlavorSupported(MOVE_GRAPHSUBSET_FLAVOR)) {
            try {
                return (GraphSubset)transferable.getTransferData(MOVE_GRAPHSUBSET_FLAVOR);
            }
            catch (IOException iOException) {
                return null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
        }
        MapperModel mapperModel = this.getMapperModel();
        return mapperModel.getGraphSubset(transferable);
    }

    private Point getDelta(Transferable transferable) {
        if (transferable.isDataFlavorSupported(MOVE_DELTA_FLAVOR)) {
            try {
                return (Point)transferable.getTransferData(MOVE_DELTA_FLAVOR);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return new Point();
            }
            catch (IOException iOException) {
                return new Point();
            }
        }
        return new Point();
    }

    public boolean drop(JComponent jComponent, DropTargetDropEvent dropTargetDropEvent) {
        if (jComponent != this.getCanvas()) {
            return false;
        }
        Point point = dropTargetDropEvent.getLocation();
        MapperModel mapperModel = this.getMapperModel();
        Canvas canvas = this.getCanvas();
        MapperNode mapperNode = canvas.getNodeAt(point.y);
        Point point2 = this.getDelta(dropTargetDropEvent.getTransferable());
        if (mapperNode != null) {
            int n = this.getMapper().getStepSize();
            int n2 = mapperNode.yToNode(point.y - point2.y);
            int n3 = canvas.toGraph(point.x - point2.x);
            if (dropTargetDropEvent.getDropAction() == 1 || this.graphSubSet.getGraph() == null) {
                this.graphSubSet = mapperModel.copy(mapperNode.getTreePath(), this.graphSubSet, (int)Math.round((double)n3 / (double)n), Math.max(0, (int)Math.round((double)n2 / (double)n)));
            } else {
                mapperModel.move(mapperNode.getTreePath(), this.graphSubSet, (int)Math.round((double)n3 / (double)n), Math.max(0, (int)Math.round((double)n2 / (double)n)));
            }
            this.getCanvas().requestFocusInWindow();
            SelectionModel selectionModel = this.getSelectionModel();
            TreePath treePath = mapperNode.getTreePath();
            if (this.graphSubSet != null && this.graphSubSet.getVertexCount() > 0 && !selectionModel.isSelected(treePath, this.graphSubSet.getVertex(0))) {
                selectionModel.setSelected(treePath, this.graphSubSet.getVertex(0));
            }
        }
        this.reset();
        return true;
    }

    public void startDrag(Transferable transferable) {
    }

    public void dragDone() {
    }

    private static synchronized long createUID() {
        return UID++;
    }

    private static class MoveTransferable
    implements Transferable {
        private Point delta;
        private GraphSubset group;

        public MoveTransferable(GraphSubset graphSubset) {
            this.group = graphSubset;
            this.delta = new Point();
        }

        public MoveTransferable(GraphSubset graphSubset, Point point) {
            this.group = graphSubset;
            this.delta = point;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{MOVE_GRAPHSUBSET_FLAVOR, MOVE_DELTA_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == MOVE_GRAPHSUBSET_FLAVOR || dataFlavor == MOVE_DELTA_FLAVOR;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == MOVE_GRAPHSUBSET_FLAVOR) {
                return this.group;
            }
            if (dataFlavor == MOVE_DELTA_FLAVOR) {
                return this.delta;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

