/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.documentation.ui;

import java.awt.BorderLayout;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.core.requirementsframework.IRequirement;
import org.netbeans.modules.uml.documentation.ui.DocumentationPane;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DocumentationTopComponnet
extends TopComponent
implements PropertyChangeListener {
    private PropertyChangeListener listener = null;
    static final long serialVersionUID = 17754071377356384L;
    private static DocumentationTopComponnet mTopComponent = null;
    private static DocumentationPane pane;
    private static IProjectTreeItem current;
    private final String default_title = NbBundle.getMessage(DocumentationTopComponnet.class, (String)"Pane.Documentation.Title");

    public DocumentationTopComponnet() {
        this.initializeTopComponent();
        this.setName(this.default_title);
        String string = NbBundle.getMessage(DocumentationTopComponnet.class, (String)"ACDS_DOCUMENTATION");
        this.getAccessibleContext().setAccessibleDescription(string);
        this.listener = this;
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)TopComponent.getRegistry()));
        pane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)pane));
        this.processActivatedNodes();
    }

    private void initializeTopComponent() {
        if (pane == null) {
            pane = new DocumentationPane(false);
            this.setLayout(new BorderLayout());
            this.add(pane, "Center");
        }
    }

    public static void saveDocumentation() {
        if (pane == null || !pane.isDirty()) {
            return;
        }
        String string = pane.getTrimmedDocumentation();
        if (current != null) {
            if (current.getModelElement() != null) {
                current.getModelElement().setDocumentation(string);
            } else if (current.getDiagram() != null) {
                current.getDiagram().setDocumentation(string);
            }
            pane.setDocumentText(string);
        }
    }

    public boolean canClose() {
        DocumentationTopComponnet.saveDocumentation();
        return true;
    }

    public static synchronized DocumentationTopComponnet getDefault() {
        if (mTopComponent == null) {
            mTopComponent = new DocumentationTopComponnet();
        }
        return mTopComponent;
    }

    public static synchronized DocumentationTopComponnet getInstance() {
        if (mTopComponent == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("documentation");
            mTopComponent = topComponent != null ? (DocumentationTopComponnet)topComponent : new DocumentationTopComponnet();
        }
        return mTopComponent;
    }

    public int getPersistenceType() {
        return 0;
    }

    public String preferredID() {
        return this.getClass().getName();
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/uml/documentation/ui/resources/DocPane.gif");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DDEToolsDocumentation2_htm_wp1342319");
    }

    public void componentActivated() {
        super.componentActivated();
        pane.getTextPane().requestFocusInWindow();
    }

    public void componentShowing() {
        super.componentShowing();
        pane.addPropertyChangeListener(this);
    }

    public void componentHidden() {
        super.componentHidden();
        pane.removePropertyChangeListener(this);
    }

    private void clear() {
        pane.setDocumentText("");
        pane.setEnabled(false);
        this.setName(this.default_title);
        current = null;
    }

    private void processActivatedNodes() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 0 || nodeArray.length > 1) {
            this.clear();
            return;
        }
        final IProjectTreeItem iProjectTreeItem = (IProjectTreeItem)nodeArray[0].getCookie(IProjectTreeItem.class);
        if (iProjectTreeItem == null) {
            this.clear();
            return;
        }
        DocumentationTopComponnet.saveDocumentation();
        current = iProjectTreeItem;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DocumentationTopComponnet.this.setName(iProjectTreeItem.getItemText() + " - " + DocumentationTopComponnet.this.default_title);
            }
        });
        if (current.getDiagram() != null) {
            pane.setDocumentText(current.getDiagram().getDocumentation());
        } else if (current.getModelElement() != null) {
            pane.setDocumentText(current.getModelElement().getDocumentation());
        } else if (current.getData() instanceof IRequirement) {
            pane.setDocumentText(((IRequirement)current.getData()).getDescription());
            pane.setEnabled(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("activatedNodes")) {
            DocumentationTopComponnet.saveDocumentation();
            this.processActivatedNodes();
        } else if (propertyChangeEvent.getPropertyName().equals("dirty_state") && current != null) {
            DocumentationTopComponnet.saveDocumentation();
            current.getProject().setDirty(true);
        }
    }

    static {
        current = null;
    }
}

