/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePairEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.AbstractDDTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTablePanel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.SortableDDTableModel;

public class NameValuePairsPropertyEditor
extends PropertyEditorSupport {
    NameValuePair[] params;
    static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/editors/Bundle");
    protected static String[] requiredToolTips = new String[]{bundle.getString("tipParamName"), bundle.getString("tipParamValue")};

    public NameValuePairsPropertyEditor(NameValuePair[] nameValuePairArray) {
        this.params = nameValuePairArray == null ? new NameValuePair[0] : nameValuePairArray;
    }

    public NameValuePairsPropertyEditor(Object object) {
        this.params = object == null ? new NameValuePair[0] : this.getNameValuePairs(object);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return this.getPaintableString();
    }

    public Component getCustomEditor() {
        ParamModel paramModel = null;
        paramModel = new ParamModel(this.params);
        DDTablePanel dDTablePanel = new DDTablePanel(new SortableDDTableModel(paramModel), requiredToolTips);
        return dDTablePanel;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getPaintableString();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, 4, (rectangle.height - fontMetrics.getHeight()) / 2 + 1 + fontMetrics.getMaxAscent());
    }

    protected String getPaintableString() {
        Object[] objectArray = (Object[])this.getValue();
        if (objectArray == null || objectArray.length == 0) {
            return bundle.getString("TXT_Param");
        }
        if (objectArray.length == 1) {
            return bundle.getString("TXT_OneParam");
        }
        return MessageFormat.format(bundle.getString("TXT_MultiParam"), Integer.toString(objectArray.length));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setValue(Object object) {
        if (object instanceof NameValuePair[]) {
            NameValuePair[] nameValuePairArray = (NameValuePair[])object;
            this.params = new NameValuePair[nameValuePairArray.length];
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                NameValuePair nameValuePair = new NameValuePair();
                nameValuePair.setParamName(nameValuePairArray[i].getParamName());
                nameValuePair.setParamValue(nameValuePairArray[i].getParamValue());
                this.params[i] = nameValuePair;
            }
        } else {
            this.params = this.getNameValuePairs(object);
        }
    }

    public Object getValue() {
        NameValuePair[] nameValuePairArray = new NameValuePair[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            NameValuePair nameValuePair = new NameValuePair();
            nameValuePair.setParamName(this.params[i].getParamName());
            nameValuePair.setParamValue(this.params[i].getParamValue());
            nameValuePairArray[i] = nameValuePair;
        }
        return nameValuePairArray;
    }

    private NameValuePair[] getNameValuePairs(Object object) {
        Map map = (Map)object;
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        NameValuePair[] nameValuePairArray = new NameValuePair[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            NameValuePair nameValuePair = new NameValuePair();
            Object k = iterator.next();
            nameValuePair.setParamName(k.toString());
            nameValuePair.setParamValue(map.get(k).toString());
            nameValuePairArray[n] = nameValuePair;
            ++n;
        }
        return nameValuePairArray;
    }

    public class ParamModel
    extends AbstractDDTableModel {
        public ParamModel(NameValuePair[] nameValuePairArray) {
            super(nameValuePairArray);
        }

        public String getColumnName(int n) {
            if (0 == n) {
                return bundle.getString("colHdrParamName");
            }
            return bundle.getString("colHdrParamValue");
        }

        public Object getValueAt(int n, int n2) {
            NameValuePair nameValuePair = null;
            nameValuePair = (NameValuePair)this.data.get(n);
            if (null != nameValuePair) {
                if (0 == n2) {
                    return nameValuePair.getParamName();
                }
                return nameValuePair.getParamValue();
            }
            return null;
        }

        public List isValueValid(Object object, int n) {
            Vector<String> vector = new Vector<String>();
            NameValuePair nameValuePair = (NameValuePair)object;
            String string = nameValuePair.getParamName();
            String string2 = nameValuePair.getParamValue();
            NameValuePair nameValuePair2 = null;
            String string3 = null;
            if (string == null || string.trim().length() == 0) {
                vector.add(bundle.getString("ERR_InvalidEntry"));
            } else if (string2 == null || string2.trim().length() == 0) {
                vector.add(bundle.getString("ERR_NoValue"));
            }
            for (int i = 0; i < this.data.size(); ++i) {
                nameValuePair2 = (NameValuePair)this.data.elementAt(i);
                string3 = nameValuePair2.getParamName();
                if (i == n || !string3.equals(string)) continue;
                vector.add(bundle.getString("ERR_DuplicateEntry"));
            }
            return vector;
        }

        public boolean isEditValid(Object object, int n) {
            return true;
        }

        public String getModelName() {
            return bundle.getString("ParamModel_modelName");
        }

        public DDTableModelEditor getEditor() {
            return new NameValuePairEditor();
        }

        protected void setValueAt(String string, Object object, int n) {
            NameValuePair nameValuePair = (NameValuePair)object;
            if (0 == n) {
                nameValuePair.setParamName(string);
            } else {
                nameValuePair.setParamValue(string);
            }
        }

        public Object makeNewElement() {
            NameValuePair nameValuePair = new NameValuePair();
            nameValuePair.setParamName("");
            nameValuePair.setParamValue("");
            return nameValuePair;
        }

        public Object[] getValue() {
            return this.data.toArray();
        }

        public int getColumnCount() {
            return 2;
        }
    }
}

