/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader;

import java.io.InputStream;
import java.util.EventListener;
import org.netbeans.api.xml.cookies.CheckXMLCookie;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JmsResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataLoader;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataNode;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunResourceDataObject
extends XMLDataObject
implements FileChangeListener {
    private static String JDBC_CP = "jdbc-connection-pool";
    private static String JDBC_DS = "jdbc-resource";
    private static String PMF = "persistence-manager-factory-resource";
    private static String MAIL = "mail-resource";
    private static String JMS = "jms-resource";
    private ValidateXMLCookie validateCookie = null;
    private CheckXMLCookie checkCookie = null;
    ConnPoolBean cpBean = null;
    DataSourceBean dsBean = null;
    PersistenceManagerBean pmfBean = null;
    JavaMailSessionBean mailBean = null;
    JMSBean jmsBean = null;
    String resType;

    public SunResourceDataObject(FileObject fileObject, SunResourceDataLoader sunResourceDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)sunResourceDataLoader);
        fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fileObject));
        this.resType = this.getResource(fileObject);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        Node.Cookie cookie = null;
        if (ValidateXMLCookie.class.isAssignableFrom(clazz)) {
            if (this.validateCookie == null) {
                InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
                this.validateCookie = new ValidateXMLSupport(inputSource);
            }
            return (T)this.validateCookie;
        }
        if (CheckXMLCookie.class.isAssignableFrom(clazz)) {
            if (this.checkCookie == null) {
                InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
                this.checkCookie = new CheckXMLSupport(inputSource);
            }
            return (T)this.checkCookie;
        }
        if (cookie == null) {
            cookie = super.getCookie(clazz);
        }
        return (T)cookie;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected Node createNodeDelegate() {
        if (this.resType != null) {
            if (this.resType.equals(JDBC_CP)) {
                ConnPoolBeanDataNode connPoolBeanDataNode = new ConnPoolBeanDataNode(this, this.getPool());
                return connPoolBeanDataNode;
            }
            if (this.resType.equals(JDBC_DS)) {
                DataSourceBeanDataNode dataSourceBeanDataNode = new DataSourceBeanDataNode(this, this.getDataSource());
                return dataSourceBeanDataNode;
            }
            if (this.resType.equals(PMF)) {
                PersistenceManagerBeanDataNode persistenceManagerBeanDataNode = new PersistenceManagerBeanDataNode(this, this.getPersistenceManager());
                return persistenceManagerBeanDataNode;
            }
            if (this.resType.equals(MAIL)) {
                JavaMailSessionBeanDataNode javaMailSessionBeanDataNode = new JavaMailSessionBeanDataNode(this, this.getMailSession());
                return javaMailSessionBeanDataNode;
            }
            if (this.resType.equals(JMS)) {
                JMSBeanDataNode jMSBeanDataNode = new JMSBeanDataNode(this, this.getJMS());
                return jMSBeanDataNode;
            }
            String string = NbBundle.getMessage(SunResourceDataObject.class, (String)"Info_notSunResource");
            ErrorManager.getDefault().log(1, string);
            return new SunResourceDataNode(this);
        }
        return new SunResourceDataNode(this);
    }

    private String getResource(FileObject fileObject) {
        String string = null;
        try {
            if (!fileObject.isFolder() && fileObject.isValid()) {
                ResourceUtils.migrateResources(fileObject.getParent());
                InputStream inputStream = fileObject.getInputStream();
                Resources resources = DDProvider.getDefault().getResourcesGraph(inputStream);
                JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
                if (jdbcConnectionPoolArray.length != 0) {
                    ConnPoolBean connPoolBean = ConnPoolBean.createBean(jdbcConnectionPoolArray[0]);
                    string = JDBC_CP;
                    this.setPool(connPoolBean);
                    return string;
                }
                JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
                if (jdbcResourceArray.length != 0) {
                    DataSourceBean dataSourceBean = DataSourceBean.createBean(jdbcResourceArray[0]);
                    string = JDBC_DS;
                    this.setDataSource(dataSourceBean);
                    return string;
                }
                PersistenceManagerFactoryResource[] persistenceManagerFactoryResourceArray = resources.getPersistenceManagerFactoryResource();
                if (persistenceManagerFactoryResourceArray.length != 0) {
                    PersistenceManagerBean persistenceManagerBean = PersistenceManagerBean.createBean(persistenceManagerFactoryResourceArray[0]);
                    string = PMF;
                    this.setPersistenceManager(persistenceManagerBean);
                    return string;
                }
                MailResource[] mailResourceArray = resources.getMailResource();
                if (mailResourceArray.length != 0) {
                    JavaMailSessionBean javaMailSessionBean = JavaMailSessionBean.createBean(mailResourceArray[0]);
                    string = MAIL;
                    this.setMailSession(javaMailSessionBean);
                    return string;
                }
                JmsResource[] jmsResourceArray = resources.getJmsResource();
                if (jmsResourceArray.length != 0) {
                    JMSBean jMSBean = JMSBean.createBean(jmsResourceArray[0]);
                    string = JMS;
                    this.setJMS(jMSBean);
                    return string;
                }
                AdminObjectResource[] adminObjectResourceArray = resources.getAdminObjectResource();
                if (adminObjectResourceArray.length != 0) {
                    JMSBean jMSBean = JMSBean.createBean(adminObjectResourceArray[0]);
                    string = JMS;
                    this.setJMS(jMSBean);
                    return string;
                }
                ConnectorResource[] connectorResourceArray = resources.getConnectorResource();
                ConnectorConnectionPool[] connectorConnectionPoolArray = resources.getConnectorConnectionPool();
                if (connectorResourceArray.length != 0 && connectorConnectionPoolArray.length != 0) {
                    JMSBean jMSBean = JMSBean.createBean(resources);
                    string = JMS;
                    this.setJMS(jMSBean);
                    return string;
                }
                return string;
            }
            return string;
        }
        catch (NullPointerException nullPointerException) {
            ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void setPool(ConnPoolBean connPoolBean) {
        this.cpBean = connPoolBean;
    }

    private ConnPoolBean getPool() {
        return this.cpBean;
    }

    private void setDataSource(DataSourceBean dataSourceBean) {
        this.dsBean = dataSourceBean;
    }

    private DataSourceBean getDataSource() {
        return this.dsBean;
    }

    private void setPersistenceManager(PersistenceManagerBean persistenceManagerBean) {
        this.pmfBean = persistenceManagerBean;
    }

    private PersistenceManagerBean getPersistenceManager() {
        return this.pmfBean;
    }

    private void setMailSession(JavaMailSessionBean javaMailSessionBean) {
        this.mailBean = javaMailSessionBean;
    }

    private JavaMailSessionBean getMailSession() {
        return this.mailBean;
    }

    private void setJMS(JMSBean jMSBean) {
        this.jmsBean = jMSBean;
    }

    private JMSBean getJMS() {
        return this.jmsBean;
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.updateDataObject();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.updateDataObject();
    }

    private void updateDataObject() {
        this.resType = this.getResource(this.getPrimaryFile());
    }

    public String getResourceType() {
        return this.resType;
    }
}

