/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.TableRowDialog;
import org.netbeans.modules.web.wizards.ToolTipCombo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MappingEditor
extends JPanel
implements ActionListener {
    private JRadioButton urlRadio;
    private JRadioButton servletRadio;
    private JTextField mappingField;
    private ToolTipCombo servletCombo;
    private JCheckBox[] cb;
    private static final boolean debug = false;
    private Dialog dialog;
    private DialogDescriptor editDialog;
    private static final String URL = "URL";
    private static final String SERVLET = "SERVLET";
    private static final String SELECT_SERVLET = "SELECT";
    private static FilterMappingData fmd;
    private static boolean haveNames;
    private static boolean OK;
    private static final long serialVersionUID = 4947167720581796971L;

    public MappingEditor(FilterMappingData filterMappingData, String[] stringArray) {
        fmd = filterMappingData;
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_filter_mappings_edit"));
        this.initComponents(stringArray);
    }

    boolean isOK() {
        return OK;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.web.wizards.MappingEditor");
    }

    private void initComponents(String[] stringArray) {
        Insets insets = new Insets(4, 20, 4, 0);
        Insets insets2 = new Insets(4, 20, 4, 60);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = -1;
        gridBagConstraints3.weightx = 0.8;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = insets2;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(NbBundle.getMessage(MappingEditor.class, (String)"LBL_name_filter"));
        JTextField jTextField = new JTextField(25);
        jTextField.setText(fmd.getName());
        jTextField.setEnabled(false);
        jTextField.setBackground(this.getBackground());
        jTextField.setDisabledTextColor(Color.black);
        jLabel.setLabelFor(jTextField);
        jLabel.setDisplayedMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_name_filter_mnem").charAt(0));
        jTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_name_filter"));
        this.add((Component)jLabel, gridBagConstraints2);
        this.add((Component)jTextField, gridBagConstraints3);
        this.urlRadio = new JRadioButton(NbBundle.getMessage(MappingEditor.class, (String)"LBL_url"));
        this.urlRadio.setMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_url_mnemonic").charAt(0));
        this.urlRadio.addActionListener(this);
        this.urlRadio.setActionCommand(URL);
        this.urlRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_pattern_mapping"));
        this.servletRadio = new JRadioButton(NbBundle.getMessage(MappingEditor.class, (String)"LBL_servlet"));
        this.servletRadio.setMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_servlet_mnemonic").charAt(0));
        this.servletRadio.addActionListener(this);
        this.servletRadio.setActionCommand(SERVLET);
        this.servletRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_servlet_mapping"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.urlRadio);
        buttonGroup.add(this.servletRadio);
        this.add((Component)this.urlRadio, gridBagConstraints2);
        this.mappingField = new JTextField();
        this.mappingField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MappingEditor.class, (String)"LBL_url"));
        this.mappingField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_pattern_mapping_desc"));
        this.add((Component)this.mappingField, gridBagConstraints3);
        this.add((Component)this.servletRadio, gridBagConstraints2);
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{NbBundle.getMessage(MappingEditor.class, (String)"LBL_no_servlets")};
            haveNames = false;
        }
        this.servletCombo = new ToolTipCombo(stringArray);
        this.servletCombo.setBackground(this.getBackground());
        this.servletCombo.setActionCommand(SELECT_SERVLET);
        this.servletCombo.addActionListener(this);
        this.servletCombo.setEnabled(haveNames);
        this.servletCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_select_servlet"));
        this.servletCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_select_servlet_desc"));
        this.servletRadio.setEnabled(haveNames);
        this.add((Component)this.servletCombo, gridBagConstraints3);
        if (fmd.getType() == FilterMappingData.Type.URL) {
            this.urlRadio.setSelected(true);
            this.mappingField.setText(fmd.getPattern());
        } else {
            this.servletRadio.setSelected(true);
            int n = this.servletCombo.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                if (!this.servletCombo.getModel().getElementAt(i).toString().equals(fmd.getPattern())) continue;
                this.servletCombo.setSelectedIndex(i);
                break;
            }
        }
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(NbBundle.getMessage(MappingEditor.class, (String)"LBL_conditions"));
        jLabel2.setDisplayedMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_conditions_mnemonic").charAt(0));
        this.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.cb = new JCheckBox[4];
        for (int i = 0; i < FilterMappingData.Dispatcher.getAll().length; ++i) {
            String string = FilterMappingData.Dispatcher.getAll()[i].toString();
            this.cb[i] = new JCheckBox(string);
            this.cb[i].setMnemonic(string.charAt(0));
            this.cb[i].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_dispatcher_".concat(string)));
            jPanel.add(this.cb[i]);
        }
        FilterMappingData.Dispatcher[] dispatcherArray = fmd.getDispatcher();
        for (int i = 0; i < dispatcherArray.length; ++i) {
            if (dispatcherArray[i] == FilterMappingData.Dispatcher.REQUEST) {
                this.cb[0].setSelected(true);
                continue;
            }
            if (dispatcherArray[i] == FilterMappingData.Dispatcher.FORWARD) {
                this.cb[1].setSelected(true);
                continue;
            }
            if (dispatcherArray[i] == FilterMappingData.Dispatcher.INCLUDE) {
                this.cb[2].setSelected(true);
                continue;
            }
            if (dispatcherArray[i] != FilterMappingData.Dispatcher.ERROR) continue;
            this.cb[3].setSelected(true);
        }
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = -1;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weighty = 1.0;
        this.add((Component)jPanel2, gridBagConstraints4);
    }

    public void showEditor() {
        String string = NbBundle.getMessage(MappingEditor.class, (String)"TITLE_filter_mapping");
        this.editDialog = new DialogDescriptor((Object)this, string, true, 2, DialogDescriptor.CANCEL_OPTION, 0, null, (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
        this.dialog.pack();
        this.dialog.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == URL) {
            fmd.setType(FilterMappingData.Type.URL);
            fmd.setPattern(this.mappingField.getText().trim());
            this.mappingField.requestFocus();
            return;
        }
        if (actionEvent.getActionCommand() == SERVLET) {
            if (!haveNames) {
                return;
            }
            fmd.setType(FilterMappingData.Type.SERVLET);
            fmd.setPattern(this.servletCombo.getSelectedItem().toString());
            this.servletCombo.requestFocus();
            return;
        }
        if (actionEvent.getActionCommand() == SELECT_SERVLET) {
            if (!haveNames) {
                return;
            }
            fmd.setType(FilterMappingData.Type.SERVLET);
            this.servletRadio.setSelected(true);
            fmd.setPattern(this.servletCombo.getSelectedItem().toString());
            return;
        }
        Object object = this.editDialog.getValue();
        if (DialogDescriptor.CANCEL_OPTION.equals(object) || DialogDescriptor.CLOSED_OPTION.equals(object)) {
            OK = false;
            this.dialog.dispose();
            return;
        }
        if (fmd.getType() == FilterMappingData.Type.URL) {
            fmd.setPattern(this.mappingField.getText().trim());
            if (fmd.getPattern().length() == 0) {
                this.notifyBadInput(NbBundle.getMessage(TableRowDialog.class, (String)"MSG_no_pattern"));
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        for (n = 0; n < 4; ++n) {
            if (!this.cb[n].isSelected()) continue;
            ++n2;
        }
        FilterMappingData.Dispatcher[] dispatcherArray = new FilterMappingData.Dispatcher[n2];
        n2 = 0;
        if (this.cb[0].isSelected()) {
            dispatcherArray[n2] = FilterMappingData.Dispatcher.REQUEST;
            ++n2;
        }
        if (this.cb[1].isSelected()) {
            dispatcherArray[n2] = FilterMappingData.Dispatcher.FORWARD;
            ++n2;
        }
        if (this.cb[2].isSelected()) {
            dispatcherArray[n2] = FilterMappingData.Dispatcher.INCLUDE;
            ++n2;
        }
        if (this.cb[3].isSelected()) {
            dispatcherArray[n2] = FilterMappingData.Dispatcher.ERROR;
        }
        fmd.setDispatcher(dispatcherArray);
        OK = true;
        this.dialog.dispose();
    }

    private void notifyBadInput(String string) {
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(TableRowDialog.class, (String)"MSG_invalid_input"), -1, 0, objectArray, objectArray[0]);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    private void log(String string) {
        System.out.println("MappingEditor" + string);
    }

    static {
        haveNames = true;
        OK = false;
    }
}

