/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.openide.util.NbBundle;

class MappingTable
extends JTable {
    private static final boolean debug = false;
    private boolean fontChanged = true;
    private int margin = 6;
    private static final long serialVersionUID = 3482048644419079279L;

    MappingTable(String string, ArrayList arrayList) {
        this.setModel(new MappingTableModel(string, arrayList));
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(72);
        tableColumnModel.getColumn(1).setPreferredWidth(72);
        this.setSelectionMode(0);
        this.setColors(false);
        this.setIntercellSpacing(new Dimension(this.margin, this.margin));
    }

    ArrayList getFilterMappings() {
        return ((MappingTableModel)this.getModel()).getFilterMappings();
    }

    void setFilterName(String string) {
        ((MappingTableModel)this.getModel()).setFilterName(string);
        this.invalidate();
    }

    void addRow(FilterMappingData filterMappingData) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).addRow(filterMappingData);
    }

    void addRow(int n, FilterMappingData filterMappingData) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).addRow(n, filterMappingData);
    }

    void setRow(int n, FilterMappingData filterMappingData) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).setRow(n, filterMappingData);
    }

    FilterMappingData getRow(int n) {
        return ((MappingTableModel)this.getModel()).getRow(n);
    }

    void moveRowUp(int n) {
        ((MappingTableModel)this.getModel()).moveRowUp(n);
        this.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        this.invalidate();
    }

    void moveRowDown(int n) {
        ((MappingTableModel)this.getModel()).moveRowUp(n + 1);
        this.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        this.invalidate();
    }

    void removeRow(int n) {
        ((MappingTableModel)this.getModel()).removeRow(n);
        this.invalidate();
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    private void setColors(boolean bl) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color color = !bl ? this.getBackground().darker() : Color.white;
        this.setBackground(color);
    }

    void addTableModelListener(TableModelListener tableModelListener) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.addTableModelListener(tableModelListener);
        }
    }

    void removeTableModelListener(TableModelListener tableModelListener) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.removeTableModelListener(tableModelListener);
        }
    }

    public void setFont(Font font) {
        this.fontChanged = true;
        super.setFont(font);
    }

    public void paint(Graphics graphics) {
        if (this.fontChanged) {
            this.fontChanged = false;
            int n = 0;
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            n = fontMetrics.getHeight() + this.margin;
            if (n > this.rowHeight) {
                this.rowHeight = n;
            }
            this.setRowHeight(this.rowHeight);
            return;
        }
        super.paint(graphics);
    }

    private void log(String string) {
        System.out.println("MappingTable" + string);
    }

    class MappingTableModel
    extends AbstractTableModel {
        private final String[] colheaders = new String[]{NbBundle.getMessage(MappingTable.class, (String)"LBL_filter_name"), NbBundle.getMessage(MappingTable.class, (String)"LBL_applies_to")};
        private ArrayList filterMappings = null;
        private String filterName;
        private static final long serialVersionUID = 2845252365404044474L;

        MappingTableModel(String string, ArrayList arrayList) {
            this.filterName = string;
            this.filterMappings = arrayList;
        }

        ArrayList getFilterMappings() {
            return this.filterMappings;
        }

        void setFilterName(String string) {
            for (FilterMappingData filterMappingData : this.filterMappings) {
                if (!filterMappingData.getName().equals(this.filterName)) continue;
                filterMappingData.setName(string);
            }
            this.filterName = string;
        }

        public int getColumnCount() {
            return this.colheaders.length;
        }

        public int getRowCount() {
            return this.filterMappings.size();
        }

        public String getColumnName(int n) {
            return this.colheaders[n];
        }

        public Object getValueAt(int n, int n2) {
            FilterMappingData filterMappingData = (FilterMappingData)this.filterMappings.get(n);
            if (n2 == 0) {
                return filterMappingData.getName();
            }
            return filterMappingData.getPattern();
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        void addRow(int n, FilterMappingData filterMappingData) {
            this.filterMappings.add(n, filterMappingData);
        }

        void addRow(FilterMappingData filterMappingData) {
            this.filterMappings.add(filterMappingData);
        }

        FilterMappingData getRow(int n) {
            return (FilterMappingData)this.filterMappings.get(n);
        }

        void setRow(int n, FilterMappingData filterMappingData) {
            this.filterMappings.set(n, filterMappingData);
        }

        void moveRowUp(int n) {
            Object e = this.filterMappings.remove(n);
            this.filterMappings.add(n - 1, e);
        }

        void removeRow(int n) {
            this.filterMappings.remove(n);
        }

        private void log(String string) {
            System.out.println("MappingTableModel" + string);
        }
    }
}

