/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.Evaluator;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FinishableProxyWizardPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.ServletPanel;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.modules.web.wizards.WrapperSelection;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServletIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -4147344271705652643L;
    private static final boolean debug = false;
    private transient FileType fileType;
    private transient Evaluator evaluator = null;
    private transient DeployData deployData = null;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wizard;
    private transient ServletPanel servletPanel;
    private transient WizardDescriptor.Panel customPanel;

    private ServletIterator(FileType fileType) {
        this.fileType = fileType;
    }

    public static ServletIterator createServletIterator() {
        return new ServletIterator(FileType.SERVLET);
    }

    public static ServletIterator createFilterIterator() {
        return new ServletIterator(FileType.FILTER);
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
        this.index = 0;
        if (this.fileType.equals(FileType.SERVLET) || this.fileType.equals(FileType.FILTER)) {
            this.deployData = new ServletData(this.fileType);
            this.evaluator = new TargetEvaluator(this.fileType, this.deployData);
        }
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        DataFolder dataFolder = null;
        try {
            dataFolder = templateWizard.getTargetFolder();
        }
        catch (IOException iOException) {
            dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        this.evaluator.setInitialFolder(dataFolder, project);
        if (this.fileType == FileType.SERVLET) {
            this.panels = new WizardDescriptor.Panel[]{new FinishableProxyWizardPanel(this.createPackageChooserPanel(templateWizard, null), new HelpCtx(ServletIterator.class.getName() + "." + this.fileType)), ServletPanel.createServletPanel((TargetEvaluator)this.evaluator, templateWizard)};
        } else if (this.fileType == FileType.FILTER) {
            this.customPanel = new WrapperSelection(templateWizard);
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[3];
            panelArray[0] = this.createPackageChooserPanel(templateWizard, this.customPanel);
            this.servletPanel = ServletPanel.createServletPanel((TargetEvaluator)this.evaluator, templateWizard);
            panelArray[1] = this.servletPanel;
            panelArray[2] = ServletPanel.createFilterPanel((TargetEvaluator)this.evaluator, templateWizard);
            this.panels = panelArray;
        }
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = Utilities.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jComponent = (JComponent)this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = jComponent.getName();
            }
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    private WizardDescriptor.Panel createPackageChooserPanel(TemplateWizard templateWizard, WizardDescriptor.Panel panel) {
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        SourceGroup[] sourceGroupArray = Util.getJavaSourceGroups(project);
        if (panel == null) {
            if (sourceGroupArray.length == 0) {
                return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray);
            }
            return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray);
        }
        if (sourceGroupArray.length == 0) {
            return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)panel);
        }
        return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)panel);
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        FileObject fileObject;
        FileObject fileObject2 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        FileObject fileObject3 = Templates.getTemplate((WizardDescriptor)templateWizard);
        if (FileType.FILTER.equals(this.fileType) && ((WrapperSelection)this.customPanel).isWrapper()) {
            fileObject3 = Templates.getTemplate((WizardDescriptor)templateWizard);
            fileObject = fileObject3.getParent();
            fileObject3 = fileObject.getFileObject("AdvancedFilter", "java");
        }
        fileObject = new HashMap();
        fileObject.put("servletEditorFold", NbBundle.getMessage(ServletIterator.class, (String)"MSG_ServletEditorFold"));
        DataObject dataObject = DataObject.find((FileObject)fileObject3);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)templateWizard), (Map)fileObject);
        if (!this.deployData.makeEntry()) {
            return Collections.singleton(dataObject2);
        }
        TargetEvaluator targetEvaluator = (TargetEvaluator)this.evaluator;
        if (this.deployData.getClassName().length() == 0) {
            String string = templateWizard.getTargetName();
            FileObject fileObject4 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            String string2 = null;
            Project project = Templates.getProject((WizardDescriptor)templateWizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length && string2 == null; ++i) {
                if (WebModule.getWebModule((FileObject)sourceGroupArray[i].getRootFolder()) == null) continue;
                string2 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject4);
            }
            string2 = string2 != null ? string2.replace('/', '.') : "";
            this.deployData.setClassName(string2.length() == 0 ? string : string2 + "." + string);
            String string3 = ((ServletData)this.deployData).createDDServletName(string);
            ((ServletData)this.deployData).createDDServletMapping(string3);
        }
        this.deployData.createDDEntries();
        return Collections.singleton(dataObject2);
    }

    private void log(String string) {
        System.out.println("ServletIterator" + string);
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wizard = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(ServletIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1 && this.deployData.hasDD();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }
}

