/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.TldAttributeType;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.TagHandlerGenerator;
import org.netbeans.modules.web.wizards.TagHandlerSelection;
import org.netbeans.modules.web.wizards.TagInfoPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class TagHandlerIterator
implements TemplateWizard.Iterator {
    private transient FileType fileType;
    private WizardDescriptor.Panel packageChooserPanel;
    private WizardDescriptor.Panel tagHandlerSelectionPanel;
    private WizardDescriptor.Panel tagInfoPanel;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private static final long serialVersionUID = -7586964579556513549L;

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard templateWizard) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = Util.getJavaSourceGroups(project);
        this.tagHandlerSelectionPanel = new TagHandlerSelection(templateWizard);
        this.packageChooserPanel = sourceGroupArray.length == 0 ? Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.tagHandlerSelectionPanel) : JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.tagHandlerSelectionPanel);
        sourceGroupArray = sources.getSourceGroups("doc_root");
        if (sourceGroupArray == null || sourceGroupArray.length == 0) {
            sourceGroupArray = Util.getJavaSourceGroups(project);
        }
        if (sourceGroupArray == null || sourceGroupArray.length == 0) {
            sourceGroupArray = sources.getSourceGroups("generic");
        }
        this.tagInfoPanel = new TagInfoPanel(templateWizard, project, sourceGroupArray);
        return new WizardDescriptor.Panel[]{this.packageChooserPanel, this.tagInfoPanel};
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        Object object;
        JavaSource javaSource;
        FileObject fileObject;
        FileObject fileObject2 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        FileObject fileObject3 = Templates.getTemplate((WizardDescriptor)templateWizard);
        if (((TagHandlerSelection)this.tagHandlerSelectionPanel).isBodyTagSupport()) {
            fileObject = fileObject3.getParent();
            fileObject3 = fileObject.getFileObject("BodyTagHandler", "java");
        }
        fileObject = DataObject.find((FileObject)fileObject3);
        DataObject dataObject = fileObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)templateWizard));
        TagInfoPanel tagInfoPanel = (TagInfoPanel)this.tagInfoPanel;
        Object[][] objectArray = tagInfoPanel.getAttributes();
        boolean bl = ((TagHandlerSelection)this.tagHandlerSelectionPanel).isBodyTagSupport();
        if (objectArray.length > 0 || bl) {
            javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
            boolean bl2 = !((TagInfoPanel)this.tagInfoPanel).isEmpty();
            object = new TagHandlerGenerator(javaSource, objectArray, bl, bl2);
            try {
                ((TagHandlerGenerator)object).generate();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        if (tagInfoPanel.writeToTLD() && (javaSource = tagInfoPanel.getTLDFile()) != null) {
            if (!javaSource.canWrite()) {
                String string = MessageFormat.format(NbBundle.getMessage(TagHandlerIterator.class, (String)"MSG_tldRO"), javaSource.getNameExt());
                object = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            } else {
                Object object2;
                TLDDataObject tLDDataObject = (TLDDataObject)DataObject.find((FileObject)javaSource);
                object = null;
                try {
                    object = tLDDataObject.getTaglib();
                }
                catch (IOException iOException) {
                    String string = MessageFormat.format(NbBundle.getMessage(TagHandlerIterator.class, (String)"MSG_tldCorrupted"), javaSource.getNameExt());
                    object2 = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)object2);
                }
                if (object != null) {
                    TagType tagType = new TagType();
                    tagType.setName(tagInfoPanel.getTagName());
                    tagType.setTagClass(tagInfoPanel.getClassName());
                    if (tagInfoPanel.isEmpty()) {
                        tagType.setBodyContent("empty");
                    } else if (tagInfoPanel.isScriptless()) {
                        tagType.setBodyContent(bl ? "JSP" : "scriptless");
                    } else if (tagInfoPanel.isTegdependent()) {
                        tagType.setBodyContent("tagdependent");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        boolean bl3;
                        object2 = new TldAttributeType();
                        ((TldAttributeType)((Object)object2)).setName((String)objectArray[i][0]);
                        ((TldAttributeType)((Object)object2)).setType((String)objectArray[i][1]);
                        boolean bl4 = (Boolean)objectArray[i][2];
                        if (bl4) {
                            ((TldAttributeType)((Object)object2)).setRequired("true");
                        }
                        if (bl3 = ((Boolean)objectArray[i][3]).booleanValue()) {
                            ((TldAttributeType)((Object)object2)).setRtexprvalue("true");
                        }
                        tagType.addAttribute((TldAttributeType)((Object)object2));
                    }
                    ((Taglib)((Object)object)).addTag(tagType);
                    SaveCookie saveCookie = (SaveCookie)tLDDataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    }
                    try {
                        tLDDataObject.write((Taglib)((Object)object));
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("global").log(Level.WARNING, null, iOException);
                    }
                }
            }
        }
        return Collections.singleton(dataObject);
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project, templateWizard);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = Utilities.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(TagHandlerIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }
}

