/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.TagHandlerPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TagHandlerSelection
implements WizardDescriptor.Panel {
    private transient TagHandlerPanel component;
    private transient TemplateWizard wizard;
    private transient String j2eeVersion;
    private final Set listeners = new HashSet(1);

    public TagHandlerSelection(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
    }

    public Component getComponent() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        WebModule webModule = null;
        this.j2eeVersion = "1.4";
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            webModule = WebModule.getWebModule((FileObject)sourceGroupArray[0].getRootFolder());
        }
        if (webModule != null) {
            this.j2eeVersion = webModule.getJ2eePlatformVersion();
        }
        if (this.component == null) {
            this.component = new TagHandlerPanel(this, this.j2eeVersion);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        if (!this.isBodyTagSupport() && "1.3".equals(this.j2eeVersion)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagHandlerSelection.class, (String)"NOTE_simpleTag"));
        } else {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        if (this.isBodyTagSupport()) {
            wizardDescriptor.putProperty("BODY_SUPPORT", (Object)Boolean.TRUE);
        } else {
            wizardDescriptor.putProperty("BODY_SUPPORT", (Object)Boolean.FALSE);
        }
    }

    boolean isBodyTagSupport() {
        return this.component.isBodyTagSupport();
    }
}

