/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.TargetChooserPanelGUI;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TargetChooserPanel
implements WizardDescriptor.Panel {
    private final List listeners = new ArrayList();
    private TargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private FileType fileType;
    private TemplateWizard templateWizard;
    private String j2eeVersion;
    private static final Pattern INVALID_FILENAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+\\|{};:'\",<>/?]");

    TargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, FileType fileType) {
        this.folders = sourceGroupArray;
        this.project = project;
        this.fileType = fileType;
        if (FileType.TAG.equals(fileType)) {
            WebModule webModule;
            this.j2eeVersion = "1.4";
            if (sourceGroupArray != null && sourceGroupArray.length > 0 && (webModule = WebModule.getWebModule((FileObject)sourceGroupArray[0].getRootFolder())) != null) {
                this.j2eeVersion = webModule.getJ2eePlatformVersion();
            }
        }
    }

    TemplateWizard getTemplateWizard() {
        return this.templateWizard;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new TargetChooserPanelGUI(this, this.project, this.folders, this.fileType);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        boolean bl;
        String string;
        Object object;
        Object object2;
        String string2;
        boolean bl2;
        if (FileType.TAG.equals(this.fileType) && "1.3".equals(this.j2eeVersion)) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_13notSupported"));
            return false;
        }
        boolean bl3 = bl2 = this.gui != null && this.gui.getTargetName() != null;
        if (!bl2) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", null);
            return false;
        }
        if (FileType.TAG.equals(this.fileType) && this.gui.isTldCheckBoxSelected()) {
            string2 = null;
            object2 = this.gui.getTldFileObject();
            object = this.gui.getTagName();
            if (object2 == null) {
                string2 = NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_noTldSelectedForTagFile");
            } else if (TargetChooserPanelGUI.isTagNameEmpty((String)object)) {
                string2 = NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_missingTagName");
            } else if (!TargetChooserPanelGUI.isValidTagName((String)object)) {
                string2 = NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_wrongTagName", (Object)object);
            } else if (this.gui.tagNameExists((String)object)) {
                string2 = NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_tagNameExists", (Object)object);
            }
            if (string2 != null) {
                this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)string2);
                return false;
            }
        }
        if (INVALID_FILENAME_CHARACTERS.matcher(string2 = this.gui.getTargetName()).find()) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_filename", (Object)string2));
            return false;
        }
        if (FileType.TAGLIBRARY.equals(this.fileType) && (((String)(object2 = this.gui.getTargetName())).indexOf(32) >= 0 || ((String)object2).indexOf(44) >= 0)) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_wrongTagLibName", (Object)object2));
            return false;
        }
        object2 = this.gui.getTargetName();
        object = this.gui.getTargetFile();
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.templateWizard);
        String string3 = fileObject.getExt();
        if (FileType.JSP.equals(this.fileType) || FileType.TAG.equals(this.fileType)) {
            if (this.isSegment()) {
                string3 = string3 + "f";
            } else if (this.isXml()) {
                string3 = string3 + "x";
            }
        }
        if ((string = Utilities.canUseFileName((File)object, this.gui.getRelativeTargetFolder(), (String)object2, string3)) != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)string);
        } else {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)this.gui.getErrorMessage());
        }
        boolean bl4 = bl = this.gui.isPanelValid() && string == null;
        if (bl && ((String)object2).indexOf(".") >= 0) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_dotsInName", (Object)((String)object2 + "." + string3)));
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        if (this.gui != null) {
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.templateWizard);
            this.gui.initValues(project, Templates.getTemplate((WizardDescriptor)this.templateWizard), fileObject);
            if (FileType.JSP.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_JspFile"));
            } else if (FileType.TAG.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_TagFile"));
            } else if (FileType.TAGLIBRARY.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_TLD"));
            } else if (FileType.HTML.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_HTML"));
            } else if (FileType.CSS.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_CSS"));
            } else if (FileType.XHTML.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_XHTML"));
            }
        }
    }

    public void storeSettings(Object object) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (WizardDescriptor.CANCEL_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (this.isValid()) {
            File file = new File(this.gui.getCreatedFilePath());
            File file2 = new File(file.getParentFile().getPath());
            if (!file2.exists()) {
                try {
                    FileUtil.createFolder((File)file2);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                }
            }
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)object), (FileObject)fileObject);
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)object), (String)this.gui.getTargetName());
        }
        ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
    }

    boolean isXml() {
        return this.gui.isXml();
    }

    boolean isSegment() {
        return this.gui.isSegment();
    }

    String getUri() {
        return this.gui.getUri();
    }

    String getPrefix() {
        return this.gui.getPrefix();
    }

    boolean isTldCheckBoxSelected() {
        return this.gui.isTldCheckBoxSelected();
    }

    String getTagName() {
        return this.gui.getTagName();
    }

    FileObject getTldFileObject() {
        return this.gui.getTldFileObject();
    }
}

