/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.openide.util.Parameters;

public final class MethodModelSupport {
    private static final Logger LOG = Logger.getLogger(MethodModelSupport.class.getName());

    private MethodModelSupport() {
    }

    public static MethodModel createMethodModel(CompilationController compilationController, ExecutableElement executableElement) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        Parameters.notNull((CharSequence)"method", (Object)executableElement);
        ArrayList<MethodModel.Variable> arrayList = new ArrayList<MethodModel.Variable>();
        for (VariableElement object : executableElement.getParameters()) {
            String string = MethodModelSupport.getTypeName(compilationController, object.asType());
            String string2 = object.getSimpleName().toString();
            arrayList.add(MethodModel.Variable.create(string, string2));
        }
        ArrayList arrayList2 = new ArrayList();
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            arrayList2.add(MethodModelSupport.getTypeName(compilationController, typeMirror));
        }
        return MethodModel.create(executableElement.getSimpleName().toString(), MethodModelSupport.getTypeName(compilationController, executableElement.getReturnType()), "", arrayList, arrayList2, executableElement.getModifiers());
    }

    public static MethodModel.Variable createVariable(CompilationController compilationController, VariableElement variableElement) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        Parameters.notNull((CharSequence)"variableElement", (Object)variableElement);
        return MethodModel.Variable.create(MethodModelSupport.getTypeName(compilationController, variableElement.asType()), variableElement.getSimpleName().toString(), variableElement.getModifiers().contains((Object)Modifier.FINAL));
    }

    public static MethodTree createMethodTree(WorkingCopy workingCopy, MethodModel methodModel) {
        return MethodModelSupport.createMethodTree(workingCopy, methodModel, false);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodTree createMethodTree(WorkingCopy workingCopy, MethodModel methodModel, boolean bl) {
        void var6_10;
        void var7_16;
        Parameters.notNull((CharSequence)"workingCopy", (Object)workingCopy);
        Parameters.notNull((CharSequence)"methodModel", (Object)methodModel);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        if (methodModel.getParameters() != null) {
            for (MethodModel.Variable object22 : methodModel.getParameters()) {
                VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(object22.getFinalModifier() ? Collections.singleton(Modifier.FINAL) : Collections.emptySet()), (CharSequence)object22.getName(), MethodModelSupport.getTypeTree(workingCopy, object22.getType()), null);
                arrayList.add(variableTree);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string : methodModel.getExceptions()) {
            arrayList2.add(MethodModelSupport.createQualIdent(workingCopy, string));
        }
        String string = methodModel.getBody();
        if (bl && (string == null || "".equals(string.trim()))) {
            String string2;
            String string3 = MethodModelSupport.getDefaultReturnValue(workingCopy, methodModel.getReturnType());
            String string4 = string2 = string3 == null ? "" : "return " + string3 + ";";
        }
        if (var7_16 == null) {
            MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(methodModel.getModifiers()), (CharSequence)methodModel.getName(), MethodModelSupport.getTypeTree(workingCopy, methodModel.getReturnType()), Collections.emptyList(), arrayList, (List)arrayList2, (BlockTree)null, null);
        } else {
            MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(methodModel.getModifiers()), (CharSequence)methodModel.getName(), MethodModelSupport.getTypeTree(workingCopy, methodModel.getReturnType()), Collections.emptyList(), arrayList, (List)arrayList2, "{" + (String)var7_16 + "}", null);
        }
        return (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)var6_10);
    }

    public static boolean isSameMethod(CompilationController compilationController, ExecutableElement executableElement, MethodModel methodModel) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationController);
        Parameters.notNull((CharSequence)"method", (Object)executableElement);
        Parameters.notNull((CharSequence)"methodModel", (Object)methodModel);
        if (!executableElement.getSimpleName().contentEquals(methodModel.getName())) {
            return false;
        }
        List<? extends VariableElement> list = executableElement.getParameters();
        if (list.size() != methodModel.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            MethodModel.Variable variable;
            VariableElement variableElement = list.get(i);
            String string = MethodModelSupport.getTypeName(compilationController, variableElement.asType());
            if (string.equals((variable = methodModel.getParameters().get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    public static String getDefaultReturnValue(WorkingCopy workingCopy, String string) {
        if ("boolean".equals(string)) {
            return "false";
        }
        if ("byte".equals(string)) {
            return "0";
        }
        if ("short".equals(string)) {
            return "0";
        }
        if ("int".equals(string)) {
            return "0";
        }
        if ("long".equals(string)) {
            return "0L";
        }
        if ("char".equals(string)) {
            return "'c'";
        }
        if ("float".equals(string)) {
            return "0.0f";
        }
        if ("double".equals(string)) {
            return "0.0d";
        }
        if ("void".equals(string)) {
            return null;
        }
        return "null";
    }

    private static Tree getTypeTree(WorkingCopy workingCopy, String string) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        TypeKind typeKind = null;
        if ("boolean".equals(string)) {
            typeKind = TypeKind.BOOLEAN;
        } else if ("byte".equals(string)) {
            typeKind = TypeKind.BYTE;
        } else if ("short".equals(string)) {
            typeKind = TypeKind.SHORT;
        } else if ("int".equals(string)) {
            typeKind = TypeKind.INT;
        } else if ("long".equals(string)) {
            typeKind = TypeKind.LONG;
        } else if ("char".equals(string)) {
            typeKind = TypeKind.CHAR;
        } else if ("float".equals(string)) {
            typeKind = TypeKind.FLOAT;
        } else if ("double".equals(string)) {
            typeKind = TypeKind.DOUBLE;
        } else if ("void".equals(string)) {
            typeKind = TypeKind.VOID;
        }
        if (typeKind != null) {
            return treeMaker.PrimitiveType(typeKind);
        }
        return MethodModelSupport.createQualIdent(workingCopy, string);
    }

    private static ExpressionTree createQualIdent(WorkingCopy workingCopy, String string) {
        TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
        if (typeElement == null && (typeElement = workingCopy.getElements().getTypeElement("java.lang." + string)) == null) {
            return workingCopy.getTreeMaker().Identifier((CharSequence)string);
        }
        return workingCopy.getTreeMaker().QualIdent((Element)typeElement);
    }

    static String getTypeName(CompilationController compilationController, TypeMirror typeMirror) {
        TypeKind typeKind = typeMirror.getKind();
        switch (typeKind) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case VOID: {
                return "void";
            }
            case DECLARED: {
                Element element = compilationController.getTypes().asElement(typeMirror);
                return ((TypeElement)element).getQualifiedName().toString();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                TypeMirror typeMirror2 = arrayType.getComponentType();
                return MethodModelSupport.getTypeName(compilationController, typeMirror2) + "[]";
            }
        }
        LOG.warning("Type cannot be recognized for " + typeMirror.getClass().getName() + " of kind " + (Object)((Object)typeKind));
        return null;
    }
}

