/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathModifier
extends ProjectClassPathModifierImplementation {
    public static final int ADD = 1;
    public static final int ADD_NO_HEURISTICS = 3;
    public static final int REMOVE = 2;
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator eval;
    private final ClassPathSupport cs;
    private final AntProjectHelper antHelper;
    private ReferenceHelper refHelper;
    private Callback cpModifierCallback;
    private ClassPathSupport.Callback cpSupportCallback;
    private ClassPathUiSupport.Callback cpUiSupportCallback;
    private String[] libUpdaterProperties;
    private static final Logger LOG = Logger.getLogger(ClassPathModifier.class.getName());

    public ClassPathModifier(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, ClassPathSupport.Callback callback, Callback callback2, ClassPathUiSupport.Callback callback3, String[] stringArray) {
        assert (project != null);
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        assert (stringArray != null && stringArray.length > 0);
        this.project = project;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.antHelper = updateHelper.getAntProjectHelper();
        this.cs = new ClassPathSupport(propertyEvaluator, referenceHelper, this.antHelper, updateHelper, callback);
        this.cpModifierCallback = callback2;
        this.cpSupportCallback = callback;
        this.cpUiSupportCallback = callback3;
        this.libUpdaterProperties = stringArray;
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (sources != null);
        return sources.getSourceGroups("java");
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile", "classpath/execute"};
    }

    protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.removeRoots(ClassPathModifier.convertURLsToURIs((URL[])uRLArray), sourceGroup, string);
    }

    protected boolean removeRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleRoots(uRIArray, string2, this.cpModifierCallback.getElementName(string2), 2);
    }

    protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.addRoots(ClassPathModifier.convertURLsToURIs((URL[])uRLArray), sourceGroup, string);
    }

    public boolean addRoots(URL[] uRLArray, String string) throws IOException, UnsupportedOperationException {
        return this.handleRoots(ClassPathModifier.convertURLsToURIs((URL[])uRLArray), string, this.cpModifierCallback.getElementName(string), 1);
    }

    protected boolean addRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.addRoots(uRIArray, sourceGroup, string, 1);
    }

    public boolean addRoots(URI[] uRIArray, SourceGroup sourceGroup, String string, int n) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleRoots(uRIArray, string2, this.cpModifierCallback.getElementName(string2), n);
    }

    boolean handleRoots(final URI[] uRIArray, final String string, final String string2, final int n) throws IOException, UnsupportedOperationException {
        assert (uRIArray != null) : "The classPathRoots cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = ClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = ClassPathModifier.this.cs.itemsList(string3, string2);
                    boolean bl = false;
                    File file = FileUtil.toFile((FileObject)ClassPathModifier.this.project.getProjectDirectory());
                    for (int i = 0; i < uRIArray.length; ++i) {
                        String string22;
                        Comparable<URI> comparable;
                        if (3 == n || 2 == n) {
                            comparable = LibrariesSupport.getArchiveFile((URI)uRIArray[i]);
                            if (comparable == null) {
                                comparable = uRIArray[i];
                            }
                            string22 = LibrariesSupport.convertURIToFilePath((URI)comparable);
                        } else {
                            string22 = ClassPathModifier.this.performSharabilityHeuristics(uRIArray[i], ClassPathModifier.this.antHelper);
                        }
                        comparable = ClassPathModifier.this.antHelper.resolveFile(string22);
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(string22, file, null);
                        ClassPathModifier.this.cpUiSupportCallback.initItem(item);
                        if (!(n != 1 && n != 3 || list.contains(item))) {
                            list.add(item);
                            bl = true;
                            continue;
                        }
                        if (n != 2) continue;
                        if (list.remove(item)) {
                            bl = true;
                            continue;
                        }
                        Iterator<ClassPathSupport.Item> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ClassPathSupport.Item item2 = iterator.next();
                            if (!item2.isBroken() || item2.getType() != 0 || !string22.equals(item2.getFilePath())) continue;
                            iterator.remove();
                            bl = true;
                        }
                    }
                    if (bl) {
                        String[] stringArray = ClassPathModifier.this.cs.encodeToStrings(list, string2);
                        editableProperties = ClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        ClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(ClassPathModifier.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleAntArtifacts(antArtifactArray, uRIArray, string2, this.cpModifierCallback.getElementName(string2), 2);
    }

    protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleAntArtifacts(antArtifactArray, uRIArray, string2, this.cpModifierCallback.getElementName(string2), 1);
    }

    boolean handleAntArtifacts(final AntArtifact[] antArtifactArray, final URI[] uRIArray, final String string, final String string2, final int n) throws IOException, UnsupportedOperationException {
        assert (antArtifactArray != null) : "Artifacts cannot be null";
        assert (uRIArray != null) : "ArtifactElements cannot be null";
        assert (antArtifactArray.length == uRIArray.length) : "Each artifact has to have corresponding artifactElement";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = ClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = ClassPathModifier.this.cs.itemsList(string3, string2);
                    boolean bl = false;
                    for (int i = 0; i < antArtifactArray.length; ++i) {
                        assert (antArtifactArray[i] != null);
                        assert (uRIArray[i] != null);
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(antArtifactArray[i], uRIArray[i], null);
                        ClassPathModifier.this.cpUiSupportCallback.initItem(item);
                        if (n == 1 && !list.contains(item)) {
                            list.add(item);
                            bl = true;
                            continue;
                        }
                        if (n != 2 || !list.contains(item)) continue;
                        list.remove(item);
                        bl = true;
                    }
                    if (bl) {
                        String[] stringArray = ClassPathModifier.this.cs.encodeToStrings(list, string2);
                        editableProperties = ClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        ClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(ClassPathModifier.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, this.cpModifierCallback.getElementName(string2), 2);
    }

    protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, this.cpModifierCallback.getElementName(string2), 1);
    }

    boolean handleLibraries(Library[] libraryArray, String string, String string2, int n) throws IOException, UnsupportedOperationException {
        int n2;
        ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>(libraryArray.length);
        for (n2 = 0; n2 < libraryArray.length; ++n2) {
            Library library = ClassPathModifier.checkLibrarySharability(this.project, this.antHelper, this.refHelper, libraryArray[n2]);
            ClassPathSupport.Item item = ClassPathSupport.Item.create(library, null);
            this.cpUiSupportCallback.initItem(item);
            arrayList.add(item);
        }
        n2 = this.handleLibraryClassPathItems(arrayList, string, string2, n, true) ? 1 : 0;
        ProjectProperties.storeLibrariesLocations(this.project, this.antHelper, this.cs, this.libUpdaterProperties, null, false);
        return n2 != 0;
    }

    public static Library checkLibrarySharability(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, Library library) throws IOException {
        if (antProjectHelper.isSharableProject()) {
            if (library.getManager().getLocation() == null) {
                LOG.log(Level.FINE, "Client is adding global library [" + library + "] to sharable project.", new Exception());
                Library library2 = referenceHelper.getProjectLibraryManager().getLibrary(library.getName());
                library = library2 != null ? library2 : referenceHelper.copyLibrary(library);
            } else if (!library.getManager().getLocation().equals(referenceHelper.getProjectLibraryManager().getLocation())) {
                throw new UnsupportedOperationException("Adding library '" + library.getName() + "' from '" + library.getManager().getLocation() + "' to project '" + project.getProjectDirectory() + "' is not supported because project libraries are defined in '" + referenceHelper.getProjectLibraryManager().getLocation() + "'");
            }
        }
        return library;
    }

    public boolean handleLibraryClassPathItems(final List<ClassPathSupport.Item> list, final String string, final String string2, final int n, final boolean bl) throws IOException {
        assert (list != null) : "Libraries cannot be null";
        assert (string != null);
        assert (bl || ProjectManager.mutex().isWriteAccess());
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties editableProperties = ClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list2 = ClassPathModifier.this.cs.itemsList(string3, string2);
                    ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>(list.size());
                    for (ClassPathSupport.Item item : list) {
                        assert (item != null);
                        assert (item.getType() == 1);
                        if (n == 1 && !list2.contains(item)) {
                            list2.add(item);
                            arrayList.add(item);
                            continue;
                        }
                        if (n != 2 || !list2.contains(item)) continue;
                        list2.remove(item);
                        arrayList.add(item);
                    }
                    if (!arrayList.isEmpty()) {
                        String[] stringArray = ClassPathModifier.this.cs.encodeToStrings(list2, string2);
                        editableProperties = ClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        ClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        if (bl) {
                            ProjectManager.getDefault().saveProject(ClassPathModifier.this.project);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public ClassPathSupport getClassPathSupport() {
        return this.cs;
    }

    public static interface Callback {
        public String getClassPathProperty(SourceGroup var1, String var2);

        public String getElementName(String var1);
    }
}

