/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.soap.validation;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPOperation;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.validation.MessagePart;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.validation.SOAPComponentValidator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPComponentVisitor
implements SOAPComponent.Visitor {
    private static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    private final SOAPComponentValidator mValidator;
    private final Validation mValidation;
    private final List<Validator.ResultItem> results;

    SOAPComponentVisitor(SOAPComponentValidator sOAPComponentValidator, Validation validation) {
        this.mValidator = sOAPComponentValidator;
        this.mValidation = validation;
        this.results = new LinkedList<Validator.ResultItem>();
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.results;
    }

    public void visit(WSDLModel wSDLModel) {
        Object object;
        Object object2;
        Definitions definitions = wSDLModel.getDefinitions();
        for (Binding object32 : definitions.getBindings()) {
            int n = object32.getExtensibilityElements(SOAPBinding.class).size();
            if (n > 0 && n != 1) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)object32, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Only_one_binding_allowed")));
            }
            Iterator iterator = object32.getExtensibilityElements(SOAPBinding.class).iterator();
            while (iterator.hasNext()) {
                ((SOAPBinding)iterator.next()).accept(this);
            }
            object2 = object32.getBindingOperations().iterator();
            while (object2.hasNext()) {
                BindingOutput bindingOutput;
                BindingOperation bindingOperation = object2.next();
                object = bindingOperation.getExtensibilityElements(SOAPOperation.class);
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    ((SOAPOperation)iterator2.next()).accept(this);
                }
                if (object.size() <= 0) continue;
                BindingInput bindingInput = bindingOperation.getBindingInput();
                if (bindingInput != null) {
                    this.visit(bindingInput);
                }
                if ((bindingOutput = bindingOperation.getBindingOutput()) != null) {
                    this.visit(bindingOutput);
                }
                for (BindingFault bindingFault : bindingOperation.getBindingFaults()) {
                    int n2 = bindingFault.getExtensibilityElements(SOAPFault.class).size();
                    if (n2 == 0) {
                        this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.No_soap_fault_defined")));
                    }
                    if (n2 > 0 && n2 != 1) {
                        this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Only_one_fault_allowed")));
                    }
                    for (SOAPFault sOAPFault : bindingFault.getExtensibilityElements(SOAPFault.class)) {
                        if (sOAPFault.getName() != null && !sOAPFault.getName().equals(bindingFault.getName())) {
                            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Fault_name_not_match")));
                        }
                        sOAPFault.accept(this);
                    }
                }
            }
        }
        Iterator<Service> iterator = definitions.getServices().iterator();
        while (iterator.hasNext()) {
            for (Port port : iterator.next().getPorts()) {
                if (port.getBinding() == null || (object2 = (Binding)port.getBinding().get()) == null) continue;
                int n = object2.getExtensibilityElements(SOAPBinding.class).size();
                object = port.getExtensibilityElements(SOAPAddress.class).iterator();
                if (n > 0 && !object.hasNext()) {
                    this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Missing_SoapAddress")));
                }
                if (port.getExtensibilityElements(SOAPAddress.class).size() > 1) {
                    this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Only_one_SoapAddress_allowed")));
                }
                while (object.hasNext()) {
                    ((SOAPAddress)object.next()).accept(this);
                }
            }
        }
    }

    @Override
    public void visit(SOAPHeader sOAPHeader) {
        String string;
        Object object;
        String string2;
        NamedComponentReference<Message> namedComponentReference = sOAPHeader.getMessage();
        if (namedComponentReference == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeader, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_message")));
        }
        if ((string2 = sOAPHeader.getPart()) == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeader, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_part")));
        }
        try {
            object = sOAPHeader.getUse();
            if (object == null) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeader, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_use")));
            }
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeader, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Unsupported_header_use_attribute")));
        }
        object = sOAPHeader.getEncodingStyles();
        if (object != null) {
            // empty if block
        }
        if ((string = sOAPHeader.getNamespace()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAPAddress sOAPAddress) {
        int n;
        int n2;
        String string = sOAPAddress.getLocation();
        if (string == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPAddress, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Missing_location")));
            return;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(string)) {
            return;
        }
        if (string.indexOf(HTTP_DEFAULT_PORT_TOKEN, 6) > 0) {
            n2 = -1;
            n = -1;
            if (string.startsWith("http://")) {
                n2 = string.indexOf(":", 7);
                if (HTTP_DEFAULT_PORT_TOKEN.equals(string.substring(n2 + 1, n = string.indexOf("/", 7)))) {
                    return;
                }
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPAddress, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
                return;
            }
        }
        if (string.indexOf(HTTPS_DEFAULT_PORT_TOKEN, 7) > 0) {
            n2 = -1;
            n = -1;
            if (string.startsWith("https://")) {
                n2 = string.indexOf(":", 8);
                if (HTTPS_DEFAULT_PORT_TOKEN.equals(string.substring(n2 + 1, n = string.indexOf("/", 8)))) {
                    return;
                }
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPAddress, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
                return;
            }
        }
        if (this.containsToken(string)) {
            if (!this.isValidSoapAddressToken(string)) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPAddress, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_Token_Format")));
                return;
            }
        } else {
            try {
                URI uRI = new URI(string);
                String string2 = uRI.getScheme();
                if (!string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
                    return;
                }
                URL uRL = uRI.toURL();
            }
            catch (Exception exception) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPAddress, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
            }
        }
    }

    @Override
    public void visit(SOAPBinding sOAPBinding) {
        String string = sOAPBinding.getTransportURI();
        if (string == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPBinding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Transport_URI_required")));
        } else if (!string.equals("http://schemas.xmlsoap.org/soap/http")) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPBinding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Unsupported_transport")));
        }
        try {
            SOAPBinding.Style style = sOAPBinding.getStyle();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPBinding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Unsupported_style_attribute")));
        }
    }

    @Override
    public void visit(SOAPBody sOAPBody) {
        Object object;
        String string;
        Collection<String> collection = sOAPBody.getEncodingStyles();
        if (collection != null) {
            // empty if block
        }
        if ((string = sOAPBody.getNamespace()) != null) {
            // empty if block
        }
        try {
            object = sOAPBody.getUse();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPBody, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Unsupported_use_attribute")));
        }
        object = sOAPBody.getParts();
        if (object != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAPFault sOAPFault) {
        String string;
        Collection<String> collection;
        String string2 = sOAPFault.getName();
        if (string2 == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Missing_name")));
        }
        if ((collection = sOAPFault.getEncodingStyles()) != null) {
            // empty if block
        }
        if ((string = sOAPFault.getNamespace()) != null) {
            // empty if block
        }
        try {
            SOAPMessageBase.Use use = sOAPFault.getUse();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Unsupported_use_attribute")));
        }
    }

    @Override
    public void visit(SOAPHeaderFault sOAPHeaderFault) {
        String string;
        Object object;
        String string2;
        NamedComponentReference<Message> namedComponentReference = sOAPHeaderFault.getMessage();
        if (namedComponentReference == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeaderFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_message")));
        }
        if ((string2 = sOAPHeaderFault.getPart()) == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeaderFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_part")));
        }
        try {
            object = sOAPHeaderFault.getUse();
            if (object == null) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeaderFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_use")));
            }
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeaderFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Unsupported_header_fault_use_attribute")));
        }
        object = sOAPHeaderFault.getEncodingStyles();
        if (object != null) {
            // empty if block
        }
        if ((string = sOAPHeaderFault.getNamespace()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAPOperation sOAPOperation) {
        String string = sOAPOperation.getSoapAction();
        if (string != null) {
            // empty if block
        }
        try {
            SOAPBinding.Style style = sOAPOperation.getStyle();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPOperation, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPOperationValidator.Unsupported_style_attribute")));
        }
    }

    private void visit(BindingInput bindingInput) {
        Object object;
        Object object2;
        Object object32;
        HashMap<MessagePart, SOAPMessageBase> hashMap = new HashMap<MessagePart, SOAPMessageBase>();
        List list = bindingInput.getExtensibilityElements(SOAPHeader.class);
        for (Object object32 : list) {
            object32.accept(this);
            this.ensureUniqueParts(hashMap, (SOAPHeaderBase)object32);
            object2 = object32.getSOAPHeaderFaults();
            object = object2.iterator();
            while (object.hasNext()) {
                SOAPHeaderFault sOAPHeaderFault = object.next();
                sOAPHeaderFault.accept(this);
                this.ensureUniqueParts(hashMap, sOAPHeaderFault);
            }
        }
        int n = bindingInput.getExtensibilityElements(SOAPBody.class).size();
        if (n == 0) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Atleast_one_body_Required")));
        } else if (n > 0 && n != 1) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Only_one_body_allowed")));
        }
        object32 = bindingInput.getExtensibilityElements(SOAPBody.class);
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (SOAPBody)object2.next();
            object.accept(this);
            this.ensureUniqueParts(hashMap, (SOAPBody)object, bindingInput);
        }
    }

    private void visit(BindingOutput bindingOutput) {
        Object object;
        Object object2;
        Object object32;
        HashMap<MessagePart, SOAPMessageBase> hashMap = new HashMap<MessagePart, SOAPMessageBase>();
        List list = bindingOutput.getExtensibilityElements(SOAPHeader.class);
        for (Object object32 : list) {
            object32.accept(this);
            this.ensureUniqueParts(hashMap, (SOAPHeaderBase)object32);
            object2 = object32.getSOAPHeaderFaults();
            object = object2.iterator();
            while (object.hasNext()) {
                SOAPHeaderFault sOAPHeaderFault = object.next();
                sOAPHeaderFault.accept(this);
                this.ensureUniqueParts(hashMap, sOAPHeaderFault);
            }
        }
        int n = bindingOutput.getExtensibilityElements(SOAPBody.class).size();
        if (n == 0) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Atleast_one_body_Required")));
        } else if (n > 0 && n != 1) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Only_one_body_allowed")));
        }
        object32 = bindingOutput.getExtensibilityElements(SOAPBody.class);
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (SOAPBody)object2.next();
            object.accept(this);
            this.ensureUniqueParts(hashMap, (SOAPBody)object, bindingOutput);
        }
    }

    private void ensureUniqueParts(Map<MessagePart, SOAPMessageBase> map, SOAPBody sOAPBody, WSDLComponent wSDLComponent) {
        Object object;
        OperationParameter operationParameter;
        if (wSDLComponent instanceof BindingInput) {
            operationParameter = (OperationParameter)((BindingInput)wSDLComponent).getInput().get();
        } else if (wSDLComponent instanceof BindingOutput) {
            operationParameter = (OperationParameter)((BindingOutput)wSDLComponent).getOutput().get();
        } else {
            throw new IllegalArgumentException("(Internal error) Unexpected WSDLComponent sub-type " + wSDLComponent.getClass().getName());
        }
        if (operationParameter == null || operationParameter.getMessage() == null || operationParameter.getMessage().get() == null) {
            return;
        }
        Message message = (Message)operationParameter.getMessage().get();
        List<String> list = sOAPBody.getParts();
        if (list == null || list.isEmpty()) {
            Collection<Part> collection = message.getParts();
            list = new ArrayList<String>(collection.size());
            Iterator object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (Part)object2.next();
                list.add(object.getName());
            }
        }
        for (String string : list) {
            if (string == null || "".equals(string)) continue;
            object = new MessagePart(message, string);
            if (!map.containsKey(object)) {
                map.put((MessagePart)object, sOAPBody);
                continue;
            }
            SOAPMessageBase sOAPMessageBase = map.get(object);
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPBody, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Part_already_in_use_by_elem", (Object)string, (Object)message.getName(), (Object)sOAPMessageBase.getQName().toString())));
        }
    }

    private void ensureUniqueParts(Map<MessagePart, SOAPMessageBase> map, SOAPHeaderBase sOAPHeaderBase) {
        NamedComponentReference<Message> namedComponentReference = sOAPHeaderBase.getMessage();
        if (sOAPHeaderBase == null || sOAPHeaderBase.getMessage() == null || sOAPHeaderBase.getMessage().get() == null) {
            return;
        }
        Message message = (Message)namedComponentReference.get();
        String string = sOAPHeaderBase.getPart();
        if (string != null && !"".equals(string)) {
            MessagePart messagePart = new MessagePart(message, string);
            if (!map.containsKey(messagePart)) {
                map.put(messagePart, sOAPHeaderBase);
            } else {
                SOAPMessageBase sOAPMessageBase = map.get(messagePart);
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAPHeaderBase, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Part_already_in_use_by_elem", (Object)string, (Object)message.getName(), (Object)sOAPMessageBase.getQName().toString())));
            }
        }
    }

    private List<String> allMessageParts(Message message) {
        Collection<Part> collection = message.getParts();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Part part : collection) {
            linkedList.add(part.getName());
        }
        return linkedList;
    }

    private boolean containsToken(String string) {
        return string.contains("${");
    }

    private boolean isValidSoapAddressToken(String string) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = true;
        if (string.startsWith("http://")) {
            string = string.substring(7, string.length());
            bl = true;
        }
        if (string.startsWith("https://")) {
            string = string.substring(8, string.length());
            bl = true;
        }
        if (!bl) {
            n2 = string.indexOf("${");
            n = string.indexOf("}");
            if (n == string.length() - 1 && n2 == 0) {
                bl2 = true;
            } else {
                return false;
            }
        }
        if (string.contains("${")) {
            n2 = string.indexOf(":");
            n = string.lastIndexOf("/");
            if (n != -1) {
                String string2;
                int n3;
                int n4;
                String string3 = string.substring(n + 1, string.length());
                int n5 = string3.indexOf("${");
                if (n5 == 0 ? (n4 = string3.indexOf("}")) < n5 : string3.indexOf("}") > 0) {
                    return false;
                }
                n4 = string.indexOf("${");
                if (n4 == 0 ? (n3 = (string2 = string.substring(1, n2)).indexOf("}")) < 1 : string.substring(1, n2).indexOf("}") > 0) {
                    return false;
                }
                string2 = string.substring(n2 + 1, n);
                if (string2.indexOf("${") != -1 && string2.indexOf("}") > 0) {
                    bl2 = true;
                } else {
                    return false;
                }
            }
        }
        return bl2;
    }
}

