/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileObjectFactory {
    public static Map AllFactories = new HashMap();
    public static boolean WARNINGS = true;
    final Map allIBaseFileObjects = Collections.synchronizedMap(new WeakHashMap());
    private BaseFileObj root;

    private FileObjectFactory(File file) {
        this(new FileInfo(file));
    }

    private FileObjectFactory(FileInfo fileInfo) {
        BaseFileObj baseFileObj;
        File file = fileInfo.getFile();
        assert (file.getParentFile() == null);
        this.root = baseFileObj = this.create(fileInfo);
    }

    public static FileObjectFactory getInstance(File file) {
        return FileObjectFactory.getInstance(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObjectFactory getInstance(File file, boolean bl) {
        FileObjectFactory fileObjectFactory = null;
        FileInfo fileInfo = new FileInfo(file).getRoot();
        File file2 = fileInfo.getFile();
        Map map = AllFactories;
        synchronized (map) {
            fileObjectFactory = (FileObjectFactory)AllFactories.get(file2);
        }
        if (fileObjectFactory == null && bl && fileInfo.isConvertibleToFileObject()) {
            map = AllFactories;
            synchronized (map) {
                fileObjectFactory = (FileObjectFactory)AllFactories.get(file2);
                if (fileObjectFactory == null) {
                    fileObjectFactory = new FileObjectFactory(file2);
                    AllFactories.put(file2, fileObjectFactory);
                }
            }
        }
        return fileObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getInstances() {
        Map map = AllFactories;
        synchronized (map) {
            return new ArrayList(AllFactories.values());
        }
    }

    public final BaseFileObj getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFactoriesSize() {
        Map map = AllFactories;
        synchronized (map) {
            return AllFactories.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int n = 0;
        ArrayList arrayList = new ArrayList();
        Object object = this.allIBaseFileObjects;
        synchronized (object) {
            arrayList.addAll(this.allIBaseFileObjects.values());
        }
        object = new ArrayList();
        for (Object object2 : arrayList) {
            if (object2 instanceof Reference) {
                object.add(object2);
                continue;
            }
            object.addAll((List)object2);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = (Reference)iterator.next();
            FileObject fileObject = object2 != null ? (FileObject)((Reference)object2).get() : null;
            if (fileObject == null) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFileObj getFileObject(FileInfo fileInfo, Caller caller) {
        int n;
        File file = fileInfo.getFile();
        Object var4_4 = null;
        FolderObj folderObj = BaseFileObj.getExistingParentFor(file, this);
        FileNaming fileNaming = null;
        boolean bl = true;
        if (folderObj != null) {
            ChildrenCache childrenCache = folderObj.getChildrenCache();
            Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
            privileged.enterReadAccess();
            try {
                String string = BaseFileObj.getNameExt(file);
                bl = childrenCache.isCacheInitialized();
                fileNaming = childrenCache.getChild(string, false);
            }
            finally {
                privileged.exitReadAccess();
            }
        }
        int n2 = bl ? -1 : (n = fileNaming != null ? 1 : 0);
        if (n == -1 && FileBasedFileSystem.isModificationInProgress()) {
            n = file.exists() ? 1 : 0;
        }
        return this.issueIfExist(file, caller, folderObj, fileNaming, n, !caller.equals((Object)Caller.Others));
    }

    private boolean checkCacheState(boolean bl, File file, Caller caller) {
        return this.checkCacheState(bl, file, caller, false);
    }

    private boolean checkCacheState(boolean bl, File file, Caller caller, boolean bl2) {
        if (!bl && (caller.equals((Object)Caller.GetParent) || caller.equals((Object)Caller.ToFileObject))) {
            return true;
        }
        if (this.isWarningEnabled() && caller != null && !caller.equals((Object)Caller.GetChildern)) {
            File[] fileArray;
            File file2;
            boolean bl3;
            boolean bl4 = file.exists();
            boolean bl5 = bl3 = bl != bl4;
            if (!bl4 && (file2 = file.getParentFile()) != null && (fileArray = file2.listFiles()) != null && Arrays.asList(fileArray).contains(file2)) {
                return true;
            }
            if (bl3) {
                if (bl2) {
                    this.printWarning(file, Status.RecoverFail);
                } else {
                    this.printWarning(file, Status.NoRecover);
                }
            } else if (bl2) {
                this.printWarning(file, Status.RecoverSuccess);
            }
        }
        return true;
    }

    private Integer initRealExists(int n) {
        Integer n2 = new Integer(n);
        return n2;
    }

    private void printWarning(File file, Status status) {
        StringBuilder stringBuilder = new StringBuilder("WARNING(please REPORT):  Externally ");
        stringBuilder.append(file.exists() ? "created " : "deleted ");
        stringBuilder.append(file.isDirectory() ? "folder: " : "file: ");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append("  (For additional information see: http://wiki.netbeans.org/wiki/view/FileSystems)");
        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalStateException.getMessage(), illegalStateException);
    }

    private BaseFileObj issueIfExist(File file, Caller caller, FileObject fileObject, FileNaming fileNaming, int n, boolean bl) {
        boolean bl2 = false;
        BaseFileObj baseFileObj = null;
        Integer n2 = this.initRealExists(n);
        FileChangedManager fileChangedManager = FileChangedManager.getInstance();
        baseFileObj = this.getCachedOnly(file);
        if (fileObject != null && fileObject.isValid()) {
            if (fileNaming != null) {
                if (baseFileObj == null) {
                    boolean bl3 = bl2 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                    if (fileChangedManager.impeachExistence(file, bl2) && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(true, file, caller));
                } else if (baseFileObj.isValid()) {
                    boolean bl4 = bl2 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                    if (fileChangedManager.impeachExistence(file, bl2) && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(bl2, file, caller));
                } else {
                    bl2 = FileObjectFactory.touchExists(file, n2);
                    if (!bl2) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                }
            } else if (baseFileObj == null) {
                boolean bl5 = bl2 = n2 == -1 ? false : FileObjectFactory.touchExists(file, n2);
                if (fileChangedManager.impeachExistence(file, bl2)) {
                    bl2 = FileObjectFactory.touchExists(file, n2);
                }
                assert (this.checkCacheState(bl2, file, caller));
            } else if (baseFileObj.isValid()) {
                bl2 = FileObjectFactory.touchExists(file, n2);
                if (!bl2) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
            } else {
                bl2 = FileObjectFactory.touchExists(file, n2);
                if (bl2) {
                    this.refreshFromGetter(fileObject, bl);
                }
            }
        } else if (baseFileObj == null) {
            bl2 = FileObjectFactory.touchExists(file, n2);
        } else if (baseFileObj.isValid()) {
            if (fileObject == null) {
                boolean bl6 = bl2 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                if (fileChangedManager.impeachExistence(file, bl2) && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
                assert (this.checkCacheState(bl2, file, caller));
            } else {
                bl2 = FileObjectFactory.touchExists(file, n2);
                if (!bl2) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
            }
        } else {
            boolean bl7 = bl2 = n2 == -1 ? false : FileObjectFactory.touchExists(file, n2);
            if (fileChangedManager.impeachExistence(file, bl2)) {
                bl2 = FileObjectFactory.touchExists(file, n2);
            }
            assert (this.checkCacheState(bl2, file, caller));
        }
        if (!bl2) {
            switch (caller) {
                case GetParent: {
                    BaseFileObj baseFileObj2 = null;
                    baseFileObj2 = baseFileObj != null && !baseFileObj.isRoot() ? baseFileObj : this.getOrCreate(new FileInfo(file, 1));
                    if (baseFileObj2 instanceof BaseFileObj && baseFileObj2.isValid() && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                        baseFileObj2.setValid(false);
                    }
                    assert (this.checkCacheState(bl2, file, caller));
                    return baseFileObj2;
                }
                case ToFileObject: {
                    bl2 = FileObjectFactory.touchExists(file, n2);
                    if (bl2 && fileObject != null && fileObject.isValid()) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(bl2, file, caller));
                    break;
                }
            }
        }
        return bl2 ? this.getOrCreate(new FileInfo(file, 1)) : null;
    }

    private static boolean touchExists(File file, Integer n) {
        if (n == -1) {
            n = FileChangedManager.getInstance().exists(file) ? 1 : 0;
        }
        assert (n != -1);
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BaseFileObj getOrCreate(FileInfo fileInfo) {
        Object object;
        boolean bl;
        BaseFileObj baseFileObj = null;
        File file = fileInfo.getFile();
        boolean bl2 = bl = fileInfo.isWindows() && file.getName().endsWith(".");
        if (bl) {
            object = FileUtil.normalizeFile((File)file);
            boolean bl3 = bl = !((File)object).getName().endsWith(".");
            if (bl) {
                return null;
            }
        }
        object = this.allIBaseFileObjects;
        synchronized (object) {
            baseFileObj = this.getCachedOnly(file);
            if (baseFileObj == null || !baseFileObj.isValid()) {
                File file2 = file.getParentFile();
                baseFileObj = file2 != null ? this.create(fileInfo) : this.getRoot();
            }
            return baseFileObj;
        }
    }

    private BaseFileObj create(FileInfo fileInfo) {
        if (fileInfo.isWindowsFloppy()) {
            return null;
        }
        if (!fileInfo.isConvertibleToFileObject()) {
            return null;
        }
        File file = fileInfo.getFile();
        FileNaming fileNaming = fileInfo.getFileNaming();
        FileNaming fileNaming2 = fileNaming = fileNaming == null ? NamingFactory.fromFile(file) : fileNaming;
        if (fileNaming == null) {
            return null;
        }
        if (fileNaming.isFile() && !fileNaming.isDirectory()) {
            FileObj fileObj = new FileObj(file, fileNaming);
            return this.putInCache(fileObj, fileObj.getFileName().getId());
        }
        if (!fileNaming.isFile() && fileNaming.isDirectory()) {
            FolderObj folderObj = new FolderObj(file, fileNaming);
            return this.putInCache(folderObj, folderObj.getFileName().getId());
        }
        assert (false);
        return null;
    }

    public final void refreshAll(boolean bl) {
        Set set = this.collectForRefresh();
        this.refresh(set, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set collectForRefresh() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Map map = this.allIBaseFileObjects;
        synchronized (map) {
            for (Object v : this.allIBaseFileObjects.values()) {
                Object object2;
                if (v instanceof List) {
                    for (Object object2 : (List)v) {
                        BaseFileObj baseFileObj = object2 != null ? ((Reference)object2).get() : null;
                        if (baseFileObj == null) continue;
                        hashSet.add((Object)baseFileObj);
                    }
                    continue;
                }
                WeakReference weakReference = (WeakReference)v;
                object2 = weakReference != null ? weakReference.get() : null;
                if (object2 == null) continue;
                hashSet.add(object2);
            }
        }
        return hashSet;
    }

    private void refresh(Set set, File ... fileArray) {
        block0: for (BaseFileObj baseFileObj : set) {
            for (File file : fileArray) {
                if (!FileObjectFactory.isParentOf(file, baseFileObj.getFileName().getFile())) continue;
                baseFileObj.refresh(true);
                continue block0;
            }
        }
    }

    private void refresh(Set set, boolean bl) {
        for (BaseFileObj baseFileObj : set) {
            baseFileObj.refresh(bl);
        }
    }

    public static boolean isParentOf(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        return file3 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rename() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Map map = this.allIBaseFileObjects;
        synchronized (map) {
            Object object5;
            Object object2;
            Integer n;
            for (Map.Entry object3 : this.allIBaseFileObjects.entrySet()) {
                Object object4;
                Object v = object3.getValue();
                n = (Integer)object3.getKey();
                if (!(v instanceof List)) {
                    object2 = (WeakReference)v;
                    object5 = object2 != null ? ((Reference)object2).get() : null;
                    if (object5 == null || n.equals(object4 = object5.getFileName().getId())) continue;
                    hashMap.put(n, object5);
                    continue;
                }
                for (Object object5 : (List)v) {
                    Integer n2;
                    object4 = object5 != null ? ((Reference)object5).get() : null;
                    if (object4 == null || n.equals(n2 = ((BaseFileObj)((Object)object4)).getFileName().getId())) continue;
                    hashMap.put(n, object5);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                n = entry.getKey();
                object2 = this.allIBaseFileObjects.remove(n);
                if (object2 instanceof List) {
                    object5 = (List)object2;
                    object5.remove(entry.getValue());
                    this.allIBaseFileObjects.put(n, object2);
                    continue;
                }
                object5 = (BaseFileObj)((Object)entry.getValue());
                this.putInCache((BaseFileObj)((Object)object5), object5.getFileName().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseFileObj getCachedOnly(File file) {
        Object var2_5;
        Object object = this.allIBaseFileObjects;
        synchronized (object) {
            Object v = this.allIBaseFileObjects.get(NamingFactory.createID(file));
            Reference reference = null;
            reference = (Reference)(v instanceof Reference ? v : null);
            reference = reference == null && v instanceof List ? FileObjectFactory.getReference((List)v, file) : reference;
            Object v0 = var2_5 = reference != null ? reference.get() : null;
            assert (var2_5 == null || var2_5 instanceof BaseFileObj);
        }
        object = var2_5;
        if (object != null && !file.getName().equals(((BaseFileObj)((Object)object)).getNameExt()) && !file.equals(((BaseFileObj)((Object)object)).getFileName().getFile())) {
            object = null;
        }
        return object;
    }

    private static Reference getReference(List list, File file) {
        Reference reference = null;
        for (int i = 0; reference == null && i < list.size(); ++i) {
            BaseFileObj baseFileObj;
            Reference reference2 = (Reference)list.get(i);
            BaseFileObj baseFileObj2 = baseFileObj = reference2 != null ? (BaseFileObj)((Object)reference2.get()) : null;
            if (baseFileObj == null || baseFileObj.getFileName().getFile().compareTo(file) != 0) continue;
            reference = reference2;
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj putInCache(BaseFileObj baseFileObj, Integer n) {
        Map map = this.allIBaseFileObjects;
        synchronized (map) {
            WeakReference<BaseFileObj> weakReference = new WeakReference<BaseFileObj>(baseFileObj);
            WeakReference<BaseFileObj> weakReference2 = this.allIBaseFileObjects.put(n, weakReference);
            if (weakReference2 != null) {
                if (weakReference2 instanceof List) {
                    ((List)((Object)weakReference2)).add(weakReference);
                    this.allIBaseFileObjects.put(n, weakReference2);
                } else {
                    BaseFileObj baseFileObj2;
                    assert (weakReference2 instanceof WeakReference);
                    Reference reference = weakReference2;
                    BaseFileObj baseFileObj3 = baseFileObj2 = reference != null ? (BaseFileObj)((Object)reference.get()) : null;
                    if (baseFileObj2 != null && !baseFileObj.getFileName().equals(baseFileObj2.getFileName())) {
                        ArrayList<Reference> arrayList = new ArrayList<Reference>();
                        arrayList.add(reference);
                        arrayList.add(weakReference);
                        this.allIBaseFileObjects.put(n, arrayList);
                    }
                }
            }
        }
        return baseFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList arrayList = new ArrayList();
        Object object = this.allIBaseFileObjects;
        synchronized (object) {
            arrayList.addAll(this.allIBaseFileObjects.values());
        }
        object = new ArrayList();
        for (Reference reference : arrayList) {
            FileObject fileObject = reference != null ? (FileObject)reference.get() : null;
            if (fileObject == null) continue;
            object.add(fileObject.getPath());
        }
        return object.toString();
    }

    public static synchronized Map<File, FileObjectFactory> factories() {
        return new HashMap<File, FileObjectFactory>(AllFactories);
    }

    public boolean isWarningEnabled() {
        return WARNINGS && !Utilities.isMac();
    }

    public static void reinitForTests() {
        AllFactories = new HashMap();
    }

    public final BaseFileObj getValidFileObject(File file, Caller caller) {
        BaseFileObj baseFileObj = this.getFileObject(new FileInfo(file), caller);
        return baseFileObj != null && baseFileObj.isValid() ? baseFileObj : null;
    }

    public final void refresh(final boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        final Runnable runnable = new Runnable(){

            public void run() {
                FileObjectFactory.this.refreshAll(bl);
            }
        };
        stopWatch.start();
        try {
            FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileBasedFileSystem.runAsInconsistent(runnable);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        Logger.getLogger("org.netbeans.modules.masterfs.REFRESH").fine("FS.refresh statistics (" + Statistics.fileObjects() + "FileObjects):\n  " + Statistics.REFRESH_FS.toString() + "\n  " + Statistics.LISTENERS_CALLS.toString() + "\n  " + Statistics.REFRESH_FOLDER.toString() + "\n  " + Statistics.REFRESH_FILE.toString() + "\n");
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    public final void refreshFor(final File ... fileArray) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        final Runnable runnable = new Runnable(){

            public void run() {
                Set set = FileObjectFactory.this.collectForRefresh();
                FileObjectFactory.this.refresh(set, fileArray);
            }
        };
        stopWatch.start();
        try {
            FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileBasedFileSystem.runAsInconsistent(runnable);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        Logger.getLogger("org.netbeans.modules.masterfs.REFRESH").fine("FS.refresh statistics (" + Statistics.fileObjects() + "FileObjects):\n  " + Statistics.REFRESH_FS.toString() + "\n  " + Statistics.LISTENERS_CALLS.toString() + "\n  " + Statistics.REFRESH_FOLDER.toString() + "\n  " + Statistics.REFRESH_FILE.toString() + "\n");
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    private void refreshFromGetter(FileObject fileObject, boolean bl) {
        try {
            if (bl) {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new AsyncRefreshAtomicAction(fileObject));
            } else {
                fileObject.refresh();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static class AsyncRefreshAtomicAction
    implements FileSystem.AtomicAction {
        private FileObject fo;

        AsyncRefreshAtomicAction(FileObject fileObject) {
            this.fo = fileObject;
        }

        public void run() throws IOException {
            this.fo.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RecoverSuccess,
        RecoverFail,
        NoRecover;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Caller {
        ToFileObject,
        GetFileObject,
        GetChildern,
        GetParent,
        Others;

    }
}

