/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public final class FolderObj
extends BaseFileObj {
    static final long serialVersionUID = -1022430210876356809L;
    private static final Mutex.Privileged mp = new Mutex.Privileged();
    private static final Mutex mutex = new Mutex(mp);
    private FolderChildrenCache folderChildren;
    boolean valid = true;
    private int bitmask = 0;

    public FolderObj(File file, FileNaming fileNaming) {
        super(file, fileNaming);
    }

    public final boolean isFolder() {
        return true;
    }

    public FileObject getFileObject(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        File file = new File(this.getFileName().getFile(), string);
        FileObjectFactory fileObjectFactory = this.getFactory();
        return fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.GetFileObject);
    }

    public final FileObject getFileObject(String string, String string2) {
        File file = BaseFileObj.getFile(this.getFileName().getFile(), string, string2);
        FileObjectFactory fileObjectFactory = this.getFactory();
        return string.indexOf("/") == -1 ? fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.GetFileObject) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject[] getChildren() {
        HashSet hashSet;
        ArrayList<BaseFileObj> arrayList = new ArrayList<BaseFileObj>();
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterWriteAccess();
        try {
            hashSet = new HashSet(childrenCache.getChildren(false));
        }
        finally {
            privileged.exitWriteAccess();
        }
        FileObjectFactory fileObjectFactory = this.getFactory();
        for (FileNaming fileNaming : hashSet) {
            FileInfo fileInfo = new FileInfo(fileNaming.getFile());
            fileInfo.setFileNaming(fileNaming);
            fileInfo.setValueForFlag(2, true);
            BaseFileObj baseFileObj = fileObjectFactory.getFileObject(fileInfo, FileObjectFactory.Caller.GetChildern);
            if (baseFileObj == null) continue;
            arrayList.add(baseFileObj);
        }
        return arrayList.toArray(new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createFolderImpl(String string) throws IOException {
        Object object;
        File file;
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        BaseFileObj baseFileObj = null;
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterWriteAccess();
        try {
            file = BaseFileObj.getFile(this.getFileName().getFile(), string, null);
            this.createFolder(file, string);
            object = this.getChildrenCache().getChild(file.getName(), true);
            if (object != null && !object.isDirectory()) {
                NamingFactory.remove((FileNaming)object, null);
            }
            if (object != null) {
                NamingFactory.checkCaseSensitivity((FileNaming)object, file);
            }
        }
        finally {
            privileged.exitWriteAccess();
        }
        object = this.getFactory();
        if (object != null) {
            baseFileObj = (FolderObj)((FileObjectFactory)object).getValidFileObject(file, FileObjectFactory.Caller.Others);
        }
        if (baseFileObj != null) {
            baseFileObj.fireFileFolderCreatedEvent(false);
        } else {
            FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
        }
        return baseFileObj;
    }

    private void createFolder(File file, String string) throws IOException {
        boolean bl = new FileInfo(file).isSupportedFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        providedExtensions.beforeCreate(this, file.getName(), true);
        if (!bl) {
            providedExtensions.createFailure(this, file.getName(), true);
            FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
        } else {
            if (FileChangedManager.getInstance().exists(file)) {
                providedExtensions.createFailure(this, file.getName(), true);
                throw new SyncFailedException(file.getAbsolutePath());
            }
            if (!file.mkdirs()) {
                providedExtensions.createFailure(this, file.getName(), true);
                FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
            }
        }
        LogRecord logRecord = new LogRecord(Level.FINEST, "FolderCreated: " + file.getAbsolutePath());
        logRecord.setParameters(new Object[]{file});
        Logger.getLogger("org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj").log(logRecord);
    }

    public final FileObject createData(final String string, final String string2) throws IOException {
        FileBasedFileSystem.FSCallable<FileObject> fSCallable = new FileBasedFileSystem.FSCallable<FileObject>(){

            @Override
            public FileObject call() throws IOException {
                return FolderObj.this.createDataImpl(string, string2);
            }
        };
        return FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    public final FileObject createFolder(final String string) throws IOException {
        FileBasedFileSystem.FSCallable<FileObject> fSCallable = new FileBasedFileSystem.FSCallable<FileObject>(){

            @Override
            public FileObject call() throws IOException {
                return FolderObj.this.createFolderImpl(string);
            }
        };
        return FileBasedFileSystem.runAsInconsistent(fSCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createDataImpl(String string, String string2) throws IOException {
        Object object;
        File file;
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterWriteAccess();
        try {
            file = BaseFileObj.getFile(this.getFileName().getFile(), string, string2);
            this.createData(file);
            object = this.getChildrenCache().getChild(file.getName(), true);
            if (object != null && object.isDirectory()) {
                NamingFactory.remove((FileNaming)object, null);
            }
            if (object != null) {
                NamingFactory.checkCaseSensitivity((FileNaming)object, file);
            }
        }
        finally {
            privileged.exitWriteAccess();
        }
        object = this.getFactory();
        FileObj fileObj = null;
        if (object != null) {
            fileObj = (FileObj)((FileObjectFactory)object).getValidFileObject(file, FileObjectFactory.Caller.Others);
        }
        if (fileObj != null) {
            if (fileObj instanceof FileObj) {
                fileObj.setLastModified(file.lastModified());
            }
            fileObj.fireFileDataCreatedEvent(false);
        } else {
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        }
        return fileObj;
    }

    private void createData(File file) throws IOException {
        boolean bl = new FileInfo(file).isSupportedFile();
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        providedExtensions.beforeCreate(this, file.getName(), false);
        if (!bl) {
            providedExtensions.createFailure(this, file.getName(), false);
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        } else {
            if (FileChangedManager.getInstance().exists(file)) {
                providedExtensions.createFailure(this, file.getName(), false);
                throw new SyncFailedException(file.getAbsolutePath());
            }
            if (!file.createNewFile()) {
                providedExtensions.createFailure(this, file.getName(), false);
                FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
            }
        }
        LogRecord logRecord = new LogRecord(Level.FINEST, "DataCreated: " + file.getAbsolutePath());
        logRecord.setParameters(new Object[]{file});
        Logger.getLogger("org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj").log(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock fileLock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        Object object;
        LinkedList linkedList = new LinkedList();
        File file = this.getFileName().getFile();
        if (!this.deleteFile(file, linkedList, this.getFactory(), deleteHandler)) {
            FolderObj folderObj = this.getExistingParent();
            object = folderObj != null ? folderObj.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotDelete", file.getName(), object);
        }
        BaseFileObj.attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
        this.setValid(false);
        for (int i = 0; i < linkedList.size(); ++i) {
            ChildrenCache childrenCache;
            object = (BaseFileObj)((Object)linkedList.get(i));
            FolderObj folderObj = ((BaseFileObj)((Object)object)).getExistingParent();
            ChildrenCache childrenCache2 = childrenCache = folderObj != null ? folderObj.getChildrenCache() : null;
            if (childrenCache != null) {
                Mutex.Privileged privileged;
                Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (privileged != null) {
                    privileged.enterWriteAccess();
                }
                try {
                    if (deleteHandler != null) {
                        childrenCache.removeChild(((BaseFileObj)((Object)object)).getFileName());
                    } else {
                        childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                    }
                }
                finally {
                    if (privileged != null) {
                        privileged.exitWriteAccess();
                    }
                }
            }
            ((BaseFileObj)((Object)object)).setValid(false);
            ((BaseFileObj)((Object)object)).fireFileDeletedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshImpl(boolean bl, boolean bl2) {
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        HashSet hashSet = null;
        Map map = null;
        privileged.enterWriteAccess();
        try {
            hashSet = new HashSet(childrenCache.getCachedChildren());
            map = childrenCache.refresh();
        }
        finally {
            privileged.exitWriteAccess();
        }
        hashSet.removeAll(map.keySet());
        for (Object object : hashSet) {
            BaseFileObj object2 = this.getFactory().getCachedOnly(((FileName)object).getFile());
            if (object2 == null || !object2.isData()) continue;
            ((FileObj)object2).refresh(bl);
        }
        FileObjectFactory fileObjectFactory = this.getFactory();
        for (Map.Entry entry : map.entrySet()) {
            FileName fileName = (FileName)entry.getKey();
            Integer n = (Integer)entry.getValue();
            BaseFileObj baseFileObj = n == ChildrenCache.ADDED_CHILD ? fileObjectFactory.getFileObject(new FileInfo(fileName.getFile()), FileObjectFactory.Caller.Others) : fileObjectFactory.getCachedOnly(fileName.getFile());
            BaseFileObj baseFileObj2 = baseFileObj = baseFileObj != null ? baseFileObj : this.getFileObject(fileName.getName());
            if (n == ChildrenCache.ADDED_CHILD && baseFileObj != null) {
                if (baseFileObj.isFolder()) {
                    if (!bl2) continue;
                    baseFileObj.fireFileFolderCreatedEvent(bl);
                    continue;
                }
                if (!bl2) continue;
                baseFileObj.fireFileDataCreatedEvent(bl);
                continue;
            }
            if (n != ChildrenCache.REMOVED_CHILD) continue;
            if (baseFileObj != null) {
                if (!baseFileObj.isValid()) continue;
                baseFileObj.setValid(false);
                if (!bl2) continue;
                baseFileObj.fireFileDeletedEvent(bl);
                continue;
            }
            File file = fileName.getFile();
            if (new FileInfo(file).isConvertibleToFileObject()) continue;
            BaseFileObj baseFileObj3 = fileName.isFile() ? new FileObj(file, fileName) : new FolderObj(file, fileName);
            baseFileObj3.setValid(false);
            if (!bl2) continue;
            baseFileObj3.fireFileDeletedEvent(bl);
        }
        boolean bl3 = FileChangedManager.getInstance().exists(this.getFileName().getFile());
        if (!bl3) {
            this.setValid(false);
            if (bl2) {
                this.fireFileDeletedEvent(bl);
            }
        }
    }

    public final void refresh(boolean bl) {
        this.refresh(bl, true);
    }

    private boolean deleteFile(File file, LinkedList linkedList, FileObjectFactory fileObjectFactory, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        BaseFileObj baseFileObj;
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (bl2) {
            BaseFileObj baseFileObj2 = fileObjectFactory.getCachedOnly(file);
            if (baseFileObj2 != null) {
                linkedList.addFirst(baseFileObj2);
            }
            return true;
        }
        if (!FileChangedManager.getInstance().exists(file)) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (this.deleteFile(file2, linkedList, fileObjectFactory, deleteHandler)) continue;
                return false;
            }
        }
        boolean bl4 = bl = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (bl && (baseFileObj = fileObjectFactory.getCachedOnly(file)) != null) {
            linkedList.addFirst(baseFileObj);
        }
        return true;
    }

    protected void setValid(boolean bl) {
        if (bl) {
            assert (this.isValid()) : this.toString();
        } else {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock fileLock) throws IOException {
        throw new IOException(this.getPath());
    }

    public final Date lastModified() {
        File file = this.getFileName().getFile();
        return new Date(file.lastModified());
    }

    public final FileLock lock() throws IOException {
        return new FileLock();
    }

    final boolean checkLock(FileLock fileLock) throws IOException {
        return true;
    }

    public final synchronized ChildrenCache getChildrenCache() {
        if (this.folderChildren == null) {
            this.folderChildren = new FolderChildrenCache();
        }
        return this.folderChildren;
    }

    public final class FolderChildrenCache
    implements ChildrenCache {
        public final ChildrenSupport ch = new ChildrenSupport();

        public final Set getChildren(boolean bl) {
            return this.ch.getChildren(FolderObj.this.getFileName(), bl);
        }

        public final FileNaming getChild(String string, boolean bl) {
            return this.ch.getChild(string, FolderObj.this.getFileName(), bl);
        }

        public final Map refresh() {
            return this.ch.refresh(FolderObj.this.getFileName());
        }

        public final Mutex.Privileged getMutexPrivileged() {
            return mp;
        }

        public final String toString() {
            return FolderObj.this.getFileName().toString();
        }

        public void removeChild(FileNaming fileNaming) {
            this.ch.removeChild(FolderObj.this.getFileName(), fileNaming);
        }

        public Set getCachedChildren() {
            return this.ch.getCachedChildren();
        }

        public boolean isCacheInitialized() {
            return this.ch.isCacheInitialized();
        }
    }
}

