/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

class TypesFilter {
    private Set<String> disabledProviders = new HashSet<String>();
    private int countLimit = 100;

    public TypesFilter() {
    }

    private TypesFilter(TypesFilter typesFilter) {
        this.countLimit = typesFilter.countLimit;
        this.disabledProviders.addAll(typesFilter.disabledProviders);
    }

    public boolean isEnabled(String string) {
        return !this.disabledProviders.contains(string);
    }

    public void setEnabled(String string, boolean bl) {
        if (!bl) {
            this.disabledProviders.add(string);
        } else {
            this.disabledProviders.remove(string);
        }
    }

    public boolean isTaskCountLimitReached(int n) {
        return n >= this.countLimit;
    }

    public void setTaskCountLimit(int n) {
        this.countLimit = n;
    }

    public int getTaskCountLimit() {
        return this.countLimit;
    }

    public TypesFilter clone() {
        return new TypesFilter(this);
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        this.countLimit = preferences.getInt(string + "_countLimit", 100);
        this.disabledProviders.clear();
        String string2 = preferences.get(string + "_disabled", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.disabledProviders.add(stringTokenizer.nextToken());
        }
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        preferences.putInt(string + "_countLimit", this.countLimit);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.disabledProviders.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        preferences.put(string + "_disabled", stringBuffer.toString());
    }
}

