/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.List;
import javax.swing.JLabel;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.spi.tasklist.Task;

class StatusBar
extends JLabel {
    private TaskList tasks;
    private TaskList.Listener listener;

    public StatusBar(TaskList taskList) {
        this.tasks = taskList;
        this.listener = new TaskList.Listener(){

            @Override
            public void tasksAdded(List<? extends Task> list) {
                StatusBar.this.updateText();
            }

            @Override
            public void tasksRemoved(List<? extends Task> list) {
                StatusBar.this.updateText();
            }

            @Override
            public void cleared() {
                StatusBar.this.updateText();
            }
        };
        this.updateText();
    }

    private void updateText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (TaskGroup taskGroup : TaskGroup.getGroups()) {
            int n = this.tasks.countTasks(taskGroup);
            if (n <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("  ");
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(taskGroup.getDisplayName());
            stringBuffer.append(": ");
            stringBuffer.append(n);
        }
        stringBuffer.append(' ');
        this.setText(stringBuffer.toString());
    }

    public void removeNotify() {
        super.removeNotify();
        this.tasks.removeListener(this.listener);
    }

    public void addNotify() {
        super.addNotify();
        this.tasks.addListener(this.listener);
    }
}

