/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class Helper {
    static final String NEWLINE = System.getProperty("line.separator");
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
    private static DateFormat xmlFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private Helper() {
    }

    static SVNUrl toSVNUrl(String url) {
        try {
            return new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static SVNRevision.Number toRevNum(String rev) {
        if (rev == null) {
            return null;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(rev));
        }
        catch (NumberFormatException e) {
            return new SVNRevision.Number(-1L);
        }
    }

    static Date toDate(String date) {
        if (date == null) {
            return null;
        }
        try {
            return df.parse(date);
        }
        catch (ParseException e1) {
            return null;
        }
    }

    static Date convertXMLDate(String date) {
        if (date == null) {
            return null;
        }
        try {
            return xmlFormat.parse(date);
        }
        catch (ParseException e1) {
            return null;
        }
    }

    static {
        xmlFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

