/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.cssengine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.apache.batik.css.parser.Parser;
import org.apache.batik.css.parser.Scanner;
import org.apache.batik.util.ParsedURL;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;

class RaveParser
extends Parser {
    protected Scanner createScanner(InputSource inputSource) {
        Reader reader;
        this.documentURI = inputSource.getURI();
        if (this.documentURI == null) {
            this.documentURI = "";
        }
        if ((reader = inputSource.getCharacterStream()) != null) {
            return new Scanner(reader);
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            return new Scanner(inputStream, inputSource.getEncoding());
        }
        String string = inputSource.getURI();
        if (string == null) {
            throw new CSSException(this.formatMessage("empty.source", null));
        }
        try {
            ParsedURL parsedURL = new ParsedURL(string);
            if ("file".equals(parsedURL.getProtocol())) {
                inputStream = RaveParser.getOpenCssStream(string);
            }
            if (inputStream == null) {
                inputStream = parsedURL.openStreamRaw("text/css");
            }
            return new Scanner(inputStream, inputSource.getEncoding());
        }
        catch (IOException iOException) {
            throw new CSSException((Exception)iOException);
        }
    }

    private static InputStream getOpenCssStream(String string) {
        block6: {
            try {
                FileObject fileObject;
                URI uRI = new URI(string);
                File file = new File(uRI);
                if (file == null || (fileObject = FileUtil.toFileObject((File)file)) == null) break block6;
                try {
                    StyledDocument styledDocument;
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie != null && (styledDocument = editorCookie.getDocument()) != null) {
                        String string2 = styledDocument.getText(0, styledDocument.getLength());
                        return new StringBufferInputStream(string2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
        }
        return null;
    }
}

