/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.IndexOffsetNode;
import org.openide.nodes.Node;

public class CsmFileModel {
    private List<IndexOffsetNode> lineNumberIndex = Collections.synchronizedList(new ArrayList());
    private List<CppDeclarationNode> list = Collections.synchronizedList(new ArrayList());
    private CsmFileFilter filter;
    private Action[] actions;

    public CsmFileModel(CsmFileFilter csmFileFilter, Action[] actionArray) {
        this.filter = csmFileFilter;
        this.actions = actionArray;
    }

    public void setFile(CsmFile csmFile) {
        this.buildModel(csmFile);
    }

    public Node[] getNodes() {
        return this.list.toArray(new Node[0]);
    }

    private void clear() {
        this.lineNumberIndex.clear();
        this.list.clear();
    }

    public CsmFileFilter getFilter() {
        return this.filter;
    }

    public void addOffset(Node node, CsmOffsetable csmOffsetable) {
        this.lineNumberIndex.add(new IndexOffsetNode(node, csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset()));
    }

    private void buildModel(CsmFile csmFile) {
        this.clear();
        if (csmFile != null && csmFile.isValid()) {
            CppDeclarationNode cppDeclarationNode;
            if (this.filter.isApplicableInclude()) {
                for (CsmInclude csmInclude : csmFile.getIncludes()) {
                    cppDeclarationNode = CppDeclarationNode.nodeFactory((CsmObject)csmInclude, this, false);
                    if (cppDeclarationNode == null) continue;
                    this.list.add(cppDeclarationNode);
                }
            }
            if (this.filter.isApplicableMacro()) {
                for (CsmInclude csmInclude : csmFile.getMacros()) {
                    cppDeclarationNode = CppDeclarationNode.nodeFactory((CsmObject)csmInclude, this, false);
                    if (cppDeclarationNode == null) continue;
                    this.list.add(cppDeclarationNode);
                }
            }
            for (CsmInclude csmInclude : csmFile.getDeclarations()) {
                if (!this.filter.isApplicable((CsmOffsetable)csmInclude) || (cppDeclarationNode = CppDeclarationNode.nodeFactory((CsmObject)csmInclude, this, false)) == null) continue;
                this.list.add(cppDeclarationNode);
            }
        }
        if (csmFile != null && csmFile.isValid()) {
            Collections.sort(this.list);
            Collections.sort(this.lineNumberIndex);
            this.resetScope();
        } else {
            this.list.clear();
            this.lineNumberIndex.clear();
        }
    }

    private void resetScope() {
        Stack<IndexOffsetNode> stack = new Stack<IndexOffsetNode>();
        for (IndexOffsetNode indexOffsetNode : this.lineNumberIndex) {
            while (!stack.empty()) {
                IndexOffsetNode indexOffsetNode2 = (IndexOffsetNode)stack.peek();
                if (indexOffsetNode.getStartOffset() >= indexOffsetNode2.getStartOffset() && indexOffsetNode.getEndOffset() <= indexOffsetNode2.getEndOffset()) {
                    indexOffsetNode.setScope(indexOffsetNode2);
                    break;
                }
                stack.pop();
            }
            stack.push(indexOffsetNode);
        }
    }

    public Node setSelection(long l) {
        int n = Collections.binarySearch(this.lineNumberIndex, new IndexOffsetNode(null, l, l));
        if (n < 0) {
            n = -n - 2;
        }
        if (n > -1 && n < this.lineNumberIndex.size()) {
            IndexOffsetNode indexOffsetNode = this.lineNumberIndex.get(n);
            if (indexOffsetNode.getStartOffset() <= l && indexOffsetNode.getEndOffset() >= l) {
                return indexOffsetNode.getNode();
            }
            for (IndexOffsetNode indexOffsetNode2 = indexOffsetNode.getScope(); indexOffsetNode2 != null; indexOffsetNode2 = indexOffsetNode2.getScope()) {
                indexOffsetNode = indexOffsetNode2;
                if (indexOffsetNode2.getStartOffset() > l || indexOffsetNode2.getEndOffset() < l) continue;
                return indexOffsetNode2.getNode();
            }
            return indexOffsetNode.getNode();
        }
        return null;
    }

    public Action[] getActions() {
        return this.actions;
    }
}

