/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.IfNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.ConvertIfToUnless;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertConditionals
implements AstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        ConvertToModifier convertToModifier;
        String string;
        BaseDocument baseDocument;
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        IfNode ifNode = (IfNode)node;
        if (ifNode.getCondition() == null) {
            return;
        }
        Node node2 = ifNode.getThenBody();
        Node node3 = ifNode.getElseBody();
        if (node2 != null && node3 != null) {
            return;
        }
        if (node2 == null && node3 == null) {
            return;
        }
        if (ifNode.getElseBody() != null && ifNode.getElseBody().nodeId == NodeType.IFNODE) {
            return;
        }
        int n = ifNode.getPosition().getStartOffset();
        if (node2 != null && (node2.nodeId == NodeType.BLOCKNODE || node2.getPosition().getStartOffset() <= n)) {
            return;
        }
        if (node3 != null && (node3.nodeId == NodeType.BLOCKNODE || node3.getPosition().getStartOffset() <= n)) {
            return;
        }
        try {
            baseDocument = (BaseDocument)compilationInfo.getDocument();
            int n2 = ConvertIfToUnless.findKeywordOffset(compilationInfo, ifNode);
            if (n2 == -1 || n2 > baseDocument.getLength() - 1) {
                return;
            }
            char c = baseDocument.getText(n2, 1).charAt(0);
            if (c != 'i' && c != 'u') {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        baseDocument = AstUtilities.getRange((Node)node);
        if (RubyUtils.isRhtmlFile((FileObject)compilationInfo.getFileObject())) {
            if ((baseDocument = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)baseDocument)) == OffsetRange.NONE) {
                return;
            }
            BaseDocument baseDocument2 = null;
            try {
                baseDocument2 = (BaseDocument)compilationInfo.getDocument();
                baseDocument2.readLock();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument2);
                string = tokenHierarchy.tokenSequence();
                string.move(baseDocument.getStart());
                if (!string.moveNext() && !string.movePrevious()) {
                    return;
                }
                if (string.offset() + string.token().length() < baseDocument.getEnd()) {
                    return;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (baseDocument2 != null) {
                    baseDocument2.readUnlock();
                }
            }
        }
        if ((convertToModifier = new ConvertToModifier(compilationInfo, ifNode)).getEditList() == null) {
            return;
        }
        List<Fix> list2 = Collections.singletonList(convertToModifier);
        string = NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionals");
        Description description = new Description(this, string, compilationInfo.getFileObject(), (OffsetRange)baseDocument, list2, 500);
        list.add(description);
    }

    @Override
    public String getId() {
        return "ConvertConditionals";
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionalsDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionals");
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private class ConvertToModifier
    implements PreviewableFix {
        private CompilationInfo info;
        private IfNode ifNode;

        public ConvertToModifier(CompilationInfo compilationInfo, IfNode ifNode) {
            this.info = compilationInfo;
            this.ifNode = ifNode;
        }

        public String getDescription() {
            return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionalsFix");
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() {
            try {
                boolean bl;
                BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
                Node node = this.ifNode.getThenBody();
                boolean bl2 = bl = node != null;
                if (node == null) {
                    node = this.ifNode.getElseBody();
                }
                OffsetRange offsetRange = AstUtilities.getRange((Node)node);
                if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)this.info, (OffsetRange)offsetRange)) == OffsetRange.NONE) {
                    return null;
                }
                String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength()).trim();
                if (string.endsWith(";")) {
                    string = string.substring(0, string.length() - 1);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(bl ? "if" : "unless");
                stringBuilder.append(" ");
                OffsetRange offsetRange2 = AstUtilities.getRange((Node)this.ifNode.getCondition());
                offsetRange2 = LexUtilities.getLexerOffsets((CompilationInfo)this.info, (OffsetRange)offsetRange2);
                if (offsetRange2 == OffsetRange.NONE) {
                    return null;
                }
                stringBuilder.append(baseDocument.getText(offsetRange2.getStart(), offsetRange2.getLength()));
                OffsetRange offsetRange3 = AstUtilities.getRange((Node)this.ifNode);
                offsetRange3 = LexUtilities.getLexerOffsets((CompilationInfo)this.info, (OffsetRange)offsetRange3);
                if (offsetRange3 == OffsetRange.NONE) {
                    return null;
                }
                return new EditList(baseDocument).replace(offsetRange3.getStart(), offsetRange3.getLength(), stringBuilder.toString(), false, 0);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

