/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsafeIdentifierChars
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        hashSet.add(NodeType.LOCALASGNNODE);
        hashSet.add(NodeType.DEFNNODE);
        hashSet.add(NodeType.DEFSNODE);
        hashSet.add(NodeType.CONSTDECLNODE);
        return hashSet;
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        String string = ((INameNode)node).getName();
        if (!RubyUtils.isSafeIdentifierName((String)string, (int)0)) {
            String string2 = NbBundle.getMessage(UnsafeIdentifierChars.class, (String)"InvalidMultibyte");
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            List<Fix> list2 = Collections.emptyList();
            if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
                Description description = new Description(this, string2, compilationInfo.getFileObject(), offsetRange, list2, 600);
                list.add(description);
            }
        }
    }

    @Override
    public String getId() {
        return "Unsafe_Identifier_Chars";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(UnsafeIdentifierChars.class, (String)"UnsafeIdentifierChars");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(UnsafeIdentifierChars.class, (String)"UnsafeIdentifierCharsDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }
}

