/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.Node;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntroduceKindFinder
implements ParseTreeVisitor {
    private boolean seenConstant;
    private boolean seenNonConstant;
    private boolean seenMethod;
    private boolean invalid;
    private boolean simple = true;

    IntroduceKindFinder() {
    }

    public boolean visit(Node node) {
        switch (node.nodeId) {
            case RETURNNODE: 
            case BREAKNODE: 
            case NEXTNODE: 
            case REDONODE: 
            case RETRYNODE: {
                this.invalid = true;
            }
            case NILNODE: 
            case FALSENODE: 
            case TRUENODE: 
            case ZARRAYNODE: 
            case ZEROARGNODE: 
            case ARRAYNODE: 
            case BIGNUMNODE: 
            case FIXNUMNODE: 
            case XSTRNODE: 
            case STRNODE: 
            case REGEXPNODE: 
            case FLOATNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DXSTRNODE: 
            case SYMBOLNODE: 
            case EVSTRNODE: {
                this.seenConstant = true;
                break;
            }
            case NEWLINENODE: {
                this.seenMethod = true;
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: 
            case MODULENODE: 
            case CLASSNODE: 
            case SCLASSNODE: 
            case ARGSCATNODE: 
            case ARGSNODE: 
            case ARGSPUSHNODE: {
                this.invalid = true;
                break;
            }
            case YIELDNODE: 
            case WHENNODE: 
            case WHILENODE: 
            case UNDEFNODE: 
            case UNTILNODE: 
            case RESCUEBODYNODE: 
            case RESCUENODE: 
            case ITERNODE: 
            case FORNODE: 
            case IFNODE: 
            case LOCALASGNNODE: 
            case DASGNNODE: 
            case CONSTDECLNODE: 
            case CLASSVARASGNNODE: 
            case ATTRASSIGNNODE: 
            case CLASSVARDECLNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: {
                this.seenMethod = true;
                break;
            }
            case ANDNODE: 
            case ORNODE: 
            case NOTNODE: 
            case HASHNODE: 
            case CALLNODE: {
                break;
            }
            case FCALLNODE: 
            case VCALLNODE: 
            case LOCALVARNODE: 
            case INSTVARNODE: 
            case DVARNODE: {
                this.simple = false;
                this.seenNonConstant = true;
            }
        }
        return this.invalid;
    }

    public boolean unvisit(Node node) {
        return this.invalid;
    }

    public List<IntroduceKind> getKinds() {
        if (this.invalid) {
            return null;
        }
        ArrayList<IntroduceKind> arrayList = new ArrayList<IntroduceKind>();
        if (this.seenMethod) {
            arrayList.add(IntroduceKind.CREATE_METHOD);
            return arrayList;
        }
        if (this.seenConstant) {
            if (!this.seenNonConstant) {
                arrayList.add(IntroduceKind.CREATE_CONSTANT);
            }
            arrayList.add(IntroduceKind.CREATE_FIELD);
            arrayList.add(IntroduceKind.CREATE_VARIABLE);
        } else if (!this.simple) {
            arrayList.add(IntroduceKind.CREATE_VARIABLE);
            arrayList.add(IntroduceKind.CREATE_FIELD);
        }
        return arrayList;
    }
}

