/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.KeepMarker;

public class ClassFileFinalizer
implements ClassFileVisitor,
MemberInfoVisitor {
    private ClassFileVisitor extraClassFileVisitor;
    private MemberInfoVisitor extraMemberInfoVisitor;
    private MemberFinder memberFinder = new MemberFinder();

    public ClassFileFinalizer() {
        this(null, null);
    }

    public ClassFileFinalizer(ClassFileVisitor classFileVisitor, MemberInfoVisitor memberInfoVisitor) {
        this.extraClassFileVisitor = classFileVisitor;
        this.extraMemberInfoVisitor = memberInfoVisitor;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if ((programClassFile.u2accessFlags & 0x610) == 0 && !KeepMarker.isKept(programClassFile) && programClassFile.subClasses == null) {
            programClassFile.u2accessFlags |= 0x10;
            if (this.extraClassFileVisitor != null) {
                this.extraClassFileVisitor.visitProgramClassFile(programClassFile);
            }
        }
        programClassFile.methodsAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string = programMethodInfo.getName(programClassFile);
        if (!((programMethodInfo.u2accessFlags & 0x41A) != 0 || string.equals("<init>") || (programClassFile.u2accessFlags & 0x10) == 0 && (KeepMarker.isKept(programMethodInfo) || programClassFile.subClasses != null && this.memberFinder.isOverriden(programClassFile, programMethodInfo)))) {
            programMethodInfo.u2accessFlags |= 0x10;
            if (this.extraMemberInfoVisitor != null) {
                this.extraMemberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
            }
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }
}

