/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.optimize.peephole.SingleImplementationMarker;

public class SingleImplementationFixer
implements ClassFileVisitor,
CpInfoVisitor {
    private ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        ClassFile classFile = SingleImplementationMarker.singleImplementation(programClassFile);
        if (classFile != null) {
            this.fixThisClassReference(programClassFile);
            this.fixInterfaceReference((ProgramClassFile)programClassFile.subClasses[0], programClassFile);
        }
        programClassFile.constantPoolEntriesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        ClassFile classFile2 = SingleImplementationMarker.singleImplementation(fieldrefCpInfo.referencedClassFile);
        if (classFile2 != null) {
            this.fixFieldrefClassReference((ProgramClassFile)classFile, fieldrefCpInfo);
        }
    }

    private void fixThisClassReference(ProgramClassFile programClassFile) {
        int n = this.constantPoolEditor.addUtf8CpInfo(programClassFile, programClassFile.getName());
        programClassFile.u2thisClass = this.constantPoolEditor.addCpInfo(programClassFile, new ClassCpInfo(n, programClassFile));
    }

    private void fixInterfaceReference(ProgramClassFile programClassFile, ProgramClassFile programClassFile2) {
        String string = programClassFile2.getName();
        int n = programClassFile.u2interfacesCount;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(programClassFile.getInterfaceName(i))) continue;
            int n2 = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string);
            programClassFile.u2interfaces[i] = this.constantPoolEditor.addCpInfo(programClassFile, new ClassCpInfo(n2, programClassFile2));
            break;
        }
    }

    private void fixFieldrefClassReference(ProgramClassFile programClassFile, FieldrefCpInfo fieldrefCpInfo) {
        ClassFile classFile = fieldrefCpInfo.referencedClassFile;
        int n = this.constantPoolEditor.addUtf8CpInfo(programClassFile, fieldrefCpInfo.getClassName(programClassFile));
        fieldrefCpInfo.u2classIndex = this.constantPoolEditor.addCpInfo(programClassFile, new ClassCpInfo(n, classFile));
    }
}

