/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.visualweb.propertyeditors.IllegalTextArgumentException;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;

public abstract class NumberPropertyEditor
extends PropertyEditorBase {
    static ResourceBundle bundle = ResourceBundle.getBundle(NumberPropertyEditor.class.getPackage().getName() + ".Bundle");
    public static final String MIN_VALUE = "com.sun.rave.propertyeditors.MIN_VALUE";
    public static final String MAX_VALUE = "com.sun.rave.propertyeditors.MAX_VALUE";
    String unsetText;
    Object value;
    Class propertyType;
    Number minValue;
    Number maxValue;
    private Number defaultMinValue;
    private Number defaultMaxValue;

    NumberPropertyEditor(Number number, Number number2) {
        this.minValue = number;
        this.maxValue = number2;
        this.defaultMinValue = number;
        this.defaultMaxValue = number2;
        this.value = null;
    }

    protected abstract Number parseString(String var1) throws IllegalTextArgumentException;

    public void setDesignProperty(DesignProperty designProperty) {
        super.setDesignProperty(designProperty);
        PropertyDescriptor propertyDescriptor = designProperty.getPropertyDescriptor();
        Number number = null;
        Object object = propertyDescriptor.getValue(MIN_VALUE);
        if (object instanceof String) {
            try {
                number = this.parseString((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                number = null;
            }
        } else if (object instanceof Number) {
            number = (Number)object;
        }
        if (number != null && ((Comparable)((Object)number)).compareTo(this.defaultMinValue) >= 0) {
            this.minValue = number;
        }
        number = null;
        object = propertyDescriptor.getValue(MAX_VALUE);
        if (object instanceof String) {
            try {
                number = this.parseString((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                number = null;
            }
        } else if (object instanceof Number) {
            number = (Number)object;
        }
        if (number != null && ((Comparable)((Object)number)).compareTo(this.defaultMaxValue) <= 0) {
            this.maxValue = number;
        }
        this.propertyType = designProperty.getPropertyDescriptor().getPropertyType();
    }

    public void setValue(Object object) {
        if (object == null) {
            this.value = null;
        } else if (String.class.isAssignableFrom(object.getClass())) {
            this.setAsText((String)object);
        } else if (Number.class.isAssignableFrom(object.getClass())) {
            this.value = (Number)object;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(this.propertyType)) {
            return this.value.toString();
        }
        return this.value;
    }

    public String getAsText() {
        Comparable comparable;
        if (this.value == null) {
            return "";
        }
        if (this.value.equals(this.unsetValue) && this.value instanceof Comparable && ((comparable = (Comparable)this.value).compareTo(this.minValue) <= 0 || comparable.compareTo(this.maxValue) >= 0)) {
            return "";
        }
        return this.value.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        String string2 = string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            this.value = this.unsetValue;
        } else {
            Number number = this.parseString(string);
            if (((Comparable)((Object)number)).compareTo(this.minValue) >= 0 && ((Comparable)((Object)number)).compareTo(this.maxValue) <= 0) {
                this.value = number;
            } else {
                String string3 = null;
                int n = ((Comparable)((Object)this.maxValue)).compareTo(this.defaultMaxValue);
                int n2 = ((Comparable)((Object)this.minValue)).compareTo(this.defaultMinValue);
                if (n > 0 && n2 < 0) {
                    string3 = MessageFormat.format(bundle.getString("NumberPropertyEditor.rangeErrorMessage"), this.minValue, this.maxValue);
                } else if (n < 0) {
                    string3 = MessageFormat.format(bundle.getString("NumberPropertyEditor.rangeMaxErrorMessage"), this.maxValue);
                } else if (n2 > 0) {
                    string3 = MessageFormat.format(bundle.getString("NumberPropertyEditor.rangeMinErrorMessage"), this.minValue);
                }
                throw new IllegalTextArgumentException(string3);
            }
        }
    }
}

