/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.domains.Domain;
import com.sun.rave.propertyeditors.domains.EditableDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.awt.Component;
import org.netbeans.modules.visualweb.propertyeditors.DomainPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.SelectOneDomainPanel;

public class SelectOneDomainEditor
extends DomainPropertyEditor {
    static final long FETCH_TIME_LIMIT = 2500L;
    static final int MAX_DOMAIN_SIZE = 8;
    Element element;
    private long elementsFetchTime;
    private Element[] elements;
    private String[] elementLabels;

    public SelectOneDomainEditor() {
    }

    public SelectOneDomainEditor(Domain domain) {
        super(domain);
    }

    public Object getValue() {
        return this.element == null ? null : this.element.getValue();
    }

    public void setValue(Object object) {
        Domain domain = this.getDomain();
        if (domain == null) {
            return;
        }
        Element[] elementArray = this.getElements();
        Element element = null;
        for (int i = 0; i < elementArray.length && element == null; ++i) {
            Object object2 = elementArray[i].getValue();
            if (object != object2 && (object2 == null || !object2.equals(object))) continue;
            element = elementArray[i];
        }
        this.element = element == null ? this.defaultElement : element;
    }

    public String getAsText() {
        if (this.element == null) {
            this.element = this.defaultElement;
        }
        return this.element.getLabel();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Domain domain = this.getDomain();
        if (domain == null) {
            return;
        }
        if (string == null || string.trim().length() == 0) {
            this.element = this.defaultElement;
        } else {
            Element[] elementArray = this.getElements();
            Element element = null;
            for (int i = 0; i < elementArray.length && element == null; ++i) {
                if (!elementArray[i].getLabel().equals(string)) continue;
                element = elementArray[i];
            }
            if (element != null) {
                this.element = element;
            }
        }
    }

    public String[] getTags() {
        Domain domain = this.getDomain();
        if (domain == null) {
            return new String[0];
        }
        if (domain instanceof EditableDomain) {
            ((EditableDomain)domain).setDesignProperty(this.getDesignProperty());
        }
        if (domain.getSize() > 8) {
            return null;
        }
        return this.getElementLabels();
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object object;
        Domain domain = this.getDomain();
        if (domain instanceof EditableDomain) {
            object = (EditableDomain)domain;
            object.setDesignProperty(this.getDesignProperty());
        }
        object = new SelectOneDomainPanel(this);
        return object;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void setDesignProperty(DesignProperty designProperty) {
        super.setDesignProperty(designProperty);
        if (this.getDomain() != null && this.getValue() == null) {
            this.setValue(null);
        }
    }

    public String getJavaInitializationString() {
        return this.element.getJavaInitializationString();
    }

    private Element[] getElements() {
        if (this.elements == null || System.currentTimeMillis() - this.elementsFetchTime > 2500L) {
            this.elements = this.domain.getElements();
            this.elementsFetchTime = System.currentTimeMillis();
        }
        return this.elements;
    }

    private String[] getElementLabels() {
        if (this.elementLabels == null || System.currentTimeMillis() - this.elementsFetchTime > 2500L) {
            this.elements = this.getElements();
            int n = 0;
            int n2 = 0;
            if (this.domain.isRequired()) {
                this.elementLabels = new String[this.elements.length];
            } else {
                this.elementLabels = new String[this.elements.length + 1];
                int n3 = n++;
                this.elementLabels[n3] = EMPTY_ELEMENT.getLabel();
            }
            while (n2 < this.elements.length) {
                this.elementLabels[n++] = this.elements[n2++].getLabel();
            }
        }
        return this.elementLabels;
    }
}

