/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.propertyeditors.util.JavaInitializer;
import java.awt.Component;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;
import org.netbeans.modules.visualweb.propertyeditors.StringPropertyPanel;

public class StringPropertyEditor
extends PropertyEditorBase
implements com.sun.rave.propertyeditors.StringPropertyEditor {
    public StringPropertyEditor() {
        super.setValue("");
    }

    public void setValue(Object object) {
        super.setValue(object == null ? "" : object.toString());
    }

    public Object getValue() {
        String string = (String)super.getValue();
        if (string.trim().length() == 0) {
            return null;
        }
        return string;
    }

    public String getJavaInitializationString() {
        return JavaInitializer.toJavaInitializationString((String)((String)this.getValue()));
    }

    public Component getCustomEditor() {
        return new StringPropertyPanel(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            this.setValue(null);
        }
        this.setValue(StringPropertyEditor.unescapeString(string));
    }

    public String getAsText() {
        String string = (String)this.getValue();
        if (string == null) {
            return "";
        }
        return StringPropertyEditor.escapeString(string);
    }

    static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (cArray[i] == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (cArray[i] == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() == string.length()) {
            return string;
        }
        return stringBuffer.toString();
    }

    static String unescapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\' && i < cArray.length - 1) {
                if (cArray[++i] == '\\') {
                    stringBuffer.append("\\");
                    continue;
                }
                if (cArray[i] == 't') {
                    stringBuffer.append("\t");
                    continue;
                }
                if (cArray[i] != 'n') continue;
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() == string.length()) {
            return string;
        }
        return stringBuffer.toString();
    }
}

