/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.binding;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesBindingPropertyEditor;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.faces.application.Application;
import javax.faces.el.ValueBinding;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetCallback;
import org.netbeans.modules.visualweb.propertyeditors.binding.data.DataBindingHelper;
import org.netbeans.modules.visualweb.propertyeditors.binding.data.TabbedDataBindingPanel;
import org.netbeans.modules.visualweb.propertyeditors.util.Bundle;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class ValueBindingPropertyEditor
implements PropertyEditor,
ExPropertyEditor,
FacesBindingPropertyEditor,
BindingTargetCallback,
com.sun.rave.propertyeditors.binding.ValueBindingPropertyEditor {
    public static final String BINDING_PANEL_CLASS_NAMES = "bindingPanelClassNames";
    private static final Bundle bundle = Bundle.getBundle(ValueBindingPropertyEditor.class);
    protected PropertyEditor delegatePropertyEditor;
    private Object value;
    protected Component customEditor;
    private Vector listeners;
    private boolean useDelegatePropertyEditor;
    protected DesignProperty designProperty;
    protected FacesDesignProperty facesDesignProperty;
    private static final ImageIcon BOUND_ICON = new ImageIcon(ValueBindingPropertyEditor.class.getResource("img/bound.png"));

    public ValueBindingPropertyEditor() {
        this(null);
    }

    public ValueBindingPropertyEditor(PropertyEditor propertyEditor) {
        this.delegatePropertyEditor = propertyEditor;
    }

    protected boolean isPropertyBound() {
        return this.facesDesignProperty != null && this.facesDesignProperty.isBound();
    }

    protected boolean isValueBindingValue() {
        return this.value instanceof ValueBinding;
    }

    protected Object getValueBindingValue() {
        if (this.isValueBindingValue()) {
            FacesDesignContext facesDesignContext = (FacesDesignContext)this.facesDesignProperty.getDesignBean().getDesignContext();
            ValueBinding valueBinding = (ValueBinding)this.value;
            return valueBinding.getValue(facesDesignContext.getFacesContext());
        }
        return null;
    }

    protected boolean isUseDelegatePropertyEditor() {
        return this.useDelegatePropertyEditor;
    }

    protected void setUseDelegatePropertyEditor(boolean bl) {
        if (this.delegatePropertyEditor == null) {
            this.useDelegatePropertyEditor = false;
        } else {
            if (this.useDelegatePropertyEditor == bl) {
                return;
            }
            this.useDelegatePropertyEditor = bl;
        }
    }

    protected void setValueInternal(Object object) {
        this.value = object;
    }

    protected Object getValueInternal() {
        return this.value;
    }

    public void setDesignProperty(DesignProperty designProperty) {
        this.designProperty = designProperty;
        this.facesDesignProperty = designProperty instanceof FacesDesignProperty ? (FacesDesignProperty)designProperty : null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.setValue(this.designProperty.getValue());
        if (this.delegatePropertyEditor == null) {
            this.customEditor = new TabbedDataBindingPanelAdapter(this, this.designProperty, (Class[])this.designProperty.getPropertyDescriptor().getValue(BINDING_PANEL_CLASS_NAMES), true);
        } else {
            Component component = null;
            if (this.delegatePropertyEditor.supportsCustomEditor()) {
                component = this.delegatePropertyEditor.getCustomEditor();
            }
            this.customEditor = new TabbedDataBindingPanelWrapper(this, this.designProperty, (Class[])this.designProperty.getPropertyDescriptor().getValue(BINDING_PANEL_CLASS_NAMES), true, component);
        }
        return this.customEditor;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void firePropertyChange() {
        Vector vector;
        Object object = this;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        object = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < vector.size(); ++i) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(i);
            propertyChangeListener.propertyChange((PropertyChangeEvent)object);
        }
    }

    public Object getValue() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            this.setValueInternal(this.delegatePropertyEditor.getValue());
            this.setUseDelegatePropertyEditor(!this.isValueBindingValue());
        }
        return this.getValueInternal();
    }

    public void setValue(Object object) {
        if (this.isPropertyBound()) {
            ValueBinding valueBinding = this.facesDesignProperty.getValueBinding();
            this.setValueInternal(valueBinding);
            this.setUseDelegatePropertyEditor(false);
        } else {
            this.setValueInternal(object);
            this.setUseDelegatePropertyEditor(true);
        }
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.setValue(object);
        }
    }

    public String getJavaInitializationString() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getJavaInitializationString();
        }
        if (this.isValueBindingValue()) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setValue(this.getValueBindingValue());
                return this.delegatePropertyEditor.getJavaInitializationString();
            }
        } else if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.setValue(this.getValueInternal());
            return this.delegatePropertyEditor.getJavaInitializationString();
        }
        return "";
    }

    public String getAsText() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getAsText();
        }
        if (this.isValueBindingValue()) {
            return ((ValueBinding)this.getValueInternal()).getExpressionString();
        }
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.setValue(this.getValueInternal());
            return this.delegatePropertyEditor.getAsText();
        }
        if (this.getValueInternal() == null) {
            return "";
        }
        return String.valueOf(this.getValueInternal());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.isUseDelegatePropertyEditor()) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setAsText(string);
            }
        } else if ((string = string.trim()).startsWith("#{") && string.endsWith("}")) {
            FacesDesignContext facesDesignContext = (FacesDesignContext)this.designProperty.getDesignBean().getDesignContext();
            Application application = facesDesignContext.getFacesContext().getApplication();
            this.setValueInternal(application.createValueBinding(string));
        } else if (string.length() > 0) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setAsText(string);
                this.setValueInternal(this.delegatePropertyEditor.getValue());
            }
        } else {
            this.setValueInternal(this.facesDesignProperty.getUnsetValue());
        }
    }

    public String[] getTags() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getTags();
        }
        if (this.isValueBindingValue()) {
            return null;
        }
        if (this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getTags();
        }
        return null;
    }

    public boolean isPaintable() {
        Class<?> clazz;
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.isPaintable();
        }
        return this.isValueBindingValue() && ((clazz = this.designProperty.getPropertyDescriptor().getPropertyType()) == Boolean.class || clazz == Boolean.TYPE);
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Class<?> clazz;
        if (!this.isPaintable()) {
            return;
        }
        if (this.isUseDelegatePropertyEditor()) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.paintValue(graphics, rectangle);
            }
            return;
        }
        if (this.isValueBindingValue() && ((clazz = this.designProperty.getPropertyDescriptor().getPropertyType()) == Boolean.class || clazz == Boolean.TYPE)) {
            JLabel jLabel = new JLabel(BOUND_ICON, 2);
            String string = this.getAsText();
            jLabel.setText(string == null ? "" : string);
            jLabel.setBounds(rectangle);
            jLabel.setForeground(graphics.getColor());
            jLabel.paint(graphics);
        }
    }

    public void refresh() {
    }

    public void setNewExpressionText(String string) {
        if (string.startsWith("#{") && string.endsWith("}")) {
            FacesDesignContext facesDesignContext = (FacesDesignContext)this.designProperty.getDesignBean().getDesignContext();
            Application application = facesDesignContext.getFacesContext().getApplication();
            this.setValueInternal(application.createValueBinding(string));
            this.setUseDelegatePropertyEditor(false);
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setValue(this.getValueBindingValue());
            }
        } else {
            this.setValueInternal(this.facesDesignProperty.getUnsetValue());
            this.setUseDelegatePropertyEditor(true);
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setValue(this.facesDesignProperty.getUnsetValue());
            }
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        if (this.delegatePropertyEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.delegatePropertyEditor).attachEnv(propertyEnv);
        }
    }

    private class TabbedDataBindingPanelWrapper
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        private JRadioButton useValueButton;
        private JRadioButton useBindingButton;
        private ButtonGroup useValueUseBindingGroup;
        private static final String BINDING_CARD = "bindingCard";
        private static final String VALUE_CARD = "valueCard";
        private CardLayout cardLayout;
        private JPanel cardPanel;
        private TabbedDataBindingPanel tabbedDataBindingPanel;
        private Component delegateCustomEditorComponent;

        public TabbedDataBindingPanelWrapper(BindingTargetCallback bindingTargetCallback, DesignProperty designProperty, Class[] classArray, boolean bl, Component component) {
            this.delegateCustomEditorComponent = component;
            this.setLayout(new GridBagLayout());
            this.useValueUseBindingGroup = new ButtonGroup();
            this.useBindingButton = new JRadioButton(bundle.getMessage("LBL_UseBindingRadionButton"));
            this.useBindingButton.setMnemonic(bundle.getMessage("LBL_UseBindingRadionButton_Mnemonic").charAt(0));
            this.useBindingButton.getAccessibleContext().setAccessibleName(bundle.getMessage("LBL_UseBindingRadionButton"));
            this.useBindingButton.getAccessibleContext().setAccessibleDescription(bundle.getMessage("LBL_UseBindingRadionButton_A11YDescription"));
            this.useValueUseBindingGroup.add(this.useBindingButton);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.useBindingButton, gridBagConstraints);
            this.useValueButton = new JRadioButton(bundle.getMessage("LBL_UseValueRadionButton"));
            this.useValueButton.setMnemonic(bundle.getMessage("LBL_UseValueRadionButton_Mnemonic").charAt(0));
            this.useValueButton.getAccessibleContext().setAccessibleName(bundle.getMessage("LBL_UseValueRadionButton"));
            this.useValueButton.getAccessibleContext().setAccessibleDescription(bundle.getMessage("LBL_UseValueRadionButton_A11YDescription"));
            this.useValueUseBindingGroup.add(this.useValueButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 0, 11);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.useValueButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 12, 0, 11);
            this.add((Component)new JSeparator(), gridBagConstraints);
            this.cardLayout = new CardLayout();
            this.cardPanel = new JPanel(this.cardLayout);
            if (classArray == null || classArray.length == 1) {
                classArray = new Class[]{DataBindingHelper.BIND_VALUE_TO_DATAPROVIDER, DataBindingHelper.BIND_VALUE_TO_OBJECT};
            }
            this.tabbedDataBindingPanel = new TabbedDataBindingPanel(bindingTargetCallback, designProperty, classArray, bl);
            this.cardPanel.add((Component)this.tabbedDataBindingPanel, BINDING_CARD);
            if (component == null) {
                JTextArea jTextArea = new JTextArea(bundle.getMessage("MSG_EditValueInPropertySheet"));
                jTextArea.setEditable(false);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setBorder(null);
                jTextArea.setBackground(UIManager.getColor("Label.background"));
                jTextArea.getAccessibleContext().setAccessibleName(bundle.getMessage("MSG_EditValueInPropertySheet"));
                jTextArea.getAccessibleContext().setAccessibleDescription(bundle.getMessage("MSG_EditValueInPropertySheet"));
                this.cardPanel.add((Component)jTextArea, VALUE_CARD);
            } else {
                this.cardPanel.add(component, VALUE_CARD);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 12, 11);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.cardPanel, gridBagConstraints);
            if (ValueBindingPropertyEditor.this.isPropertyBound()) {
                this.useBindingButton.setSelected(true);
                this.cardLayout.show(this.cardPanel, BINDING_CARD);
            } else {
                this.useValueButton.setSelected(true);
                this.cardLayout.show(this.cardPanel, VALUE_CARD);
            }
            this.useBindingButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TabbedDataBindingPanelWrapper.this.adjustUseValueUseBinding();
                }
            });
            this.useValueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TabbedDataBindingPanelWrapper.this.adjustUseValueUseBinding();
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.cardPanel.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TabbedDataBindingPanelWrapper.this.cardPanel.transferFocus();
                }
            });
        }

        void adjustUseValueUseBinding() {
            if (this.useBindingButton.isSelected()) {
                ValueBindingPropertyEditor.this.setUseDelegatePropertyEditor(false);
                this.showBindingCard();
            } else if (this.useValueButton.isSelected()) {
                ValueBindingPropertyEditor.this.setUseDelegatePropertyEditor(true);
                this.showValueCard();
            }
        }

        void showBindingCard() {
            this.cardLayout.show(this.cardPanel, BINDING_CARD);
        }

        void showValueCard() {
            this.cardLayout.show(this.cardPanel, VALUE_CARD);
        }

        public Object getPropertyValue() throws IllegalStateException {
            if (ValueBindingPropertyEditor.this.isUseDelegatePropertyEditor() && this.delegateCustomEditorComponent instanceof EnhancedCustomPropertyEditor) {
                Object object = ((EnhancedCustomPropertyEditor)this.delegateCustomEditorComponent).getPropertyValue();
                ValueBindingPropertyEditor.this.setValueInternal(object);
                ValueBindingPropertyEditor.this.setUseDelegatePropertyEditor(!ValueBindingPropertyEditor.this.isValueBindingValue());
                return ValueBindingPropertyEditor.this.getValueInternal();
            }
            return ValueBindingPropertyEditor.this.getValue();
        }
    }

    private class TabbedDataBindingPanelAdapter
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        private TabbedDataBindingPanel tabbedDataBindingPanel;

        public TabbedDataBindingPanelAdapter(BindingTargetCallback bindingTargetCallback, DesignProperty designProperty, Class[] classArray, boolean bl) {
            this.setLayout(new BorderLayout(8, 8));
            this.tabbedDataBindingPanel = new TabbedDataBindingPanel(bindingTargetCallback, designProperty, classArray, bl);
            this.add((Component)this.tabbedDataBindingPanel, "Center");
        }

        public Object getPropertyValue() throws IllegalStateException {
            return ValueBindingPropertyEditor.this.getValue();
        }
    }
}

