/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.binding.nodes;

import com.sun.rave.designtime.DesignBean;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import javax.faces.model.SelectItem;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetNode;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetNodeFactory;
import org.netbeans.modules.visualweb.propertyeditors.binding.PropertyBindingHelper;
import org.netbeans.modules.visualweb.propertyeditors.binding.nodes.PropertyTargetNode;
import org.netbeans.modules.visualweb.propertyeditors.util.Bundle;
import org.openide.ErrorManager;

public class ResultSetTargetNodeFactory
implements BindingTargetNodeFactory {
    private static final Bundle bundle = Bundle.getBundle(ResultSetTargetNodeFactory.class);

    public boolean supportsTargetClass(Class clazz) {
        return ResultSet.class.isAssignableFrom(clazz);
    }

    public BindingTargetNode createTargetNode(BindingTargetNode bindingTargetNode, DesignBean designBean, PropertyDescriptor[] propertyDescriptorArray, Object object) {
        return new ResultSetTargetNode(bindingTargetNode, designBean, propertyDescriptorArray, object);
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -6: {
                return "TINYINT";
            }
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 8: {
                return "DOUBLE";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case -2: {
                return "BINARY";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2006: {
                return "REF";
            }
            case 2002: {
                return "STRUCT";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -3: {
                return "VARBINARY";
            }
        }
        return null;
    }

    public static Class getJavaType(int n) {
        switch (n) {
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -6: {
                return Byte.class;
            }
            case -5: {
                return Long.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case 91: 
            case 92: {
                return Timestamp.class;
            }
            case 2: 
            case 3: {
                return Number.class;
            }
            case 7: 
            case 8: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 70: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2004: 
            case 2005: 
            case 2006: {
                return null;
            }
        }
        return null;
    }

    public class ComboDisplayColumnRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ComboDisplayColumn) {
                ComboDisplayColumn comboDisplayColumn = (ComboDisplayColumn)object;
                String string = ResultSetTargetNodeFactory.getTypeName(comboDisplayColumn.columnType);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><b>");
                stringBuffer.append(comboDisplayColumn.columnName);
                stringBuffer.append("</b> &nbsp; <font size=\"-1\"><i>");
                stringBuffer.append(string);
                stringBuffer.append("</i></font></html>");
                this.setText(stringBuffer.toString());
            } else {
                this.setText(bundle.getMessage("noneBrackets"));
            }
            return this;
        }
    }

    public class ComboDisplayColumn {
        public String columnName;
        public int columnType;

        public ComboDisplayColumn(String string, int n) {
            this.columnName = string;
            this.columnType = n;
        }
    }

    public class ResultSetTargetNode
    extends PropertyTargetNode {
        protected ResultSet resultSet;

        public ResultSetTargetNode(BindingTargetNode bindingTargetNode, DesignBean designBean, PropertyDescriptor[] propertyDescriptorArray, Object object) {
            super(bindingTargetNode, designBean, propertyDescriptorArray, object);
            if (object == null) {
                object = PropertyBindingHelper.getPropInstance(designBean, propertyDescriptorArray);
            }
            if (object instanceof ResultSet) {
                this.resultSet = (ResultSet)object;
            }
        }

        public void lazyLoadCustomTargetNodes() {
            if (this.resultSet != null) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            final ResultSetMetaData resultSetMetaData = ResultSetTargetNode.this.resultSet.getMetaData();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    try {
                                        int n = resultSetMetaData.getColumnCount();
                                        if (n > 0) {
                                            for (int i = 0; i < n; ++i) {
                                                ResultSetTargetNode.super.add(new ColumnNode(ResultSetTargetNode.this, resultSetMetaData.getColumnName(i + 1), resultSetMetaData.getColumnType(i + 1)));
                                            }
                                        }
                                        ResultSetTargetNode.super.add(new SelectItemsNode(ResultSetTargetNode.this, resultSetMetaData));
                                    }
                                    catch (Exception exception) {
                                        ErrorManager.getDefault().notify((Throwable)exception);
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        }

        public class SelectItemsNode
        extends BindingTargetNode {
            protected ResultSetMetaData metaData;
            protected String displayTextEnabled;
            protected String displayTextDisabled;
            JPanel pickerPanel;
            JLabel valueLabel;
            JLabel labelLabel;
            JLabel descrLabel;
            JComboBox valueCombo;
            JComboBox labelCombo;
            JComboBox descrCombo;
            ActionListener updateCallback;
            ActionListener updateAdapter;

            public SelectItemsNode(BindingTargetNode bindingTargetNode, ResultSetMetaData resultSetMetaData) {
                super(bindingTargetNode);
                this.displayTextEnabled = null;
                this.displayTextDisabled = null;
                this.pickerPanel = new JPanel();
                this.valueLabel = new JLabel(bundle.getMessage("valueField"));
                this.labelLabel = new JLabel(bundle.getMessage("displayField"));
                this.descrLabel = new JLabel(bundle.getMessage("tooltipField"));
                this.valueCombo = new JComboBox();
                this.labelCombo = new JComboBox();
                this.descrCombo = new JComboBox();
                this.updateCallback = null;
                this.updateAdapter = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SelectItemsNode.this.updateCallback != null) {
                            SelectItemsNode.this.updateCallback.actionPerformed(actionEvent);
                        }
                    }
                };
                this.metaData = resultSetMetaData;
                this.initCustomPanel();
                this.displayTextEnabled = this.getDisplayText(true);
                this.displayTextDisabled = this.getDisplayText(false);
            }

            public String getDisplayText(boolean bl) {
                if (bl && this.displayTextEnabled != null) {
                    return this.displayTextEnabled;
                }
                if (!bl && this.displayTextDisabled != null) {
                    return this.displayTextDisabled;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                if (!bl) {
                    stringBuffer.append("<font color=\"gray\">");
                }
                if (bl) {
                    stringBuffer.append("<b>");
                }
                stringBuffer.append(bundle.getMessage("selectItems"));
                if (bl) {
                    stringBuffer.append("</b>");
                }
                stringBuffer.append(" &nbsp; <font size=\"-1\"><i>");
                stringBuffer.append(bundle.getMessage("parenItemsForListBoxOr"));
                stringBuffer.append("</i></font>");
                if (!bl) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("</html>");
                return stringBuffer.toString();
            }

            public int getChildCount() {
                return 0;
            }

            public boolean lazyLoad() {
                return true;
            }

            public Class getTargetTypeClass() {
                return SelectItem[].class;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "selectItems['" + this.getColumnPicks() + "']";
            }

            String getColumnPicks() {
                StringBuffer stringBuffer = new StringBuffer();
                Object object = this.valueCombo.getSelectedItem();
                if (object instanceof ComboDisplayColumn) {
                    stringBuffer.append(((ComboDisplayColumn)object).columnName);
                }
                if ((object = this.labelCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    stringBuffer.append(",");
                    stringBuffer.append(((ComboDisplayColumn)object).columnName);
                }
                if ((object = this.descrCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    stringBuffer.append(",");
                    stringBuffer.append(((ComboDisplayColumn)object).columnName);
                }
                return stringBuffer.toString();
            }

            void initCustomPanel() {
                ComboDisplayColumnRenderer comboDisplayColumnRenderer = new ComboDisplayColumnRenderer();
                this.valueCombo.setRenderer(comboDisplayColumnRenderer);
                this.labelCombo.setRenderer(comboDisplayColumnRenderer);
                this.descrCombo.setRenderer(comboDisplayColumnRenderer);
                this.labelCombo.addItem(bundle.getMessage("noneBrackets"));
                this.descrCombo.addItem(bundle.getMessage("noneBrackets"));
                try {
                    int n = this.metaData.getColumnCount();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            ComboDisplayColumn comboDisplayColumn = new ComboDisplayColumn(this.metaData.getColumnName(i + 1), this.metaData.getColumnType(i + 1));
                            this.valueCombo.addItem(comboDisplayColumn);
                            this.labelCombo.addItem(comboDisplayColumn);
                            this.descrCombo.addItem(comboDisplayColumn);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.pickerPanel.setLayout(new GridBagLayout());
                this.pickerPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
                this.pickerPanel.add((Component)this.valueCombo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.valueCombo.addActionListener(this.updateAdapter);
                this.labelCombo.addActionListener(this.updateAdapter);
                this.descrCombo.addActionListener(this.updateAdapter);
            }

            public JComponent getCustomDisplayPanel(ActionListener actionListener) {
                this.updateCallback = actionListener;
                return this.pickerPanel;
            }
        }

        public class ColumnNode
        extends BindingTargetNode {
            protected String columnName;
            protected int columnType;

            public ColumnNode(BindingTargetNode bindingTargetNode, String string, int n) {
                super(bindingTargetNode);
                this.columnName = string;
                this.columnType = n;
            }

            public int getChildCount() {
                return 0;
            }

            public boolean lazyLoad() {
                return true;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "currentRow['" + this.columnName + "']";
            }

            public Class getTargetTypeClass() {
                return ResultSetTargetNodeFactory.getJavaType(this.columnType);
            }

            public String getDisplayText(boolean bl) {
                String string = ResultSetTargetNodeFactory.getTypeName(this.columnType);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                if (!bl) {
                    stringBuffer.append("<font color=\"gray\">");
                }
                stringBuffer.append(bundle.getMessage("column"));
                stringBuffer.append(" ");
                if (bl) {
                    stringBuffer.append("<b>");
                }
                stringBuffer.append(this.columnName);
                if (bl) {
                    stringBuffer.append("</b>");
                }
                stringBuffer.append(" &nbsp; <font size=\"-1\"><i>");
                stringBuffer.append(string);
                stringBuffer.append("</i></font>");
                if (!bl) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("</html>");
                return stringBuffer.toString();
            }
        }
    }
}

