/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import com.sun.rave.designtime.DesignProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.visualweb.propertyeditors.css.BackgroundImageUrlDialog;
import org.netbeans.modules.visualweb.propertyeditors.css.ColorSelectionField;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleBuilderDialog;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.model.BackgroundModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.BackgroundPositionData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.PropertyData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.Utils;
import org.openide.util.NbBundle;

public class BackgroundStyleEditor
extends StyleEditor
implements PropertyChangeListener {
    CssStyleData cssStyleData = null;
    static File currentFile = null;
    BackgroundModel backgroundModel = new BackgroundModel();
    ColorSelectionField colorField = new ColorSelectionField();
    BackgroundPositionData bgPositionData = new BackgroundPositionData();
    DesignProperty designProperty = null;
    private JButton browseButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JPanel colorSelectionPanel;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JComboBox horizontalPosComboBox;
    private JLabel horizontalPosLabel;
    private JComboBox horizontalUnitComboBox;
    private JTextField imageFileField;
    private JLabel imageScrollLabel;
    private JLabel imageTileLabel;
    private JLabel lineHeightLabel;
    private JComboBox repeatComboBox;
    private JComboBox scrollComboBox;
    private JComboBox verticalPosComboBox;
    private JLabel verticalPosLabel;
    private JComboBox verticalUnitComboBox;

    public BackgroundStyleEditor(CssStyleData cssStyleData) {
        this.cssStyleData = cssStyleData;
        this.setName("backgroundStyleEditor");
        this.setDisplayName(NbBundle.getMessage(StyleBuilderDialog.class, (String)"BACKGROUND_EDITOR_DISPNAME"));
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addCssPropertyChangeListener(this);
        this.initialize();
        final JTextField jTextField = (JTextField)this.horizontalPosComboBox.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BackgroundStyleEditor.this.horizontalUnitComboBox.setEnabled(Utils.isInteger(jTextField.getText()));
                        BackgroundStyleEditor.this.enablePositionCombo();
                    }
                });
            }
        });
        final JTextField jTextField2 = (JTextField)this.verticalPosComboBox.getEditor().getEditorComponent();
        jTextField2.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BackgroundStyleEditor.this.verticalUnitComboBox.setEnabled(Utils.isInteger(jTextField2.getText()));
                    }
                });
            }
        });
    }

    public void setDesignProperty(DesignProperty designProperty) {
        this.designProperty = designProperty;
    }

    private void initialize() {
        Object object;
        String string;
        String string2 = this.cssStyleData.getProperty("background-color");
        if (string2 != null) {
            this.colorField.setColorString(string2);
        }
        if ((string = this.cssStyleData.getProperty("background-image")) != null) {
            object = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            this.imageFileField.setText((String)object);
        } else {
            this.imageFileField.setText(CssStyleData.NOT_SET);
        }
        object = this.backgroundModel.getBackgroundRepeatList();
        this.repeatComboBox.setModel(object);
        String string3 = this.cssStyleData.getProperty("background-repeat");
        if (string3 != null) {
            this.repeatComboBox.setSelectedItem(string3);
        } else {
            this.repeatComboBox.setSelectedIndex(0);
        }
        DefaultComboBoxModel defaultComboBoxModel = this.backgroundModel.getBackgroundScrollList();
        this.scrollComboBox.setModel(defaultComboBoxModel);
        String string4 = this.cssStyleData.getProperty("background-attachment");
        if (string4 != null) {
            this.scrollComboBox.setSelectedItem(string4);
        } else {
            this.scrollComboBox.setSelectedIndex(0);
        }
        this.horizontalPosComboBox.setModel(this.backgroundModel.getBackgroundPositionList());
        this.verticalPosComboBox.setModel(this.backgroundModel.getBackgroundPositionList());
        this.horizontalUnitComboBox.setModel(this.backgroundModel.getBackgroundPositionUnitList());
        this.verticalUnitComboBox.setModel(this.backgroundModel.getBackgroundPositionUnitList());
        String string5 = this.cssStyleData.getProperty("background-position");
        if (string5 != null) {
            this.bgPositionData.setBackgroundPosition(string5);
            this.horizontalPosComboBox.setSelectedItem(this.bgPositionData.getHorizontalValue());
            this.horizontalUnitComboBox.setSelectedItem(this.bgPositionData.getHorizontalUnit());
            this.verticalPosComboBox.setSelectedItem(this.bgPositionData.getVerticalValue());
            this.verticalUnitComboBox.setSelectedItem(this.bgPositionData.getVerticalUnit());
        } else {
            this.horizontalPosComboBox.setSelectedIndex(0);
            this.verticalPosComboBox.setSelectedIndex(0);
        }
        this.verticalPosComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.errorLabel.setText("");
            }
        });
        this.horizontalPosComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.errorLabel.setText("");
            }
        });
        this.scrollComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.errorLabel.setText("");
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setBackgroundColor();
    }

    private void initComponents() {
        this.colorPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.browseButton = new JButton();
        this.imageFileField = new JTextField();
        this.lineHeightLabel = new JLabel();
        this.imageTileLabel = new JLabel();
        this.imageScrollLabel = new JLabel();
        this.scrollComboBox = new JComboBox();
        this.repeatComboBox = new JComboBox();
        this.horizontalPosLabel = new JLabel();
        this.verticalPosLabel = new JLabel();
        this.horizontalPosComboBox = new JComboBox();
        this.verticalPosComboBox = new JComboBox();
        this.horizontalUnitComboBox = new JComboBox();
        this.verticalUnitComboBox = new JComboBox();
        this.colorSelectionPanel = new JPanel();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorLabel.setLabelFor(this.colorPanel);
        this.colorLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_COLOR"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.colorPanel.add((Component)this.colorLabel, gridBagConstraints);
        this.browseButton.setText("...");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle");
        this.browseButton.setToolTipText(resourceBundle.getString("BG_SELECTION_BUTTON_TOOLTIP"));
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundStyleEditor.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.colorPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("BG_SELECTION_BUTTON_ACCESSIBLE_NAME"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("BG_SELECTION_BUTTON_ACCESSIBLE_DESC"));
        this.imageFileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundStyleEditor.this.imageFileFieldActionPerformed(actionEvent);
            }
        });
        this.imageFileField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.imageFileFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.colorPanel.add((Component)this.imageFileField, gridBagConstraints);
        this.imageFileField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_IMAGE_FIELD_ACCESS_DESC"));
        this.lineHeightLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("BACKGROUND_IMAGE_MNEMONIC").charAt(0));
        this.lineHeightLabel.setLabelFor(this.imageFileField);
        this.lineHeightLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_IMAGE"));
        this.lineHeightLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.lineHeightLabel, gridBagConstraints);
        this.imageTileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("BACKGROUNDTILE_MNEMONIC").charAt(0));
        this.imageTileLabel.setLabelFor(this.repeatComboBox);
        this.imageTileLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUNDTILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.imageTileLabel, gridBagConstraints);
        this.imageScrollLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("BACKGROUND_SCROLL_MNEMONIC").charAt(0));
        this.imageScrollLabel.setLabelFor(this.scrollComboBox);
        this.imageScrollLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_SCROLL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.imageScrollLabel, gridBagConstraints);
        this.scrollComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.scrollComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.scrollComboBox, gridBagConstraints);
        this.scrollComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("SCROLL_COMBO_ACCESSIBLE_DESC"));
        this.repeatComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.repeatComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.repeatComboBox, gridBagConstraints);
        this.repeatComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TILE_COMBO_ACCESSIBLE_DESC"));
        this.horizontalPosLabel.setLabelFor(this.horizontalPosComboBox);
        this.horizontalPosLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_HORIZONTAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.horizontalPosLabel, gridBagConstraints);
        this.verticalPosLabel.setLabelFor(this.verticalPosComboBox);
        this.verticalPosLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_VERTICAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.verticalPosLabel, gridBagConstraints);
        this.horizontalPosComboBox.setEditable(true);
        this.horizontalPosComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.horizontalPosComboBoxItemStateChanged(itemEvent);
            }
        });
        this.horizontalPosComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundStyleEditor.this.horizontalPosComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.horizontalPosComboBox, gridBagConstraints);
        this.horizontalPosComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("HORIZPOS_COMBO_ACCESSIBLE_DESC"));
        this.verticalPosComboBox.setEditable(true);
        this.verticalPosComboBox.setEnabled(false);
        this.verticalPosComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.verticalPosComboBoxItemStateChanged(itemEvent);
            }
        });
        this.verticalPosComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundStyleEditor.this.verticalPosComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.verticalPosComboBox, gridBagConstraints);
        this.verticalPosComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("VERTPOS_COMBO_ACCESSIBLE_DESC"));
        this.horizontalUnitComboBox.setEnabled(false);
        this.horizontalUnitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.horizontalUnitComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.horizontalUnitComboBox, gridBagConstraints);
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("HORIZPOS_UNIT_COMBO_ACCESSIBLE_NAME"));
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("HORIZPOS_UNIT_COMBO_ACCESSIBLE_DESC"));
        this.verticalUnitComboBox.setEnabled(false);
        this.verticalUnitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.verticalUnitComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.verticalUnitComboBox, gridBagConstraints);
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("VERTPOS_UNIT_COMBO_ACCESSIBLE_NAME"));
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("VERTPOS_UNIT_COMBO_ACCESSIBLE_DESC"));
        this.colorSelectionPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.colorPanel.add((Component)this.colorSelectionPanel, gridBagConstraints);
        this.add((Component)this.colorPanel, "North");
        this.errorPanel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.errorPanel.setLayout(new BorderLayout());
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorLabel.setMinimumSize(new Dimension(200, 20));
        this.errorLabel.setPreferredSize(new Dimension(200, 20));
        this.errorPanel.add((Component)this.errorLabel, "Center");
        this.add((Component)this.errorPanel, "South");
    }

    private void verticalUnitComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setVerticalUnit((String)this.verticalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalUnitComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setHorizontalUnit((String)this.horizontalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void verticalPosComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setVerticalValue((String)this.verticalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void verticalPosComboBoxActionPerformed(ActionEvent actionEvent) {
        this.bgPositionData.setVerticalValue((String)this.verticalPosComboBox.getSelectedItem());
        this.setBackgroundPosition();
    }

    private void horizontalPosComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setHorizontalValue((String)this.horizontalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalPosComboBoxActionPerformed(ActionEvent actionEvent) {
        this.bgPositionData.setHorizontalValue((String)this.horizontalPosComboBox.getSelectedItem());
        this.setBackgroundPosition();
    }

    private void scrollComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setBackgroundAttachment();
    }

    private void repeatComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBackgroundRepeat();
        }
    }

    private void imageFileFieldFocusLost(FocusEvent focusEvent) {
        this.setBackgroundImage();
    }

    private void imageFileFieldActionPerformed(ActionEvent actionEvent) {
        this.setBackgroundImage();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        BackgroundImageUrlDialog backgroundImageUrlDialog = new BackgroundImageUrlDialog();
        if (this.designProperty != null) {
            backgroundImageUrlDialog.setDesignContext(this.designProperty.getDesignBean().getDesignContext());
        }
        backgroundImageUrlDialog.initialize();
        backgroundImageUrlDialog.showDialog();
        if (!backgroundImageUrlDialog.isCancelled()) {
            String string = (String)backgroundImageUrlDialog.getPropertyValue();
            if (string.startsWith("/")) {
                string = "." + string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ' ') {
                    stringBuffer.append("%20");
                    continue;
                }
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
            this.imageFileField.setText(string);
            this.setBackgroundImage();
        }
    }

    private void setBackgroundColor() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.colorField.getColorString());
        this.cssStyleData.modifyProperty("background-color", propertyData.toString());
    }

    private void setBackgroundImage() {
        PropertyData propertyData = new PropertyData();
        String string = this.imageFileField.getText();
        if (string == null || string.equals("")) {
            string = CssStyleData.NOT_SET;
            this.imageFileField.setText(string);
        }
        propertyData.setValue("url(" + string + ")");
        this.cssStyleData.modifyProperty("background-image", propertyData.toString());
    }

    private void setBackgroundRepeat() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.repeatComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("background-repeat", propertyData.toString());
    }

    private void setBackgroundAttachment() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.scrollComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("background-attachment", propertyData.toString());
    }

    private void setBackgroundPosition() {
        String string = this.bgPositionData.toString();
        this.cssStyleData.modifyProperty("background-position", string);
        this.enablePositionCombo();
    }

    private void enablePositionCombo() {
        String string = this.bgPositionData.getHorizontalValue();
        if (Utils.isInteger(string)) {
            this.horizontalUnitComboBox.setEnabled(true);
        } else {
            this.horizontalUnitComboBox.setEnabled(false);
        }
        if (string.equals("") || string.startsWith(CssStyleData.NOT_SET) || string.startsWith(CssStyleData.VALUE)) {
            this.verticalPosComboBox.setEnabled(false);
            this.verticalUnitComboBox.setEnabled(false);
        } else {
            this.verticalPosComboBox.setEnabled(true);
            this.verticalUnitComboBox.setEnabled(true);
        }
        String string2 = this.bgPositionData.getVerticalValue();
        if (Utils.isInteger(string2)) {
            this.verticalUnitComboBox.setEnabled(true);
        } else {
            this.verticalUnitComboBox.setEnabled(false);
        }
    }

    class ImageFileFilter
    extends FileFilter {
        ImageFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            if (string != null) {
                return string.toLowerCase().equals("gif") || string.toLowerCase().equals("jpg") || string.toLowerCase().equals("png");
            }
            return false;
        }

        public String getDescription() {
            return NbBundle.getMessage(BackgroundStyleEditor.class, (String)"IMAGE_FILE_FILTER");
        }
    }
}

