/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.propertyeditors.css.model.MarginPaddingModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.PropertyWithUnitData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.Utils;

public class MarginWidthField
extends JPanel {
    PropertyWithUnitData borderMarginData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox borderMarginCombo;
    private JComboBox borderMarginUnitCombo;

    public MarginWidthField() {
        this.initComponents();
        this.borderMarginCombo.setModel(this.marginPaddingModel.getMarginList());
        this.borderMarginUnitCombo.setModel(this.marginPaddingModel.getMarginUnitList());
        final JTextField jTextField = (JTextField)this.borderMarginCombo.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MarginWidthField.this.borderMarginUnitCombo.setEnabled(Utils.isInteger(jTextField.getText()));
                    }
                });
            }
        });
    }

    public void addCssPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeCssPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setMarginString(String string) {
        if (string != null && !string.equals("")) {
            if (Utils.isInteger(string)) {
                this.setMarginValue(string);
            } else {
                String string2 = this.getUnit(string);
                this.setMarginUnit(string2);
                this.setMarginValue(string.replaceAll(string2, "").trim());
            }
        } else {
            this.setMarginValue(null);
            this.setMarginUnit(null);
        }
    }

    public String getMarginString() {
        return this.borderMarginData.toString();
    }

    private String getUnit(String string) {
        DefaultComboBoxModel defaultComboBoxModel = this.marginPaddingModel.getMarginUnitList();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string.trim().endsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    public void setMarginValue(String string) {
        if (string == null || string.equals("")) {
            this.borderMarginCombo.setSelectedIndex(0);
        } else {
            this.borderMarginCombo.setSelectedItem(string);
            this.borderMarginData.setValue(string);
        }
    }

    public void setMarginUnit(String string) {
        if (string == null || string.equals("")) {
            this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(string) != -1) {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf(string));
            } else {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
            }
            this.borderMarginData.setUnit(string);
        }
    }

    private void initComponents() {
        this.borderMarginCombo = new JComboBox();
        this.borderMarginUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderMarginCombo.setEditable(true);
        this.borderMarginCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MarginWidthField.this.borderMarginComboItemStateChanged(itemEvent);
            }
        });
        this.borderMarginCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarginWidthField.this.borderMarginComboActionPerformed(actionEvent);
            }
        });
        this.borderMarginCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MarginWidthField.this.borderMarginComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderMarginCombo, "Center");
        this.borderMarginUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MarginWidthField.this.borderMarginUnitComboItemStateChanged(itemEvent);
            }
        });
        this.borderMarginUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MarginWidthField.this.borderMarginUnitComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderMarginUnitCombo, "East");
    }

    private void borderMarginUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setborderMargin();
        }
    }

    private void borderMarginUnitComboFocusLost(FocusEvent focusEvent) {
        this.setborderMargin();
    }

    public void setAccessibleName(String string, String string2) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleName(string);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleName(string2);
    }

    public void setAccessibleDescription(String string, String string2) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleDescription(string);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleDescription(string2);
    }

    private void borderMarginComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setborderMargin();
        }
    }

    private void borderMarginComboFocusLost(FocusEvent focusEvent) {
        this.setborderMargin();
    }

    private void borderMarginComboActionPerformed(ActionEvent actionEvent) {
        this.setborderMargin();
    }

    private void setborderMargin() {
        String string = this.borderMarginData.toString();
        this.borderMarginData.setUnit(this.borderMarginUnitCombo.getSelectedItem().toString());
        this.borderMarginData.setValue(this.borderMarginCombo.getSelectedItem().toString());
        this.propertyChangeSupport.firePropertyChange("margin-width", string, this.borderMarginData.toString());
    }
}

