/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupDesignContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.netbeans.modules.visualweb.propertyeditors.css.BackgroundStyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.BorderStyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.FontStyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.MarginStyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.PositionStyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleEditorListPanel;
import org.netbeans.modules.visualweb.propertyeditors.css.TextBlockStyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleParser;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StyleBuilderPanel
extends JPanel
implements PropertyChangeListener {
    JPanel currentEditor;
    String currentStyle = null;
    private CssStyleData cssStyleData = new CssStyleData();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    DesignProperty designProperty = null;
    Image previewImage = null;
    StyleEditorListPanel styleEditorListPanel = null;
    List styleEditorList = new ArrayList();
    String noPreviewLabel = NbBundle.getMessage(StyleBuilderPanel.class, (String)"NO_PREVIEW");
    private JPanel editorListPanel;
    private JPanel editorPanel;
    private JSplitPane editorSplitPane;
    private JSplitPane mainSplitPane;
    private JPanel previewPanel;
    private JScrollPane previewScrollPane;
    private JScrollPane previewScrollPane1;
    private JSplitPane styleEditorSplitPane;
    private JLabel styleLabel;
    private JPanel styleStringPanel;
    private JScrollPane styleStringScroll;
    private JTextArea styleTextArea;

    public StyleBuilderPanel() {
        this.initComponents();
        this.initialize();
    }

    public StyleBuilderPanel(String string, DesignProperty designProperty) {
        this.initComponents();
        this.designProperty = designProperty;
        CssStyleParser cssStyleParser = new CssStyleParser(this.cssStyleData, designProperty);
        this.cssStyleData = cssStyleParser.parse(string);
        this.currentStyle = this.cssStyleData.getStyleValue();
        this.initialize();
        this.styleTextArea.setText(this.currentStyle);
        this.displayPreviewImage();
    }

    public StyleBuilderPanel(String string) {
        this(string, null);
    }

    private void initialize() {
        this.styleEditorListPanel = new StyleEditorListPanel(this, this.cssStyleData);
        this.styleEditorList.add(new FontStyleEditor(this.cssStyleData));
        BackgroundStyleEditor backgroundStyleEditor = new BackgroundStyleEditor(this.cssStyleData);
        backgroundStyleEditor.setDesignProperty(this.designProperty);
        this.styleEditorList.add(backgroundStyleEditor);
        this.styleEditorList.add(new TextBlockStyleEditor(this.cssStyleData));
        this.styleEditorList.add(new BorderStyleEditor(this.cssStyleData));
        this.styleEditorList.add(new MarginStyleEditor(this.cssStyleData));
        this.styleEditorList.add(new PositionStyleEditor(this.cssStyleData));
        for (int i = 0; i < this.styleEditorList.size(); ++i) {
            StyleEditor styleEditor = (StyleEditor)this.styleEditorList.get(i);
            this.styleEditorListPanel.addEditor(styleEditor);
        }
        this.styleEditorListPanel.setSelectedEditor((StyleEditor)this.styleEditorList.get(0));
        this.setEditorListPanel(this.styleEditorListPanel);
        this.cssStyleData.addCssPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.styleTextArea.setText(this.cssStyleData.getStyleValue());
        this.propertyChangeSupport.firePropertyChange("style", this.currentStyle, this.cssStyleData.getStyleValue());
        this.currentStyle = this.cssStyleData.getStyleValue();
        this.displayPreviewImage();
    }

    private void displayPreviewImage() {
        if (this.designProperty != null) {
            try {
                MarkupDesignBean markupDesignBean = (MarkupDesignBean)this.designProperty.getDesignBean();
                MarkupDesignContext markupDesignContext = (MarkupDesignContext)markupDesignBean.getDesignContext();
                Dimension dimension = this.previewScrollPane.getViewport().getViewSize();
                this.previewImage = markupDesignContext.getCssPreviewImage(this.currentStyle, null, markupDesignBean, (int)dimension.getWidth(), (int)dimension.getHeight());
                if (this.previewImage != null) {
                    this.previewPanel.setPreferredSize(new Dimension(this.previewImage.getWidth(this) + 10, this.previewImage.getHeight(this) + 10));
                }
                this.repaint();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(4096, (Throwable)exception);
            }
        }
    }

    public void addCssPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeCssPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getStyleString() {
        return this.cssStyleData.toString();
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.styleStringPanel = new JPanel();
        this.styleStringScroll = new JScrollPane();
        this.styleTextArea = new JTextArea();
        this.styleLabel = new JLabel();
        this.styleEditorSplitPane = new JSplitPane();
        this.editorListPanel = new JPanel();
        this.editorSplitPane = new JSplitPane();
        this.previewScrollPane = new JScrollPane();
        this.previewPanel = new PreviewPanel();
        this.previewScrollPane1 = new JScrollPane();
        this.editorPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.setResizeWeight(1.0);
        this.mainSplitPane.setPreferredSize(new Dimension(400, 650));
        this.styleStringPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.styleStringPanel.setPreferredSize(new Dimension(375, 100));
        this.styleStringPanel.setLayout(new GridBagLayout());
        this.styleStringScroll.setPreferredSize(new Dimension(300, 100));
        this.styleTextArea.setColumns(50);
        this.styleTextArea.setLineWrap(true);
        this.styleTextArea.setRows(3);
        this.styleTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.styleTextArea.setMinimumSize(new Dimension(110, 75));
        this.styleTextArea.setPreferredSize(new Dimension(410, 75));
        this.styleTextArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                StyleBuilderPanel.this.styleTextAreaFocusLost(focusEvent);
            }
        });
        this.styleStringScroll.setViewportView(this.styleTextArea);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle");
        this.styleTextArea.getAccessibleContext().setAccessibleName(resourceBundle.getString("STYLE_EDITOR_STYLE_TEXT_ACCESSIBLE_NAME"));
        this.styleTextArea.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("STYLE_EDITOR_STYLE_TEXT_ACCESSIBLE_DESC"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.styleStringPanel.add((Component)this.styleStringScroll, gridBagConstraints);
        this.styleLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("CSS_STYLE_MNEMONIC").charAt(0));
        this.styleLabel.setLabelFor(this.styleTextArea);
        this.styleLabel.setText(resourceBundle.getString("CSS_STYLE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.styleStringPanel.add((Component)this.styleLabel, gridBagConstraints);
        this.mainSplitPane.setBottomComponent(this.styleStringPanel);
        this.editorListPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.editorListPanel.setLayout(new BorderLayout());
        this.styleEditorSplitPane.setLeftComponent(this.editorListPanel);
        this.editorSplitPane.setOrientation(0);
        this.editorSplitPane.setResizeWeight(1.0);
        this.previewScrollPane.setAutoscrolls(true);
        this.previewScrollPane.setDoubleBuffered(true);
        this.previewScrollPane.setPreferredSize(new Dimension(400, 150));
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewScrollPane.setViewportView(this.previewPanel);
        this.editorSplitPane.setBottomComponent(this.previewScrollPane);
        this.previewScrollPane1.setAutoscrolls(true);
        this.previewScrollPane1.setDoubleBuffered(true);
        this.previewScrollPane1.setPreferredSize(new Dimension(400, 350));
        this.editorPanel.setLayout(new BorderLayout());
        this.previewScrollPane1.setViewportView(this.editorPanel);
        this.editorSplitPane.setTopComponent(this.previewScrollPane1);
        this.styleEditorSplitPane.setRightComponent(this.editorSplitPane);
        this.mainSplitPane.setTopComponent(this.styleEditorSplitPane);
        this.add((Component)this.mainSplitPane, "Center");
    }

    private void styleTextAreaFocusLost(FocusEvent focusEvent) {
        this.propertyChangeSupport.firePropertyChange("style", this.currentStyle, this.styleTextArea.getText());
    }

    public void setEditorListPanel(JPanel jPanel) {
        this.editorListPanel.add((Component)jPanel, "Center");
        this.repaint();
    }

    public void setEditorPanel(JPanel jPanel) {
        if (this.currentEditor != null) {
            this.editorPanel.remove(this.currentEditor);
        }
        this.currentEditor = jPanel;
        this.editorPanel.add((Component)this.currentEditor, "Center");
        this.validate();
        this.repaint();
    }

    class PreviewPanel
    extends JPanel {
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (StyleBuilderPanel.this.previewImage != null) {
                int n = 3;
                int n2 = 3;
                int n3 = StyleBuilderPanel.this.previewImage.getWidth(this);
                int n4 = StyleBuilderPanel.this.previewImage.getHeight(this);
                if (n3 < this.getWidth()) {
                    n = (this.getWidth() - n3) / 2;
                    n2 = (this.getHeight() - n4) / 2;
                }
                graphics2D.drawImage(StyleBuilderPanel.this.previewImage, n, n2, this);
            } else {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(StyleBuilderPanel.this.noPreviewLabel, fontRenderContext);
                int n = (this.getWidth() - (int)rectangle2D.getWidth()) / 2;
                int n5 = (this.getHeight() - (int)rectangle2D.getHeight()) / 2;
                graphics2D.drawString(StyleBuilderPanel.this.noPreviewLabel, n, n5);
            }
        }
    }
}

