/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELExtensibilityComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationVisitor;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;

public abstract class AbstractValidator
implements Validator {
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        Set<Object> set;
        if (!(model instanceof WSDLModel)) {
            return EMPTY_RESULT;
        }
        WSDLModel wSDLModel = (WSDLModel)model;
        if (wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
            return EMPTY_RESULT;
        }
        Set<Model> set2 = Collections.singleton(model);
        ValidationVisitor validationVisitor = this.getVisitor();
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions != null) {
            List list = definitions.getExtensibilityElements();
            for (ExtensibilityElement extensibilityElement : list) {
                if (!(extensibilityElement instanceof BPELExtensibilityComponent)) continue;
                ((BPELExtensibilityComponent)extensibilityElement).accept(validationVisitor);
            }
        }
        if ((set = validationVisitor.getResultItems()) == null) {
            set = Collections.EMPTY_SET;
        }
        return new ValidationResult(set, set2);
    }

    protected abstract ValidationVisitor getVisitor();
}

