/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Action;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternChildren;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class PatternNode
extends AbstractNode {
    private static final SystemAction[] DEFAULT_ACTIONS = new SystemAction[]{SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(PropertiesAction.class)};
    protected Pattern pattern;
    protected boolean writeable;

    public PatternNode(Pattern pattern, Children children, boolean bl) {
        super(children);
        this.pattern = pattern;
        this.writeable = bl;
        this.setActions(DEFAULT_ACTIONS);
        this.displayFormat = null;
    }

    public PatternNode(ClassPattern classPattern, boolean bl) {
        super((Children)new PatternChildren(classPattern.getPatterns()));
        this.writeable = bl;
        this.pattern = classPattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Image getIcon(int n) {
        return this.pattern.getIcon();
    }

    public Image getOpenedIcon(int n) {
        return this.pattern.getIcon();
    }

    public String getDisplayName() {
        return this.pattern.getName();
    }

    public String getHtmlDisplayName() {
        return this.pattern.getHtmlDisplayName();
    }

    public String getShortDescription() {
        return super.getShortDescription();
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public boolean canRename() {
        return this.writeable;
    }

    public boolean canDestroy() {
        return this.writeable;
    }

    public Transferable clipboardCopy() throws IOException {
        return super.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.writeable) {
            throw new IOException();
        }
        return super.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.writeable;
    }

    public void setActions(SystemAction[] systemActionArray) {
        this.systemActions = systemActionArray;
    }

    public final void setName(String string) {
    }

    public final void superSetName(String string) {
        super.setName(string);
    }

    protected void setPatternName(String string) {
        throw new UnsupportedOperationException();
    }

    public void destroy() throws IOException {
    }

    public void updateRecursively(Pattern pattern) {
        Object object;
        Children children = this.getChildren();
        if (children instanceof PatternChildren) {
            object = new HashSet<Pattern>(pattern.getPatterns());
            Node[] nodeArray = children.getNodes(true);
            HashMap<Pattern, PatternNode> hashMap = new HashMap<Pattern, PatternNode>();
            for (Node node : nodeArray) {
                hashMap.put(((PatternNode)node).pattern, (PatternNode)node);
            }
            ((PatternChildren)children).resetKeys(pattern.getPatterns());
            nodeArray = children.getNodes(true);
            for (Pattern pattern2 : pattern.getPatterns()) {
                PatternNode patternNode = (PatternNode)((Object)hashMap.get(pattern2));
                if (patternNode == null) continue;
                if (!((HashSet)object).contains(pattern2) && patternNode.getChildren() != Children.LEAF) {
                    this.pattern.getPatternAnalyser().getUI().expandNode((Node)patternNode);
                }
                patternNode.updateRecursively(pattern2);
            }
        }
        object = this.pattern;
        this.pattern = pattern;
        if (((Pattern)object).getHtmlDisplayName() != null && !((Pattern)object).getHtmlDisplayName().equals(this.pattern.getHtmlDisplayName())) {
            this.fireDisplayNameChange(((Pattern)object).name, this.pattern.name);
        }
        if (((Pattern)object).getIcon() != null && ((Pattern)object).getIcon() != this.pattern.getIcon()) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }
}

