/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;

public class TmpPattern {

    public static class EventSet {
        ExecutableElement addListenerMethod;
        ExecutableElement removeListenerMethod;
        boolean isUnicast;
        TypeMirror type;
        String name;

        public EventSet(CompilationInfo compilationInfo, ExecutableElement executableElement, ExecutableElement executableElement2) {
            if (executableElement == null || executableElement2 == null) {
                throw new NullPointerException();
            }
            this.addListenerMethod = executableElement;
            this.removeListenerMethod = executableElement2;
            this.isUnicast = this.testUnicast(compilationInfo);
            this.type = this.findEventSetType();
            this.name = this.findEventSetName();
        }

        EventSet(EventSet eventSet, EventSet eventSet2) {
            this.addListenerMethod = eventSet2.addListenerMethod;
            this.removeListenerMethod = eventSet2.removeListenerMethod;
            this.isUnicast = eventSet2.isUnicast;
            this.type = eventSet2.type;
            this.name = eventSet2.name;
        }

        EventSetPattern createPattern(PatternAnalyser patternAnalyser) {
            return new EventSetPattern(patternAnalyser, this.addListenerMethod, this.removeListenerMethod, this.name, this.type, this.isUnicast);
        }

        private TypeMirror findEventSetType() {
            return this.addListenerMethod.getParameters().get(0).asType();
        }

        private String findEventSetName() {
            String string = BeanUtils.nameAsString(this.addListenerMethod).substring(3);
            this.name = Introspector.decapitalize(string);
            return this.name;
        }

        private boolean testUnicast(CompilationInfo compilationInfo) {
            return BeanUtils.isThrowing(compilationInfo, this.addListenerMethod, "java.util.TooManyListenersException");
        }
    }

    public static class IdxProperty
    extends Property {
        private ExecutableElement indexedGetterMethod;
        private ExecutableElement indexedSetterMethod;
        private TypeMirror indexedType;

        public IdxProperty(CompilationInfo compilationInfo, ExecutableElement executableElement, ExecutableElement executableElement2, ExecutableElement executableElement3, ExecutableElement executableElement4) throws IntrospectionException {
            super(executableElement, executableElement2);
            this.indexedGetterMethod = executableElement3;
            this.indexedSetterMethod = executableElement4;
            this.indexedType = this.findIndexedPropertyType();
            if (this.type == null && this.indexedType != null) {
                this.type = compilationInfo.getTypes().getArrayType(this.indexedType);
            }
            this.name = this.findIndexedPropertyName();
        }

        IdxProperty(Property property, Property property2) {
            super(property, property2);
            IdxProperty idxProperty;
            if (property instanceof IdxProperty) {
                idxProperty = (IdxProperty)property;
                this.indexedGetterMethod = idxProperty.indexedGetterMethod;
                this.indexedSetterMethod = idxProperty.indexedSetterMethod;
                this.indexedType = idxProperty.indexedType;
                TypeMirror typeMirror = this.type = this.type == null ? idxProperty.type : this.type;
            }
            if (property2 instanceof IdxProperty) {
                idxProperty = (IdxProperty)property2;
                if (idxProperty.indexedGetterMethod != null) {
                    this.indexedGetterMethod = idxProperty.indexedGetterMethod;
                }
                if (idxProperty.indexedSetterMethod != null) {
                    this.indexedSetterMethod = idxProperty.indexedSetterMethod;
                }
                this.indexedType = idxProperty.indexedType;
                this.type = this.type == null ? idxProperty.type : this.type;
            }
            this.name = this.findIndexedPropertyName();
        }

        public IdxPropertyPattern createPattern(PatternAnalyser patternAnalyser) throws IntrospectionException {
            return new IdxPropertyPattern(patternAnalyser, this.getterMethod, this.setterMethod, this.indexedGetterMethod, this.indexedSetterMethod, this.estimatedField, this.type, this.indexedType, this.name);
        }

        private TypeMirror findIndexedPropertyType() throws IntrospectionException {
            VariableElement variableElement;
            List<? extends VariableElement> list;
            this.indexedType = null;
            if (this.indexedGetterMethod != null) {
                list = this.indexedGetterMethod.getParameters();
                if (list.size() != 1) {
                    throw new IntrospectionException("bad indexed read method arg count");
                }
                variableElement = list.get(0);
                if (variableElement.asType().getKind() != TypeKind.INT) {
                    throw new IntrospectionException("not int index to indexed read method");
                }
                this.indexedType = this.indexedGetterMethod.getReturnType();
                if (this.indexedType.getKind() == TypeKind.VOID) {
                    throw new IntrospectionException("indexed read method return void");
                }
            }
            if (this.indexedSetterMethod != null) {
                list = this.indexedSetterMethod.getParameters();
                if (list.size() != 2) {
                    throw new IntrospectionException("bad indexed write method arg count");
                }
                variableElement = list.get(0);
                if (variableElement.asType().getKind() != TypeKind.INT) {
                    throw new IntrospectionException("non int index to indexed write method");
                }
                VariableElement variableElement2 = list.get(1);
                if (this.indexedType != null && !((Object)this.indexedType).equals(variableElement2.asType())) {
                    throw new IntrospectionException("type mismatch between indexed read and write methods");
                }
                this.indexedType = variableElement2.asType();
            }
            if (!((list = this.type) == null || list.getKind() == TypeKind.ARRAY && ((Object)this.indexedType).equals(((ArrayType)((Object)list)).getComponentType()))) {
                throw new IntrospectionException("type mismatch between property type and indexed type");
            }
            return this.indexedType;
        }

        String findIndexedPropertyName() {
            String string = this.findPropertyName();
            if (string == null) {
                String string2 = null;
                if (this.indexedGetterMethod != null) {
                    string2 = BeanUtils.nameAsString(this.indexedGetterMethod);
                } else if (this.indexedSetterMethod != null) {
                    string2 = BeanUtils.nameAsString(this.indexedSetterMethod);
                } else {
                    throw new InternalError("Indexed property with all methods == null");
                }
                return string2.startsWith("is") ? Introspector.decapitalize(string2.substring(2)) : Introspector.decapitalize(string2.substring(3));
            }
            return string;
        }
    }

    public static class Property {
        ExecutableElement getterMethod;
        ExecutableElement setterMethod;
        VariableElement estimatedField;
        TypeMirror type;
        String name;

        public Property(ExecutableElement executableElement, ExecutableElement executableElement2) throws IntrospectionException {
            this.getterMethod = executableElement;
            this.setterMethod = executableElement2;
            this.type = this.findPropertyType();
            this.name = this.findPropertyName();
        }

        Property(Property property, Property property2) {
            ExecutableElement executableElement = property.getterMethod;
            ExecutableElement executableElement2 = property2.getterMethod;
            this.getterMethod = executableElement;
            if (executableElement2 != null) {
                this.getterMethod = executableElement2;
            }
            if (executableElement != null && executableElement2 != null && executableElement.getEnclosingElement() == executableElement2.getEnclosingElement() && executableElement.getReturnType().getKind() == TypeKind.BOOLEAN && executableElement2.getReturnType().getKind() == TypeKind.BOOLEAN && BeanUtils.nameAsString(executableElement).indexOf("is") == 0 && BeanUtils.nameAsString(executableElement2).indexOf("get") == 0) {
                this.getterMethod = executableElement;
            }
            this.setterMethod = property.setterMethod;
            if (property2.setterMethod != null) {
                this.setterMethod = property2.setterMethod;
            }
            try {
                this.type = this.findPropertyType();
            }
            catch (IntrospectionException introspectionException) {
                throw new InternalError("Mixing invalid PropertyPattrens" + introspectionException);
            }
            this.name = this.findPropertyName();
        }

        public PropertyPattern createPattern(PatternAnalyser patternAnalyser) throws IntrospectionException {
            return new PropertyPattern(patternAnalyser, this.getterMethod, this.setterMethod, this.estimatedField, this.type, this.name);
        }

        TypeMirror findPropertyType() throws IntrospectionException {
            TypeMirror typeMirror = null;
            if (this.getterMethod != null) {
                if (!this.getterMethod.getParameters().isEmpty()) {
                    throw new IntrospectionException("bad read method arg count");
                }
                typeMirror = this.getterMethod.getReturnType();
                if (typeMirror.getKind() == TypeKind.VOID) {
                    throw new IntrospectionException("read method " + this.getterMethod.getSimpleName() + " returns void");
                }
            }
            if (this.setterMethod != null) {
                List<? extends VariableElement> list = this.setterMethod.getParameters();
                if (list.size() != 1) {
                    throw new IntrospectionException("bad write method arg count");
                }
                VariableElement variableElement = list.get(0);
                if (typeMirror != null && !((Object)typeMirror).equals(variableElement.asType())) {
                    throw new IntrospectionException("type mismatch between read and write methods");
                }
                typeMirror = variableElement.asType();
            }
            return typeMirror;
        }

        String findPropertyName() {
            String string = null;
            if (this.getterMethod != null) {
                string = BeanUtils.nameAsString(this.getterMethod);
            } else if (this.setterMethod != null) {
                string = BeanUtils.nameAsString(this.setterMethod);
            } else {
                return null;
            }
            return string.startsWith("is") ? Introspector.decapitalize(string.substring(2)) : Introspector.decapitalize(string.substring(3));
        }
    }
}

