/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceHelper {
    private static final String PERSISTENCE_DTD_1_0 = "resources/persistence_1_0.dtd";
    private static final String PERSISTENCE_UNIT_TAG = "persistence-unit";
    private static final String CLASS_TAG = "class";
    private static final String PROPERTIES_TAG = "properties";
    private static final String NAME_ATTR = "name";
    private static final String EXCLUDE_UNLISTED_CLASSES_TAG = "exclude-unlisted-classes";
    private static int TIME_TO_WAIT = 300;

    public static String getPersistenceUnitName(Project project) {
        Document document;
        Element element;
        FileObject fileObject = PersistenceHelper.getPersistenceXML(project);
        if (fileObject != null && (element = PersistenceHelper.getPersistenceUnitElement(document = PersistenceHelper.getDocument(fileObject))) != null) {
            return element.getAttribute(NAME_ATTR);
        }
        return null;
    }

    public static void addEntityClasses(Project project, Collection<String> collection) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        FileObject fileObject = PersistenceHelper.getPersistenceXML(project);
        Document document = PersistenceHelper.getDocument(fileObject);
        Element element = PersistenceHelper.getPersistenceUnitElement(document);
        NodeList nodeList = element.getElementsByTagName(CLASS_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            arrayList.remove(PersistenceHelper.getValue((Element)nodeList.item(i)));
        }
        Element element2 = PersistenceHelper.getPropertiesElement(document);
        for (String string : arrayList) {
            element.insertBefore(PersistenceHelper.createElement(document, CLASS_TAG, string), element2);
        }
        PersistenceHelper.writeDocument(fileObject, document);
    }

    public static void unsetExcludeEnlistedClasses(Project project) throws IOException {
        FileObject fileObject = PersistenceHelper.getPersistenceXML(project);
        Document document = PersistenceHelper.getDocument(fileObject);
        Element element = PersistenceHelper.getPersistenceUnitElement(document);
        NodeList nodeList = element.getElementsByTagName(EXCLUDE_UNLISTED_CLASSES_TAG);
        if (nodeList.getLength() > 0) {
            PersistenceHelper.setValue((Element)nodeList.item(0), "false");
        } else {
            element.insertBefore(PersistenceHelper.createElement(document, EXCLUDE_UNLISTED_CLASSES_TAG, "false"), PersistenceHelper.getPropertiesElement(document));
        }
        PersistenceHelper.writeDocument(fileObject, document);
    }

    private static String getValue(Element element) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            return ((Text)node).getWholeText();
        }
        return "";
    }

    private static void setValue(Element element, String string) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            ((Text)node).setData(string);
        }
    }

    private static Element createElement(Document document, String string, String string2) {
        Element element = document.createElement(string);
        Text text = document.createTextNode(string2);
        element.appendChild(text);
        return element;
    }

    private boolean containsValue(Element element, String string) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            return ((Text)node).getWholeText().equals(string);
        }
        return false;
    }

    public static Element getPersistenceUnitElement(Document document) {
        NodeList nodeList = document.getElementsByTagName(PERSISTENCE_UNIT_TAG);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static Element getPropertiesElement(Document document) {
        NodeList nodeList = document.getElementsByTagName(PROPERTIES_TAG);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private static FileObject getPersistenceXML(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            return restSupport.getPersistenceXml();
        }
        return null;
    }

    private static void writeDocument(final FileObject fileObject, final Document document) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FileLock fileLock = null;
                OutputStream outputStream = null;
                try {
                    DocumentType documentType = document.getDoctype();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(document);
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    StreamResult streamResult = new StreamResult(outputStream);
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(dOMSource, streamResult);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }, TIME_TO_WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getDocument(FileObject fileObject) {
        Document document = null;
        DocumentBuilder documentBuilder = PersistenceHelper.getDocumentBuilder();
        if (documentBuilder == null) {
            return null;
        }
        FileLock fileLock = null;
        InputStream inputStream = null;
        try {
            fileLock = fileObject.lock();
            inputStream = fileObject.getInputStream();
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            Exceptions.printStackTrace((Throwable)sAXException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return document;
    }

    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setIgnoringComments(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        documentBuilderFactory.setCoalescing(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new SunWebDTDResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
        }
        return documentBuilder;
    }

    private static class SunWebDTDResolver
    implements EntityResolver {
        private SunWebDTDResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            String string3 = PersistenceHelper.PERSISTENCE_DTD_1_0;
            if (string3 != null) {
                InputStream inputStream = this.getClass().getResourceAsStream(string3);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                return new InputSource(inputStreamReader);
            }
            return null;
        }
    }
}

